/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import java.util.Iterator;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.impl.StringToFileInfoImpl;
import org.eclipse.egerrit.internal.ui.compare.GerritDiffNode;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class HandleFileSelection {
    private GerritClient fGerritClient;
    private ColumnViewer fViewer;

    public HandleFileSelection(GerritClient gerritClient, ColumnViewer viewer) {
        this.fGerritClient = gerritClient;
        this.fViewer = viewer;
    }

    public void showFileSelection() {
        ISelection selection = this.fViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Iterator itr = structuredSelection.iterator();
            String failedFiles = "";
            while (itr.hasNext()) {
                Object element = itr.next();
                if (element == null) {
                    return;
                }
                FileInfo fileInfo = this.fViewer instanceof TableViewer ? ((StringToFileInfoImpl)element).getValue() : ((GerritDiffNode)((Object)element)).getFileInfo();
                String status = fileInfo.getStatus();
                if (status.compareTo("D") == 0) continue;
                if (this.fViewer instanceof TableViewer) {
                    if (!UIUtils.openSingleFile(((StringToFileInfoImpl)element).getKey(), this.fGerritClient, fileInfo.getRevision(), 0)) {
                        failedFiles = String.valueOf(failedFiles) + fileInfo.getPath() + "\n";
                    }
                } else if (!UIUtils.openSingleFile(((StringToFileInfoImpl)fileInfo.eContainer()).getKey(), this.fGerritClient, fileInfo.getRevision(), 0)) {
                    failedFiles = String.valueOf(failedFiles) + fileInfo.getPath() + "\n";
                }
                QueryHelpers.markAsReviewed(this.fGerritClient, fileInfo);
            }
            if (!failedFiles.isEmpty()) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                UIUtils.displayInformation(shell, Messages.UIFilesTable_2, failedFiles);
            }
        }
    }
}

