/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.preferences;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egerrit.internal.core.GerritServerInformation;
import org.eclipse.egerrit.internal.core.ServersStore;
import org.eclipse.egerrit.internal.dashboard.ui.preferences.GerritServerDialog;
import org.eclipse.egerrit.internal.dashboard.ui.preferences.GerritServerTableContentProvider;
import org.eclipse.egerrit.internal.dashboard.ui.preferences.GerritServerTableLabelProvider;
import org.eclipse.egerrit.internal.dashboard.ui.preferences.Messages;
import org.eclipse.egerrit.internal.dashboard.ui.preferences.Utils;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GerritDashboardPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String ID = "org.eclipse.egerrit.dashboard.ui.preferences.GerritDashbardPreferencePage";
    private static final String NEW = Messages.GerritDashboardPreferencePage_0;
    private static final String REMOVE = Messages.GerritDashboardPreferencePage_1;
    private static final String MODIFY = Messages.GerritDashboardPreferencePage_2;
    private static final String TITLE = Messages.GerritDashboardPreferencePage_3;
    private static final String SELECTION_MESSAGE = Messages.GerritDashboardPreferencePage_4;
    private static final String REMOVE_MESSAGE = Messages.GerritDashboardPreferencePage_5;
    private static final String NO_SERVER_SAVED = Messages.GerritDashboardPreferencePage_6;
    private static final String INVALID_SERVER = Messages.GerritDashboardPreferencePage_7;
    private Composite prefsContainer = null;
    private List<GerritServerInformation> listServers = new ArrayList<GerritServerInformation>();
    private TableViewer serverInfoViewer;
    private Button buttonRemove;
    private Button buttonModify;

    public GerritDashboardPreferencePage() {
        super(1);
        this.setDescription(Messages.GerritDashboardPreferencePage_8);
    }

    protected Point doComputeSize() {
        return this.getControl().computeSize(-1, -1, true);
    }

    public void createFieldEditors() {
        this.prefsContainer = new Composite(this.getFieldEditorParent(), 0);
        this.prefsContainer.getParent().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                GerritDashboardPreferencePage.this.prefsContainer.setSize(GerritDashboardPreferencePage.this.prefsContainer.getParent().getSize());
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        GridData prefsContainerData = new GridData(4, 4, true, true);
        this.prefsContainer.setLayoutData((Object)prefsContainerData);
        GridLayout prefsLayout = new GridLayout(3, false);
        this.prefsContainer.setLayout((Layout)prefsLayout);
        Table entriesTable = new Table(this.prefsContainer, 68352);
        entriesTable.setHeaderVisible(true);
        entriesTable.setLinesVisible(true);
        entriesTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 4));
        this.serverInfoViewer = new TableViewer(entriesTable);
        GerritServerTableLabelProvider labelProvider = new GerritServerTableLabelProvider();
        GerritServerTableContentProvider contentProvider = new GerritServerTableContentProvider();
        labelProvider.createColumns(this.serverInfoViewer);
        this.serverInfoViewer.setContentProvider((IContentProvider)contentProvider);
        this.serverInfoViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.serverInfoViewer.addDoubleClickListener(this.doubleClickListener());
        this.serverInfoViewer.addSelectionChangedListener(this.selectionChangedListener());
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(150, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(250, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(150, 50, true));
        entriesTable.setLayout((Layout)tableLayout);
        this.createButtonBar();
        this.listServers = ServersStore.getAllServers();
        this.updateTable();
        if (this.serverInfoViewer.getTable().getItemCount() > 0) {
            this.serverInfoViewer.getTable().setSelection(0);
        }
    }

    private ISelectionChangedListener selectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection tableSelection = GerritDashboardPreferencePage.this.serverInfoViewer.getSelection();
                boolean validSelection = tableSelection instanceof IStructuredSelection && ((IStructuredSelection)tableSelection).getFirstElement() instanceof GerritServerInformation;
                GerritDashboardPreferencePage.this.buttonModify.setEnabled(validSelection);
                GerritDashboardPreferencePage.this.buttonRemove.setEnabled(validSelection);
            }
        };
    }

    private void createButtonBar() {
        Composite buttonBar = new Composite(this.prefsContainer, 0);
        buttonBar.setLayout((Layout)new GridLayout(1, true));
        Button buttonNew = new Button(buttonBar, 8);
        buttonNew.setText(NEW);
        buttonNew.addSelectionListener(this.buttonNewListener());
        buttonNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buttonRemove = new Button(buttonBar, 8);
        this.buttonRemove.setText(REMOVE);
        this.buttonRemove.addSelectionListener(this.buttonRemoveListener());
        this.buttonRemove.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buttonModify = new Button(buttonBar, 8);
        this.buttonModify.setText(MODIFY);
        this.buttonModify.addSelectionListener(this.buttonModifyListener());
        this.buttonModify.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buttonBar.setSize(buttonBar.computeSize(-1, -1));
    }

    private void updateTable() {
        this.serverInfoViewer.setInput((Object)this.listServers.toArray(new GerritServerInformation[this.listServers.size()]));
    }

    public boolean performOk() {
        super.performOk();
        ServersStore.saveServers(this.listServers);
        return true;
    }

    public void init(IWorkbench workbench) {
    }

    public static String getID() {
        return ID;
    }

    private SelectionListener buttonModifyListener() {
        SelectionListener modifyListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection tableSelection = GerritDashboardPreferencePage.this.serverInfoViewer.getSelection();
                int selectedIndex = GerritDashboardPreferencePage.this.serverInfoViewer.getTable().getSelectionIndex();
                if (tableSelection instanceof IStructuredSelection) {
                    Object obj = ((IStructuredSelection)tableSelection).getFirstElement();
                    if (obj instanceof GerritServerInformation) {
                        GerritDashboardPreferencePage.this.processDialogInfo((GerritServerInformation)obj, selectedIndex);
                    } else {
                        Utils.displayInformation(GerritDashboardPreferencePage.this.prefsContainer.getShell(), TITLE, String.valueOf(SELECTION_MESSAGE) + ((Button)e.widget).getText());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        return modifyListener;
    }

    private SelectionListener buttonNewListener() {
        SelectionListener newListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GerritDashboardPreferencePage.this.processDialogInfo(null, -1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        return newListener;
    }

    private SelectionListener buttonRemoveListener() {
        SelectionListener removeListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection tableSelection = GerritDashboardPreferencePage.this.serverInfoViewer.getSelection();
                if (tableSelection instanceof IStructuredSelection) {
                    Object obj = ((IStructuredSelection)tableSelection).getFirstElement();
                    if (obj instanceof GerritServerInformation) {
                        GerritDashboardPreferencePage.this.listServers.remove(obj);
                        GerritDashboardPreferencePage.this.updateTable();
                    } else {
                        Utils.displayInformation(null, TITLE, REMOVE_MESSAGE);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        return removeListener;
    }

    private IDoubleClickListener doubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)GerritDashboardPreferencePage.this.serverInfoViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Object obj = selection.getFirstElement();
                int selectedIndex = GerritDashboardPreferencePage.this.serverInfoViewer.getTable().getSelectionIndex();
                if (obj instanceof GerritServerInformation) {
                    GerritDashboardPreferencePage.this.processDialogInfo((GerritServerInformation)obj, selectedIndex);
                }
            }
        };
    }

    private void processDialogInfo(GerritServerInformation serverInfo, int selectedIndex) {
        GerritServerDialog dialog = new GerritServerDialog(this.getFieldEditorParent().getShell(), serverInfo);
        int ret = dialog.open();
        if (ret == 0) {
            try {
                if (dialog.getServerInfo() != null && dialog.getServerInfo().isValid()) {
                    if (selectedIndex >= 0) {
                        this.listServers.remove(selectedIndex);
                        this.listServers.add(selectedIndex, dialog.getServerInfo());
                    } else {
                        this.listServers.add(this.listServers.size(), dialog.getServerInfo());
                    }
                    this.updateTable();
                } else {
                    Utils.displayInformation(null, TITLE, NO_SERVER_SAVED);
                }
            }
            catch (URISyntaxException e) {
                Utils.displayInformation(dialog.getShell(), TITLE, String.valueOf(INVALID_SERVER) + e.getLocalizedMessage());
            }
        }
    }
}

