/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.effects;

import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ListBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.fx.core.bindings.FXBindings;

public class BoxShadow2
extends Region {
    private static final StyleablePropertyFactory<BoxShadow2> FACTORY = new StyleablePropertyFactory(Region.getClassCssMetaData());
    private static final CssMetaData<BoxShadow2, Boolean> META_VISIBLE = FACTORY.createBooleanCssMetaData("-box-shadow-visible", bsn -> bsn.shadowVisible, true);
    private static final CssMetaData<BoxShadow2, Number> META_BLUR = FACTORY.createSizeCssMetaData("-box-shadow-blur", bsn -> bsn.blur, (Number)10.0);
    private static final CssMetaData<BoxShadow2, Number> META_SPREAD = FACTORY.createSizeCssMetaData("-box-shadow-spread", bsn -> bsn.spread, (Number)0.0);
    private static final CssMetaData<BoxShadow2, Number> META_OFFSET_X = FACTORY.createSizeCssMetaData("-box-shadow-offset-x", bsn -> bsn.offsetX, (Number)0.0);
    private static final CssMetaData<BoxShadow2, Number> META_OFFSET_Y = FACTORY.createSizeCssMetaData("-box-shadow-offset-y", bsn -> bsn.offsetY, (Number)0.0);
    private static final CssMetaData<BoxShadow2, Paint> META_FILL = FACTORY.createPaintCssMetaData("-box-shadow-fill", bsn -> bsn.fill, (Paint)new Color(0.0, 0.0, 0.0, 0.75));
    private final StyleableBooleanProperty shadowVisible = new SimpleStyleableBooleanProperty(META_VISIBLE, (Object)this, "shadowVisible", true);
    private final StyleableDoubleProperty offsetX = new SimpleStyleableDoubleProperty(META_OFFSET_X, (Object)this, "offsetX", Double.valueOf(0.0));
    private final StyleableDoubleProperty offsetY = new SimpleStyleableDoubleProperty(META_OFFSET_Y, (Object)this, "offsetY", Double.valueOf(0.0));
    private final StyleableDoubleProperty blur = new SimpleStyleableDoubleProperty(META_BLUR, (Object)this, "blur", Double.valueOf(10.0));
    private final StyleableDoubleProperty spread = new SimpleStyleableDoubleProperty(META_SPREAD, (Object)this, "spread", Double.valueOf(0.0));
    private final StyleableObjectProperty<Paint> fill = new SimpleStyleableObjectProperty(META_FILL, (Object)this, "fill", (Object)new Color(0.0, 0.0, 0.0, 0.75));
    private final ObjectProperty<Node> content = new SimpleObjectProperty((Object)this, "content", null);
    private Region shadow = new Region();
    private final SimpleObjectProperty<Node> shadowProperty = new SimpleObjectProperty((Object)this.shadow);
    private final ListBinding<Node> shadowListBinding = FXBindings.toList(this.shadowProperty);
    private final ListBinding<Node> contentListBinding = FXBindings.toList(this.content);
    private final ListBinding<Node> childrenListBinding = FXBindings.concat((ObservableList[])new ObservableList[]{this.shadowListBinding, this.contentListBinding});
    private ShadowTemplate shadowTemplate;

    public BoxShadow2() {
        this(null);
    }

    public BoxShadow2(Node content) {
        Bindings.bindContent((List)this.getChildren(), this.childrenListBinding);
        this.shadow.translateXProperty().bind((ObservableValue)this.offsetX);
        this.shadow.translateYProperty().bind((ObservableValue)this.offsetY);
        this.shadow.visibleProperty().bind((ObservableValue)this.shadowVisible);
        this.offsetX.addListener((obs, ol, ne) -> this.requestLayout());
        this.offsetY.addListener((obs, ol, ne) -> this.requestLayout());
        this.spread.addListener((obs, ol, ne) -> this.requestLayout());
        this.blur.addListener((obs, ol, ne) -> this.updateShadowTemplate());
        this.fill.addListener((obs, ol, ne) -> this.updateShadowTemplate());
        this.updateShadowTemplate();
        this.setContent(content);
    }

    public Orientation getContentBias() {
        if (this.getContent() != null) {
            return this.getContent().getContentBias();
        }
        return null;
    }

    protected double computeMinWidth(double height) {
        Node node = (Node)this.content.get();
        if (node != null) {
            return this.getInsets().getLeft() + node.minWidth(height) + this.getInsets().getRight();
        }
        return super.computeMinWidth(height);
    }

    protected double computeMinHeight(double width) {
        Node node = (Node)this.content.get();
        if (node != null) {
            return this.getInsets().getTop() + node.minHeight(width) + this.getInsets().getBottom();
        }
        return super.computeMinHeight(width);
    }

    protected double computePrefWidth(double height) {
        Node node = (Node)this.content.get();
        if (node != null) {
            return this.getInsets().getLeft() + node.prefWidth(height) + this.getInsets().getRight();
        }
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        Node node = (Node)this.content.get();
        if (node != null) {
            return this.getInsets().getTop() + node.prefHeight(width) + this.getInsets().getBottom();
        }
        return super.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        Node node = (Node)this.content.get();
        if (node != null) {
            return this.getInsets().getLeft() + node.maxWidth(height) + this.getInsets().getRight();
        }
        return super.computeMaxWidth(height);
    }

    protected double computeMaxHeight(double width) {
        Node node = (Node)this.content.get();
        if (node != null) {
            return this.getInsets().getTop() + node.maxHeight(width) + this.getInsets().getBottom();
        }
        return super.computeMaxHeight(width);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    private double internal_getBlur() {
        return Math.max(0.0, this.blur.get());
    }

    private void updateShadowTemplate() {
        this.shadowTemplate = new ShadowTemplate(this.internal_getBlur(), (Paint)this.fill.get());
        this.requestLayout();
    }

    protected void layoutChildren() {
        Node node = (Node)this.content.get();
        if (node != null) {
            Insets insets = this.getInsets();
            node.resizeRelocate(insets.getLeft(), insets.getTop(), this.getWidth() - insets.getLeft() - insets.getRight(), this.getHeight() - insets.getTop() - insets.getBottom());
        }
        double shadowWidth = this.getWidth() + this.internal_getBlur() * 2.0;
        double shadowHeight = this.getHeight() + this.internal_getBlur() * 2.0;
        this.shadow.resizeRelocate(-this.internal_getBlur() - this.spread.get() / 2.0, -this.internal_getBlur() - this.spread.get() / 2.0, shadowWidth + this.spread.get(), shadowHeight + this.spread.get());
        this.shadow.setBackground(this.shadowTemplate.createBackground(shadowWidth + this.spread.get(), shadowHeight + this.spread.get()));
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public final Node getContent() {
        return (Node)this.contentProperty().get();
    }

    public final void setContent(Node content) {
        this.content.set((Object)content);
    }

    public final DoubleProperty offsetXProperty() {
        return this.offsetX;
    }

    public final double getOffsetX() {
        return this.offsetXProperty().get();
    }

    public final void setOffsetX(double offsetX) {
        this.offsetXProperty().set(offsetX);
    }

    public final DoubleProperty offsetYProperty() {
        return this.offsetY;
    }

    public final double getOffsetY() {
        return this.offsetYProperty().get();
    }

    public final void setOffsetY(double offsetY) {
        this.offsetYProperty().set(offsetY);
    }

    public final DoubleProperty spreadProperty() {
        return this.spread;
    }

    public final double getSpread() {
        return this.spreadProperty().get();
    }

    public final void setSpread(double spread) {
        this.spreadProperty().set(spread);
    }

    public final DoubleProperty blurProperty() {
        return this.blur;
    }

    public final double getBlur() {
        return this.blurProperty().get();
    }

    public final void setBlur(double blur) {
        this.blurProperty().set(blur);
    }

    public final ObjectProperty<Paint> fillProperty() {
        return this.fill;
    }

    public final Paint getFill() {
        return (Paint)this.fillProperty().get();
    }

    public final void setFill(Paint fill) {
        this.fillProperty().set((Object)fill);
    }

    public final StyleableBooleanProperty shadowVisibleProperty() {
        return this.shadowVisible;
    }

    public final boolean isShadowVisible() {
        return this.shadowVisibleProperty().get();
    }

    public final void setShadowVisible(boolean shadowVisible) {
        this.shadowVisibleProperty().set(shadowVisible);
    }

    private static class ShadowTemplate {
        static final int BLUR_MULTIPLIER = 2;
        private static final int CENTER_SIZE = 5;
        private double blur;
        private Image imageTopLeft;
        private Image imageTop;
        private Image imageTopRight;
        private Image imageLeft;
        private Image imageRight;
        private Image imageBottomLeft;
        private Image imageBottom;
        private Image imageBottomRight;
        private Image imageCenter;

        public ShadowTemplate(double blur, Paint fill) {
            this.blur = blur;
            double left = 2.0 * Math.ceil(blur);
            double top = 2.0 * Math.ceil(blur);
            double right = 2.0 * Math.ceil(blur);
            double bottom = 2.0 * Math.ceil(blur);
            double center = 5.0;
            Canvas canvas = new Canvas(left + center + right, top + center + bottom);
            GraphicsContext gc = canvas.getGraphicsContext2D();
            gc.clearRect(0.0, 0.0, left + center + right, top + center + bottom);
            gc.setFill(fill);
            gc.fillRect(Math.ceil(blur), Math.ceil(blur), center + 2.0 * Math.ceil(blur), center + 2.0 * Math.ceil(blur));
            gc.applyEffect((Effect)new GaussianBlur(blur));
            this.imageTopLeft = canvas.snapshot(ShadowTemplate.createParams(0.0, 0.0, top, left), null);
            this.imageTop = canvas.snapshot(ShadowTemplate.createParams(left, 0.0, center, left), null);
            this.imageTopRight = canvas.snapshot(ShadowTemplate.createParams(left + center, 0.0, right, left), null);
            this.imageLeft = canvas.snapshot(ShadowTemplate.createParams(0.0, top, left, center), null);
            this.imageRight = canvas.snapshot(ShadowTemplate.createParams(left + center, top, right, center), null);
            this.imageBottomLeft = canvas.snapshot(ShadowTemplate.createParams(0.0, top + center, left, bottom), null);
            this.imageBottom = canvas.snapshot(ShadowTemplate.createParams(left, top + center, center, bottom), null);
            this.imageBottomRight = canvas.snapshot(ShadowTemplate.createParams(left + center, top + center, right, bottom), null);
            this.imageCenter = canvas.snapshot(ShadowTemplate.createParams(left, top, center, center), null);
        }

        public Background createBackground(double width, double height) {
            double left = 2.0 * Math.ceil(this.blur);
            double top = 2.0 * Math.ceil(this.blur);
            double right = 2.0 * Math.ceil(this.blur);
            double bottom = 2.0 * Math.ceil(this.blur);
            BackgroundPosition posTopLeft = new BackgroundPosition(Side.LEFT, 0.0, false, Side.TOP, 0.0, false);
            double backgroundWidth = Math.max(width - left - right, 0.0);
            double backgroundHeight = Math.max(height - top - bottom, 0.0);
            BackgroundSize sizeTop = new BackgroundSize(backgroundWidth, top, false, false, false, false);
            BackgroundPosition posTop = new BackgroundPosition(Side.LEFT, left, false, Side.TOP, 0.0, false);
            BackgroundPosition posTopRight = new BackgroundPosition(Side.RIGHT, 0.0, false, Side.TOP, 0.0, false);
            BackgroundSize sizeLeft = new BackgroundSize(left, backgroundHeight, false, false, false, false);
            BackgroundPosition posLeft = new BackgroundPosition(Side.LEFT, 0.0, false, Side.TOP, top, false);
            BackgroundSize sizeRight = new BackgroundSize(right, backgroundHeight, false, false, false, false);
            BackgroundPosition posRight = new BackgroundPosition(Side.RIGHT, 0.0, false, Side.TOP, top, false);
            BackgroundPosition posBottomLeft = new BackgroundPosition(Side.LEFT, 0.0, false, Side.BOTTOM, 0.0, false);
            BackgroundSize sizeBottom = new BackgroundSize(backgroundWidth, bottom, false, false, false, false);
            BackgroundPosition posBottom = new BackgroundPosition(Side.LEFT, left, false, Side.BOTTOM, 0.0, false);
            BackgroundPosition posBottomRight = new BackgroundPosition(Side.RIGHT, 0.0, false, Side.BOTTOM, 0.0, false);
            BackgroundSize sizeCenter = new BackgroundSize(backgroundWidth, backgroundHeight, false, false, false, false);
            BackgroundPosition posCenter = new BackgroundPosition(Side.LEFT, left, false, Side.TOP, top, false);
            return new Background(new BackgroundImage[]{new BackgroundImage(this.imageTopLeft, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, posTopLeft, BackgroundSize.DEFAULT), new BackgroundImage(this.imageTop, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, posTop, sizeTop), new BackgroundImage(this.imageTopRight, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, posTopRight, BackgroundSize.DEFAULT), new BackgroundImage(this.imageLeft, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, posLeft, sizeLeft), new BackgroundImage(this.imageRight, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, posRight, sizeRight), new BackgroundImage(this.imageBottomLeft, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, posBottomLeft, BackgroundSize.DEFAULT), new BackgroundImage(this.imageBottom, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, posBottom, sizeBottom), new BackgroundImage(this.imageBottomRight, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, posBottomRight, BackgroundSize.DEFAULT), new BackgroundImage(this.imageCenter, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, posCenter, sizeCenter)});
        }

        private static SnapshotParameters createParams(double minX, double minY, double width, double height) {
            SnapshotParameters params = new SnapshotParameters();
            params.setFill((Paint)Color.TRANSPARENT);
            params.setViewport(new Rectangle2D(minX, minY, width, height));
            return params;
        }
    }
}

