/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.internal;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.fx.core.ObjectSerializer;
import org.osgi.service.component.annotations.Component;

@Component
public class JAXBObjectSerializer
implements ObjectSerializer {
    @Override
    public String getId() {
        return "jaxb";
    }

    @Override
    public String serialize(Object object) {
        if (object instanceof List) {
            object = new ListWrapper((List)object);
        } else if (object instanceof Set) {
            object = new SetWrapper((Set)object);
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (StringWriter w = new StringWriter();){
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                jaxbMarshaller.marshal(object, (Writer)w);
                return w.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <O> String serializeCollection(Collection<O> data, Class<O> contentType) {
        Object object;
        if (data instanceof List) {
            object = new ListWrapper((List)data);
        } else if (data instanceof Set) {
            object = new SetWrapper((Set)data);
        } else {
            throw new IllegalArgumentException("Unsupported collection type");
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (StringWriter w = new StringWriter();){
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass(), contentType});
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                jaxbMarshaller.marshal(object, (Writer)w);
                return w.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <O> O deserialize(Class<O> clazz, String value) {
        if (clazz == List.class) {
            clazz = ListWrapper.class;
        } else if (clazz == Set.class) {
            clazz = SetWrapper.class;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (StringReader r = new StringReader(value);){
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                Object unmarshal = jaxbUnmarshaller.unmarshal((Reader)r);
                if (unmarshal instanceof ListWrapper) {
                    return (O)((ListWrapper)unmarshal).list;
                }
                if (unmarshal instanceof SetWrapper) {
                    return (O)((SetWrapper)unmarshal).list;
                }
                return (O)unmarshal;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <O, T extends Collection<O>> T deserializeCollection(Class<T> type, Class<O> contentType, String value) {
        Class clazz;
        if (type == List.class) {
            clazz = ListWrapper.class;
        } else if (type == Set.class) {
            clazz = SetWrapper.class;
        } else {
            throw new IllegalArgumentException("Unsupported collection type");
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (StringReader r = new StringReader(value);){
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz, contentType});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                Object unmarshal = jaxbUnmarshaller.unmarshal((Reader)r);
                if (unmarshal instanceof ListWrapper) {
                    return (T)((ListWrapper)unmarshal).list;
                }
                if (unmarshal instanceof SetWrapper) {
                    return (T)((SetWrapper)unmarshal).list;
                }
                throw new IllegalStateException("Unsupported type");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @XmlRootElement
    public static class ListWrapper<O> {
        List<O> list = new ArrayList<O>();

        public ListWrapper() {
        }

        public ListWrapper(List<O> list) {
            this.list = list;
        }

        public List<O> getList() {
            return this.list;
        }

        public void setList(List<O> list) {
            this.list = list;
        }
    }

    @XmlRootElement
    public static class SetWrapper<O> {
        Set<O> list = new HashSet<O>();

        public SetWrapper() {
        }

        public SetWrapper(Set<O> list) {
            this.list = list;
        }

        public Set<O> getSet() {
            return this.list;
        }

        public void setSet(Set<O> list) {
            this.list = list;
        }
    }
}

