/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.core.internal;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;

public class MobileClasspathContainer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        SimulatorContainer container = new SimulatorContainer(containerPath, this.createEntries());
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
    }

    public IClasspathEntry[] createEntries() {
        return new IClasspathEntry[]{this.createPDEEntry("org.eclipse.fx.ui.mobile"), this.createPDEEntry("org.eclipse.fx.core")};
    }

    private IClasspathEntry createPDEEntry(String bundleName) {
        IPluginModelBase findModel = PDECore.getDefault().getModelManager().findModel(bundleName);
        String installLocation = findModel.getInstallLocation();
        File f = new File(installLocation);
        if (f.isDirectory()) {
            return JavaCore.newLibraryEntry((IPath)new Path(String.valueOf(installLocation) + "/bin"), null, null);
        }
        return JavaCore.newLibraryEntry((IPath)new Path(installLocation), null, null);
    }

    private static class SimulatorContainer
    implements IClasspathContainer {
        private final IClasspathEntry[] fEntries;
        private final IPath fPath;

        public SimulatorContainer(IPath path, IClasspathEntry[] entries) {
            this.fPath = path;
            this.fEntries = entries;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fEntries;
        }

        public String getDescription() {
            return "Mobile SDK Classpath";
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.fPath;
        }
    }
}

