/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.Writer;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.formats.svg.svg.SvgClipPathElement;
import org.eclipse.fx.formats.svg.svg.SvgDefsElement;
import org.eclipse.fx.formats.svg.svg.SvgElement;
import org.eclipse.fx.formats.svg.svg.SvgGElement;
import org.eclipse.fx.formats.svg.svg.SvgImageElement;
import org.eclipse.fx.formats.svg.svg.SvgLinearGradientElement;
import org.eclipse.fx.formats.svg.svg.SvgPathElement;
import org.eclipse.fx.formats.svg.svg.SvgRectElement;
import org.eclipse.fx.formats.svg.svg.SvgStopElement;
import org.eclipse.fx.formats.svg.svg.SvgSvgElement;
import org.eclipse.fx.formats.svg.svg.SvgTextElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class SvgSerializer {
    private SvgSvgElement e;

    public SvgSerializer(SvgSvgElement e) {
        this.e = e;
    }

    public void toSvg(Writer w) {
        try {
            CharSequence _gen = this.gen();
            w.append(_gen);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CharSequence gen() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" standalone=\"no\"?>");
        _builder.newLine();
        _builder.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">");
        _builder.newLine();
        _builder.append("<svg width=\"");
        String _width = this.e.getWidth();
        _builder.append(_width, "");
        _builder.append("\" height=\"");
        String _height = this.e.getHeight();
        _builder.append(_height, "");
        _builder.append("\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
        _builder.newLineIfNotEmpty();
        EList _children = this.e.getChildren();
        for (SvgElement c : _children) {
            _builder.append("\t");
            CharSequence _handle = this.handle(c);
            _builder.append((Object)_handle, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</svg>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgGElement e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<g");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("transform=\"");
        String _transform = e.getTransform();
        _builder.append(_transform, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        if (!StringExtensions.isNullOrEmpty((String)e.getClip_path()) && !Objects.equal((Object)e.getClip_path(), (Object)"none")) {
            _builder.append("clip-path=\"");
            String _clip_path = e.getClip_path();
            _builder.append(_clip_path, "\t");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append(">");
        _builder.newLine();
        EList _children = e.getChildren();
        for (SvgElement c : _children) {
            _builder.append("\t");
            CharSequence _handle = this.handle(c);
            _builder.append((Object)_handle, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</g>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgRectElement e) {
        boolean _not_6;
        boolean _not_5;
        boolean _not_4;
        boolean _not_3;
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<rect");
        _builder.newLine();
        _builder.append("\t");
        String _x = e.getX();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_x);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("x=\"");
            String _x_1 = e.getX();
            _builder.append(_x_1, "\t");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _y = e.getY();
        boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)_y);
        boolean bl2 = _not_1 = !_isNullOrEmpty_1;
        if (_not_1) {
            _builder.append("y=\"");
            String _y_1 = e.getY();
            _builder.append(_y_1, "\t");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _rx = e.getRx();
        boolean _isNullOrEmpty_2 = StringExtensions.isNullOrEmpty((String)_rx);
        boolean bl3 = _not_2 = !_isNullOrEmpty_2;
        if (_not_2) {
            _builder.append("rx=\"");
            String _rx_1 = e.getRx();
            _builder.append(_rx_1, "\t");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _ry = e.getRy();
        boolean _isNullOrEmpty_3 = StringExtensions.isNullOrEmpty((String)_ry);
        boolean bl4 = _not_3 = !_isNullOrEmpty_3;
        if (_not_3) {
            _builder.append("ry=\"");
            String _ry_1 = e.getRy();
            _builder.append(_ry_1, "\t");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("width=\"");
        String _width = e.getWidth();
        _builder.append(_width, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("height=\"");
        String _height = e.getHeight();
        _builder.append(_height, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _fill = e.getFill();
        boolean _isNullOrEmpty_4 = StringExtensions.isNullOrEmpty((String)_fill);
        boolean bl5 = _not_4 = !_isNullOrEmpty_4;
        if (_not_4) {
            _builder.append("fill=\"");
            String _fill_1 = e.getFill();
            _builder.append(_fill_1, "\t");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _fill_opacity = e.getFill_opacity();
        boolean _isNullOrEmpty_5 = StringExtensions.isNullOrEmpty((String)_fill_opacity);
        boolean bl6 = _not_5 = !_isNullOrEmpty_5;
        if (_not_5) {
            _builder.append("fill-opacity=\"");
            String _fill_opacity_1 = e.getFill_opacity();
            _builder.append(_fill_opacity_1, "\t");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        if (!StringExtensions.isNullOrEmpty((String)e.getStroke()) && !Objects.equal((Object)e.getStroke(), (Object)"none")) {
            _builder.append("stroke=\"");
            String _stroke = e.getStroke();
            _builder.append(_stroke, "\t");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _stroke_width = e.getStroke_width();
        boolean _isNullOrEmpty_6 = StringExtensions.isNullOrEmpty((String)_stroke_width);
        boolean bl7 = _not_6 = !_isNullOrEmpty_6;
        if (_not_6) {
            _builder.append("stroke-width=\"");
            String _stroke_width_1 = e.getStroke_width();
            _builder.append(_stroke_width_1, "\t");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("/>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgTextElement e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<text");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("x=\"");
        String _x = e.getX();
        _builder.append(_x, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("y=\"");
        String _y = e.getY();
        _builder.append(_y, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("fill=\"");
        String _fill = e.getFill();
        _builder.append(_fill, "\t");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _textContent = e.getTextContent();
        _builder.append(_textContent, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("</text>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgDefsElement e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<defs>");
        _builder.newLine();
        EList _children = e.getChildren();
        for (SvgElement c : _children) {
            _builder.append("\t");
            CharSequence _handle = this.handle(c);
            _builder.append((Object)_handle, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</defs>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgPathElement e) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<path");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("d=\"");
        String _d = e.getD();
        _builder.append(_d, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _fill = e.getFill();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_fill);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("fill=\"");
            String _fill_1 = e.getFill();
            _builder.append(_fill_1, "\t");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("/>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgImageElement e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<image");
        _builder.newLine();
        _builder.append("/>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgLinearGradientElement e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<linearGradient id=\"");
        String _id = e.getId();
        _builder.append(_id, "");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("x1=\"");
        String _x1 = e.getX1();
        _builder.append(_x1, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("y1=\"");
        String _y1 = e.getY1();
        _builder.append(_y1, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("x2=\"");
        String _x2 = e.getX2();
        _builder.append(_x2, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("y2=\"");
        String _y2 = e.getY2();
        _builder.append(_y2, "\t");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        EList _children = e.getChildren();
        Iterable _filter = Iterables.filter((Iterable)_children, SvgStopElement.class);
        for (SvgStopElement s : _filter) {
            _builder.append("\t");
            _builder.append("<stop offset=\"");
            String _offset = s.getOffset();
            _builder.append(_offset, "\t");
            _builder.append("\" stop-color=\"");
            String _stop_color = s.getStop_color();
            _builder.append(_stop_color, "\t");
            _builder.append("\" />");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</linearGradient>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _handle(SvgClipPathElement e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<clipPath id=\"");
        String _id = e.getId();
        _builder.append(_id, "");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        EList _children = e.getChildren();
        for (SvgElement c : _children) {
            _builder.append("\t");
            CharSequence _handle = this.handle(c);
            _builder.append((Object)_handle, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</clipPath>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence handle(EObject e) {
        if (e instanceof SvgDefsElement) {
            return this._handle((SvgDefsElement)e);
        }
        if (e instanceof SvgGElement) {
            return this._handle((SvgGElement)e);
        }
        if (e instanceof SvgClipPathElement) {
            return this._handle((SvgClipPathElement)e);
        }
        if (e instanceof SvgImageElement) {
            return this._handle((SvgImageElement)e);
        }
        if (e instanceof SvgLinearGradientElement) {
            return this._handle((SvgLinearGradientElement)e);
        }
        if (e instanceof SvgPathElement) {
            return this._handle((SvgPathElement)e);
        }
        if (e instanceof SvgRectElement) {
            return this._handle((SvgRectElement)e);
        }
        if (e instanceof SvgTextElement) {
            return this._handle((SvgTextElement)e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }
}

