/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.fx.ide.jdt.core.internal.BuildPathSupport;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class JavaFXClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (JavaFXClasspathContainerInitializer.isValidJUnitContainerPath(containerPath)) {
            JavaFXContainer container = JavaFXClasspathContainerInitializer.getNewContainer(containerPath, project);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    private static JavaFXContainer getNewContainer(IPath containerPath, IJavaProject project) {
        IClasspathEntry entry = null;
        entry = BuildPathSupport.getJavaFXLibraryEntry(project);
        IClasspathEntry[] entries = entry == null ? new IClasspathEntry[]{} : new IClasspathEntry[]{entry};
        return new JavaFXContainer(containerPath, entries);
    }

    private static boolean isValidJUnitContainerPath(IPath path) {
        return path != null && "org.eclipse.fx.ide.jdt.core.JAVAFX_CONTAINER".equals(path.segment(0));
    }

    private static class JavaFXContainer
    implements IClasspathContainer {
        private final IClasspathEntry[] fEntries;
        private final IPath fPath;

        public JavaFXContainer(IPath path, IClasspathEntry[] entries) {
            this.fPath = path;
            this.fEntries = entries;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fEntries;
        }

        public String getDescription() {
            return "JavaFX SDK";
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.fPath;
        }
    }
}

