/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.ui.outline;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleBracket;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleConcat;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleDefinition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleLiteral;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleOr;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRulePostfix;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleRef;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleXor;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CssExtDslPackage;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CssExtension;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.Definition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.Doku;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.ElementDefinition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.PackageDefinition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.PropertyDefinition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.Substructure;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.SubstructureSelector;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.SubstructureStyleclass;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;

public class CssExtDslOutlineTreeProvider
extends DefaultOutlineTreeProvider {
    protected Image _image(PackageDefinition m) {
        return this.labelProvider.getImage((Object)m);
    }

    private String findFullPackageName(PackageDefinition d) {
        String name = d.getName();
        EObject c = d.eContainer();
        while (c != null && c instanceof PackageDefinition) {
            PackageDefinition cur = (PackageDefinition)c;
            name = String.valueOf(cur.getName()) + "." + name;
            c = c.eContainer();
        }
        return name;
    }

    protected void _createChildren(DocumentRootNode parentNode, CssExtension ext) {
        TreeSet<PackageDefinition> packages = new TreeSet<PackageDefinition>(new Comparator<PackageDefinition>(){

            @Override
            public int compare(PackageDefinition o1, PackageDefinition o2) {
                String name1 = CssExtDslOutlineTreeProvider.this.findFullPackageName(o1);
                String name2 = CssExtDslOutlineTreeProvider.this.findFullPackageName(o2);
                return name1.compareTo(name2);
            }
        });
        packages.add(ext.getPackageDef());
        while (!packages.isEmpty()) {
            PackageDefinition current = (PackageDefinition)packages.last();
            packages.remove(current);
            this.createEObjectNode((IOutlineNode)parentNode, (EObject)current, this.labelProvider.getImage((Object)current), this.findFullPackageName(current), false);
            for (PackageDefinition d : current.getSubpackages()) {
                packages.add(d);
            }
            packages.addAll((Collection<PackageDefinition>)current.getSubpackages());
        }
    }

    protected void _createChildren(IOutlineNode parentNode, ElementDefinition elDef) {
        for (Definition d : elDef.getProperties()) {
            this.createNode(parentNode, (EObject)d);
        }
        for (Definition d : elDef.getPseudoClasses()) {
            this.createNode(parentNode, (EObject)d);
        }
        if (!elDef.getSubstructures().isEmpty()) {
            this.createEStructuralFeatureNode(parentNode, (EObject)elDef, (EStructuralFeature)CssExtDslPackage.Literals.ELEMENT_DEFINITION__SUBSTRUCTURES, this.labelProvider.getImage((Object)Collections.EMPTY_LIST), "Substructures", false);
        }
    }

    protected String _text(Substructure n) {
        return "substructure \"" + n.getName() + "\"";
    }

    protected void _createChildren(IOutlineNode parent, SubstructureStyleclass n) {
        for (SubstructureStyleclass s : n.getChilds()) {
            this.createEObjectNode(parent, (EObject)s);
        }
    }

    protected String _text(SubstructureStyleclass n) {
        String x = String.valueOf(this.labelProvider.getText((Object)n.getElement())) + " -> ";
        for (SubstructureSelector s : n.getSelectors()) {
            x = String.valueOf(x) + s.getSelectorName();
            if (s.getVar() != null) {
                x = String.valueOf(x) + "[" + s.getVar() + "]";
            }
            x = String.valueOf(x) + " ";
        }
        return x;
    }

    protected void _createChildren(IOutlineNode parentNode, PackageDefinition pkg) {
        if (!pkg.getRules().isEmpty()) {
            this.createEStructuralFeatureNode(parentNode, (EObject)pkg, (EStructuralFeature)CssExtDslPackage.Literals.PACKAGE_DEFINITION__RULES, this.labelProvider.getImage((Object)Collections.EMPTY_LIST), "Rules", false);
        }
        if (!pkg.getElements().isEmpty()) {
            this.createEStructuralFeatureNode(parentNode, (EObject)pkg, (EStructuralFeature)CssExtDslPackage.Literals.PACKAGE_DEFINITION__ELEMENTS, this.labelProvider.getImage((Object)Collections.EMPTY_LIST), "Elements", false);
        }
    }

    protected boolean _isLeaf(Definition modelElement) {
        return true;
    }

    protected Object _text(CSSRuleDefinition modelElement) {
        return modelElement.getName();
    }

    protected Object _text(PropertyDefinition modelElement) {
        return modelElement.getName();
    }

    protected Object _text(ElementDefinition modelElement) {
        String r = modelElement.getName();
        if (modelElement.getStyleclass() != null) {
            r = String.valueOf(r) + " (" + modelElement.getStyleclass() + ")";
        }
        return r;
    }

    protected Object _text(Doku d) {
        return "documentation";
    }

    protected Object _text(PackageDefinition modelElement) {
        String name = modelElement.getName();
        EObject cur = modelElement.eContainer();
        while (cur != null && cur instanceof PackageDefinition) {
            PackageDefinition curDef = (PackageDefinition)cur;
            name = String.valueOf(curDef.getName()) + "." + name;
            cur = cur.eContainer();
        }
        return name;
    }

    protected Object _text(CSSRuleBracket model) {
        return "CSSRuleBracket []";
    }

    protected Object _text(CSSRuleOr model) {
        return "CSSRuleOr |";
    }

    protected Object _text(CSSRuleXor model) {
        return "CSSRuleXor ||";
    }

    protected Object _text(CSSRuleConcat model) {
        return "CSSRuleConcat";
    }

    protected Object _text(CSSRuleLiteral model) {
        return model.getValue();
    }

    protected Object _text(CSSRuleRef model) {
        return "<" + model.getRef().getName() + ">";
    }

    protected Object _text(CSSRulePostfix model) {
        return "CSSRulePostfix " + model.getCardinality();
    }
}

