/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.validation;

import com.google.inject.Inject;
import java.io.File;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.ide.fxgraph.fXGraph.ComponentDefinition;
import org.eclipse.fx.ide.fxgraph.fXGraph.ControllerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Define;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.FXGraphPackage;
import org.eclipse.fx.ide.fxgraph.fXGraph.Import;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.validation.AbstractFXGraphJavaValidator;
import org.eclipse.fx.ide.model.FXPlugin;
import org.eclipse.fx.ide.model.IFXClass;
import org.eclipse.fx.ide.model.IFXCtrlClass;
import org.eclipse.fx.ide.model.IFXCtrlEventMethod;
import org.eclipse.fx.ide.model.IFXCtrlField;
import org.eclipse.fx.ide.model.IFXEventHandlerProperty;
import org.eclipse.fx.ide.model.IFXProperty;
import org.eclipse.fx.ide.model.Util;
import org.eclipse.fx.ide.ui.util.RelativeFileLocator;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.validation.Check;

public class FXGraphJavaValidator
extends AbstractFXGraphJavaValidator {
    public static final String UNKNOWN_CONTROLLER_FIELD = "FXGraphJavaValidator.UNKNOWN_CONTROLLER_FIELD";
    public static final String CONTROLLER_FIELD_NOT_ASSIGNABLE = "FXGraphJavaValidator.CONTROLLER_FIELD_NOT_ASSIGNABLE";
    public static final String UNKNOWN_CONTROLLER_METHOD = "FXGraphJavaValidator.UNKNOWN_CONTROLLER_METHOD";
    @Inject
    private IJvmTypeProvider.Factory jdtTypeProvider;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IJavaProjectProvider projectProvider;

    @Check
    public void validateModel(Model model) {
        if (model.getPackage() == null) {
            this.warning("You should add a package declaration to use a namespace", (EStructuralFeature)FXGraphPackage.Literals.MODEL__PACKAGE);
        } else {
            URI uri = model.eResource().getURI();
            IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(uri.segment(1));
            Object path = null;
            int i = 2;
            while (i < uri.segmentCount() - 1) {
                path = path == null ? new Path(uri.segment(i)) : path.append(uri.segment(i));
                ++i;
            }
            IJavaElement e = JavaCore.create((IFolder)p.getFolder(path));
            if (e instanceof IPackageFragment && !model.getPackage().getName().equals(e.getElementName())) {
                this.error("The package has to be '" + e.getElementName() + "'", (EStructuralFeature)FXGraphPackage.Literals.MODEL__PACKAGE);
            }
        }
    }

    @Check
    public void validateComponent(ComponentDefinition componentDef) {
        File absFile;
        int i = 0;
        for (String cssFile : componentDef.getPreviewCssFiles()) {
            File absFile2 = RelativeFileLocator.locateFile((URI)componentDef.eResource().getURI(), (String)cssFile);
            if (absFile2 == null || !absFile2.exists()) {
                this.warning("The specified file '" + cssFile + "' could not be found", (EStructuralFeature)FXGraphPackage.Literals.COMPONENT_DEFINITION__PREVIEW_CSS_FILES, i);
            }
            ++i;
        }
        if (!(componentDef.getPreviewResourceBundle() == null || (absFile = RelativeFileLocator.locateFile((URI)componentDef.eResource().getURI(), (String)componentDef.getPreviewResourceBundle())) != null && absFile.exists())) {
            this.error("The specified resource file '" + componentDef.getPreviewResourceBundle() + "' could not be found", (EStructuralFeature)FXGraphPackage.Literals.COMPONENT_DEFINITION__PREVIEW_RESOURCE_BUNDLE);
        }
    }

    @Check
    public void validate(Element element) {
        JvmTypeReference controller = ((Model)element.eResource().getContents().get(0)).getComponentDef().getController();
        if (controller != null && element.getName() != null) {
            IJavaProject javaProject = this.projectProvider.getJavaProject(element.eResource().getResourceSet());
            try {
                IType type = javaProject.findType(controller.getQualifiedName());
                IFXCtrlClass fxClazz = FXPlugin.getClassmodel().findCtrlClass(javaProject, type);
                if (fxClazz != null) {
                    IFXCtrlField f = (IFXCtrlField)fxClazz.getAllFields().get(element.getName());
                    if (f == null) {
                        if (!(element.eContainer() instanceof Define)) {
                            this.warning("The controller '" + type.getElementName() + "' has no field '" + element.getName() + "'", (EStructuralFeature)FXGraphPackage.Literals.ELEMENT__NAME, UNKNOWN_CONTROLLER_FIELD, new String[]{element.getName(), controller.getQualifiedName(), element.getType().getQualifiedName()});
                        }
                    } else {
                        IType toType;
                        IType fromType = javaProject.findType(element.getType().getQualifiedName());
                        if (!Util.assignable((IType)fromType, (IType)(toType = f.getType()))) {
                            this.error("The type '" + fromType.getElementName() + "' is not assignable to the controller fields type '" + toType.getElementName() + "'", (EStructuralFeature)FXGraphPackage.Literals.ELEMENT__NAME, CONTROLLER_FIELD_NOT_ASSIGNABLE, new String[]{element.getName(), controller.getQualifiedName(), element.getType().getQualifiedName()});
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    @Check
    public void validate(ControllerHandledValueProperty element) {
        JvmTypeReference controller = ((Model)element.eResource().getContents().get(0)).getComponentDef().getController();
        if (controller != null && element.getMethodname() != null) {
            IJavaProject javaProject = this.projectProvider.getJavaProject(element.eResource().getResourceSet());
            try {
                IFXCtrlEventMethod m;
                IType ctrlType = javaProject.findType(controller.getQualifiedName());
                Property propertyModel = (Property)element.eContainer();
                Element elementModel = (Element)propertyModel.eContainer();
                IType elType = javaProject.findType(elementModel.getType().getQualifiedName());
                IFXCtrlClass fxCtrlClazz = FXPlugin.getClassmodel().findCtrlClass(javaProject, ctrlType);
                IFXClass fxElClass = FXPlugin.getClassmodel().findClass(javaProject, elType);
                IFXProperty fxProp = (IFXProperty)fxElClass.getAllProperties().get(propertyModel.getName());
                if (!(fxProp instanceof IFXEventHandlerProperty)) {
                    this.error("Property is not an event property", propertyModel, (EStructuralFeature)FXGraphPackage.Literals.PROPERTY__NAME, -1);
                    return;
                }
                if (fxCtrlClazz != null && (m = (IFXCtrlEventMethod)fxCtrlClazz.getAllEventMethods().get(element.getMethodname())) == null) {
                    this.warning("The controller '" + ctrlType.getElementName() + "' has no event method '" + element.getMethodname() + "'", (EStructuralFeature)FXGraphPackage.Literals.CONTROLLER_HANDLED_VALUE_PROPERTY__METHODNAME, UNKNOWN_CONTROLLER_METHOD, new String[]{element.getMethodname(), controller.getQualifiedName(), ((IFXEventHandlerProperty)fxProp).getEventType().getFullyQualifiedName()});
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    @Check
    public void validateImport(Import importDef) {
        if (importDef.getImportedNamespace() != null) {
            importDef.getImportedNamespace().endsWith("*");
        }
    }
}

