/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.build.BuildContext;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.IResourceServiceProviderExtension;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.xbase.lib.Functions;

public class ClusteringStorageAwareResourceLoader {
    private final BuildContext context;

    public ClusteringStorageAwareResourceLoader(BuildContext context) {
        this.context = context;
    }

    public <T> Iterable<T> executeClustered(Iterable<URI> uris, Functions.Function1<? super Resource, ? extends T> operation) {
        int loadedURIsCount = 0;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        ArrayList result = new ArrayList();
        for (URI uri : uris) {
            XtextResourceSet resourceSet = this.context.getResourceSet();
            if (!this.context.getClusteringPolicy().continueProcessing((ResourceSet)resourceSet, uri, loadedURIsCount)) {
                FluentIterable.from(resources).transform(arg_0 -> operation.apply(arg_0)).copyInto(result);
                this.clearResourceSet();
                resources.clear();
                loadedURIsCount = 0;
            }
            ++loadedURIsCount;
            resources.add(resourceSet.getResource(uri, true));
        }
        FluentIterable.from(resources).transform(arg_0 -> operation.apply(arg_0)).copyInto(result);
        return result;
    }

    @Deprecated
    protected boolean isSource(URI uri) {
        IResourceServiceProvider provider = this.context.getResourceServiceProvider(uri);
        return provider instanceof IResourceServiceProviderExtension && ((IResourceServiceProviderExtension)((Object)provider)).isSource(uri);
    }

    protected void clearResourceSet() {
        XtextResourceSet resourceSet = this.context.getResourceSet();
        boolean wasDeliver = resourceSet.eDeliver();
        try {
            resourceSet.eSetDeliver(false);
            resourceSet.getResources().clear();
        }
        finally {
            resourceSet.eSetDeliver(wasDeliver);
        }
    }
}

