/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.emf.edit.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.jdt.annotation.NonNull;

public class AdapterFactoryObservableList<T>
implements ObservableList<T> {
    private static final String CHANGES_THROUGH_MODEL = "An AdapterFactoryObservableList cannot be manipulated directly. Changes must be made via the model.";
    protected final @NonNull AdapterFactory adapterFactory;
    protected final @NonNull Object root;
    protected @NonNull IStructuredItemContentProvider provider;
    final ObservableList<T> elements = FXCollections.observableArrayList();
    private INotifyChangedListener changeListener = null;
    private Adapter adapter = null;

    public AdapterFactoryObservableList(@NonNull AdapterFactory adapterFactory, @NonNull Object root) {
        this.adapterFactory = adapterFactory;
        this.root = root;
        Object contentProvider = adapterFactory.adapt(root, IStructuredItemContentProvider.class);
        if (!(contentProvider instanceof IStructuredItemContentProvider)) {
            throw new IllegalArgumentException("Provided root object cannot be adapted.");
        }
        this.provider = (IStructuredItemContentProvider)contentProvider;
        this.elements.addAll(this.getProviderElements());
        if (root instanceof Notifier) {
            ((Notifier)root).eAdapters().add((Object)this.createAdapter());
        } else if (root instanceof IChangeNotifier) {
            ((IChangeNotifier)root).addListener(this.createChangedListener());
        }
    }

    private Adapter createAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    AdapterFactoryObservableList.this.updateInternalList(msg);
                }
            };
        }
        return this.adapter;
    }

    private INotifyChangedListener createChangedListener() {
        if (this.changeListener == null) {
            this.changeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    AdapterFactoryObservableList.this.updateInternalList(notification);
                }
            };
        }
        return this.changeListener;
    }

    public void dispose() {
        if (this.changeListener != null) {
            ((IChangeNotifier)this.provider).removeListener(this.changeListener);
        }
        if (this.adapter != null) {
            ((Notifier)this.root).eAdapters().remove((Object)this.adapter);
        }
    }

    private Collection<? extends T> getProviderElements() {
        return this.provider.getElements(this.root);
    }

    void updateInternalList(Notification msg) {
        if (msg.isTouch()) {
            return;
        }
        if (msg.getFeature() != null && !(msg.getFeature() instanceof EReference)) {
            return;
        }
        switch (msg.getEventType()) {
            case 3: {
                this.addNewChild(msg.getNewValue(), msg.getPosition());
                break;
            }
            case 5: {
                List newValues = (List)msg.getNewValue();
                int position = msg.getPosition();
                if (position != -1 && position <= this.elements.size()) {
                    Collections.reverse(newValues);
                }
                newValues.forEach(newValue -> this.addNewChild(newValue, position));
                break;
            }
            case 4: {
                this.removeChild(msg.getOldValue());
                break;
            }
            case 6: {
                List oldValues = (List)msg.getOldValue();
                oldValues.forEach(oldValue -> this.removeChild(oldValue));
                break;
            }
            case 1: 
            case 9: {
                this.elements.setAll(this.getProviderElements());
                break;
            }
            case 7: {
                int index = (Integer)msg.getOldValue();
                if (index < 0 || index >= this.elements.size()) break;
                Object item = this.elements.get(index);
                this.elements.remove(item);
                this.elements.add(msg.getPosition(), item);
            }
        }
    }

    private void addNewChild(Object value, int position) {
        if (!this.getProviderElements().contains(value)) {
            return;
        }
        if (position == -1 || position > this.elements.size()) {
            this.elements.add(value);
        } else {
            this.elements.add(position, value);
        }
    }

    private void removeChild(Object value) {
        this.elements.remove(value);
    }

    public boolean add(Object e) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public void clear() {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    public T get(int index) {
        return (T)this.elements.get(index);
    }

    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    public int lastIndexOf(Object o) {
        return this.elements.lastIndexOf(o);
    }

    public ListIterator<T> listIterator() {
        return this.elements.listIterator();
    }

    public ListIterator<T> listIterator(int index) {
        return this.elements.listIterator(index);
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public T remove(int index) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public T set(int index, Object element) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public int size() {
        return this.elements.size();
    }

    public List<T> subList(int fromIndex, int toIndex) {
        return this.elements.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.elements.toArray();
    }

    public <A> A[] toArray(A[] a) {
        return this.elements.toArray((Object[])a);
    }

    public void addListener(InvalidationListener listener) {
        this.elements.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.elements.removeListener(listener);
    }

    public boolean addAll(Object ... arg0) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public void addListener(ListChangeListener<? super T> listener) {
        this.elements.addListener(listener);
    }

    public void remove(int arg0, int arg1) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public boolean removeAll(Object ... arg0) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public void removeListener(ListChangeListener<? super T> listener) {
        this.elements.removeListener(listener);
    }

    public boolean retainAll(Object ... arg0) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public boolean setAll(Object ... arg0) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }

    public boolean setAll(Collection<? extends T> arg0) {
        throw new UnsupportedOperationException(CHANGES_THROUGH_MODEL);
    }
}

