/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.p2;

import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.fx.core.ProgressReporter;
import org.eclipse.fx.core.Status;
import org.eclipse.fx.core.StatusException;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerFactory;
import org.eclipse.fx.core.operation.CancelableOperation;
import org.eclipse.fx.core.p2.ProgressMonitorAdapter;
import org.eclipse.fx.core.p2.SimpleCancelableOperation;
import org.eclipse.fx.core.text.TextUtil;
import org.eclipse.fx.core.update.UpdateService;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component
public class UpdateServiceImpl
implements UpdateService {
    private Logger logger;
    private LoggerFactory factory;
    private IProvisioningAgent provisioningAgent;

    @Reference
    public void setLoggerFactory(LoggerFactory factory) {
        this.factory = factory;
        if (this.logger != null) {
            this.logger = null;
        }
    }

    public void unsetLoggerFactory(LoggerFactory factory) {
        if (this.factory == factory) {
            this.factory = null;
            this.logger = null;
        }
    }

    Logger getLogger() {
        if (this.logger == null) {
            this.logger = this.factory.createLogger(this.getClass().getName());
        }
        return this.logger;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    public void setProvisioningAgent(IProvisioningAgent agent) {
        this.provisioningAgent = agent;
    }

    public void unsetProvisioningAgent(IProvisioningAgent agent) {
        if (this.provisioningAgent == agent) {
            this.provisioningAgent = null;
        }
    }

    static @NonNull Status fromStatus(@NonNull IStatus s) {
        switch (s.getSeverity()) {
            case 8: {
                return Status.status((Status.State)Status.State.CANCEL, (int)s.getCode(), (String)TextUtil.notNull((String)s.getMessage(), (String)"<unknown>"), (Throwable)s.getException());
            }
            case 4: {
                return Status.status((Status.State)Status.State.ERROR, (int)s.getCode(), (String)TextUtil.notNull((String)s.getMessage(), (String)"<unknown>"), (Throwable)s.getException());
            }
            case 2: {
                return Status.status((Status.State)Status.State.WARNING, (int)s.getCode(), (String)TextUtil.notNull((String)s.getMessage(), (String)"<unknown>"), (Throwable)s.getException());
            }
        }
        return Status.ok();
    }

    public SimpleCancelableOperation<Optional<UpdateService.UpdatePlan>> checkUpdate(ProgressReporter reporter) {
        this.getLogger().debug("Check for updates");
        this.getLogger().debug(() -> "Created provisioning session with " + this.provisioningAgent);
        final ProvisioningSession session = new ProvisioningSession(this.provisioningAgent);
        this.getLogger().debug(() -> "Provisioning session is " + session);
        final ProgressMonitorAdapter a = new ProgressMonitorAdapter(reporter);
        final SimpleCancelableOperation<Optional<UpdateService.UpdatePlan>> op = new SimpleCancelableOperation<Optional<UpdateService.UpdatePlan>>(() -> a.setCanceled(true));
        Job o = new Job("Check for Updates"){

            protected IStatus run(IProgressMonitor monitor) {
                UpdateServiceImpl.this.getLogger().debug("Update job is started");
                if (a.isCanceled()) {
                    UpdateServiceImpl.this.getLogger().debug("Update has been canceled");
                    return org.eclipse.core.runtime.Status.CANCEL_STATUS;
                }
                try {
                    UpdateOperation o = new UpdateOperation(session);
                    UpdateServiceImpl.this.getLogger().debug("Resolving update operation");
                    IStatus s = o.resolveModal((IProgressMonitor)a);
                    if (s.getCode() == 10000) {
                        UpdateServiceImpl.this.getLogger().debug("Nothing found to update");
                        op.completed(Optional.empty());
                    } else if (s.isOK()) {
                        if (o.getProvisioningJob((IProgressMonitor)new NullProgressMonitor()) != null) {
                            UpdateServiceImpl.this.getLogger().debug("Updates available");
                            op.completed(Optional.of(new P2UpdateCheckRV(o)));
                        } else {
                            UpdateServiceImpl.this.getLogger().debug("Unable to get a provisioning job");
                            op.completeExceptionally(new StatusException(Status.status((Status.State)Status.State.ERROR, (int)0, (String)"No provisioning job available", null)));
                        }
                    } else {
                        UpdateServiceImpl.this.getLogger().debug(() -> "Update check failed: " + s);
                        op.completeExceptionally(new StatusException(UpdateServiceImpl.fromStatus(s)));
                    }
                }
                catch (Throwable t) {
                    UpdateServiceImpl.this.getLogger().debug("Update check failed with an exception", t);
                    op.completeExceptionally(new StatusException(Status.status((Status.State)Status.State.ERROR, (int)0, (String)"Check for update failed unexpectedly", (Throwable)t)));
                }
                return org.eclipse.core.runtime.Status.OK_STATUS;
            }
        };
        o.schedule();
        return op;
    }

    static class P2UpdateCheckRV
    implements UpdateService.UpdatePlan {
        public final @NonNull UpdateOperation updateOperation;

        public P2UpdateCheckRV(@NonNull UpdateOperation updateOperation) {
            this.updateOperation = updateOperation;
        }

        public CancelableOperation<UpdateService.UpdateResult> runUpdate(ProgressReporter progressReporter) {
            ProgressMonitorAdapter a = new ProgressMonitorAdapter(progressReporter);
            final SimpleCancelableOperation<UpdateService.UpdateResult> op = new SimpleCancelableOperation<UpdateService.UpdateResult>(() -> a.setCanceled(true));
            ProvisioningJob job = this.updateOperation.getProvisioningJob((IProgressMonitor)a);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IStatus s = event.getResult();
                    if (s.isOK()) {
                        op.completed(new P2UpdateRV());
                    } else {
                        op.completeExceptionally(new StatusException(UpdateServiceImpl.fromStatus(s)));
                    }
                }
            });
            job.schedule();
            return op;
        }
    }

    static class P2UpdateRV
    implements UpdateService.UpdateResult {
        P2UpdateRV() {
        }
    }
}

