/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import java.util.List;
import org.eclipse.xtext.formatting2.FormattingNotApplicableException;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.internal.FormattableDocument;
import org.eclipse.xtext.formatting2.internal.HiddenRegionReplacer;
import org.eclipse.xtext.formatting2.internal.SubDocument;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;

public class MaxLineWidthDocument
extends SubDocument {
    private final int maxLineWidth;

    public MaxLineWidthDocument(ITextSegment region, FormattableDocument parent, int maxLineWidth) {
        super(region, parent);
        this.maxLineWidth = maxLineWidth;
    }

    @Override
    public void addReplacer(ITextReplacer replacer) {
        this.validate(replacer);
        super.addReplacer(replacer);
    }

    @Override
    public ITextReplacerContext createReplacements(ITextReplacerContext context) {
        int formattedLength;
        ITextReplacerContext last = super.createReplacements(context);
        List<ITextReplacement> replacements = last.getReplacementsUntil(context);
        String string = this.applyTextReplacements(replacements);
        if (string.contains("\n")) {
            throw new FormattingNotApplicableException();
        }
        int leadingCharCount = context.getLeadingCharsInLineCount();
        int lineLength = leadingCharCount + (formattedLength = string.length());
        if (lineLength > this.maxLineWidth) {
            throw new FormattingNotApplicableException();
        }
        return last;
    }

    protected void validate(HiddenRegionReplacer replacer) throws FormattingNotApplicableException {
        IHiddenRegionFormatting formatting = replacer.getFormatting();
        Integer newLineMin = formatting.getNewLineMin();
        if (newLineMin != null && newLineMin > 0) {
            throw new FormattingNotApplicableException();
        }
    }

    protected void validate(ITextReplacer replacer) throws FormattingNotApplicableException {
        if (replacer instanceof HiddenRegionReplacer) {
            this.validate((HiddenRegionReplacer)replacer);
        }
    }
}

