/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.dialogs;

import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.stage.Window;
import org.eclipse.fx.ui.dialogs.Dialog;
import org.eclipse.fx.ui.dialogs.Messages;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FontDialog
extends Dialog {
    private final @NonNull ObjectProperty<Font> font = new SimpleObjectProperty((Object)this, "font", (Object)Font.getDefault());

    public FontDialog(@Nullable Window parent, @NonNull String title) {
        super(parent, title);
    }

    public @NonNull ObjectProperty<Font> font() {
        return this.font;
    }

    public void setFont(@Nullable Font f) {
        this.font.set((Object)f);
    }

    public @Nullable Font getFont() {
        return (Font)this.font.get();
    }

    @Override
    protected Node createDialogArea() {
        VBox p = new VBox(10.0);
        HBox top = new HBox(10.0);
        VBox container = new VBox();
        container.getChildren().add((Object)new Label(Messages.getString("FontDialog.Family")));
        TextField f = new TextField();
        f.setText(((Font)this.font.get()).getFamily());
        f.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
            }
        });
        container.getChildren().add((Object)f);
        ListView v = new ListView();
        v.setItems(FXCollections.observableArrayList((Collection)Font.getFamilies()));
        v.getSelectionModel().select((Object)((Font)this.font.get()).getFamily());
        v.scrollTo((Object)((Font)this.font.get()).getFamily());
        v.setPrefHeight(250.0);
        container.getChildren().add((Object)v);
        top.getChildren().add((Object)container);
        container = new VBox();
        container.getChildren().add((Object)new Label(Messages.getString("FontDialog.Posture")));
        FontPosture posture = ((Font)this.font.get()).getStyle().toLowerCase().contains("italic") ? FontPosture.ITALIC : FontPosture.REGULAR;
        TextField f2 = new TextField();
        f2.setText(posture.name());
        container.getChildren().add((Object)f2);
        ListView v2 = new ListView();
        v2.setItems(FXCollections.observableArrayList((Object[])FontPosture.values()));
        v2.getSelectionModel().select((Object)posture);
        v2.scrollTo((Object)posture);
        v2.setPrefWidth(120.0);
        v2.setPrefHeight(250.0);
        container.getChildren().add((Object)v2);
        top.getChildren().add((Object)container);
        container = new VBox();
        container.getChildren().add((Object)new Label(Messages.getString("FontDialog.Weight")));
        f = new TextField();
        container.getChildren().add((Object)f);
        v = new ListView();
        v.setItems(FXCollections.observableArrayList((Object[])FontWeight.values()));
        container.getChildren().add((Object)v);
        v.setPrefHeight(250.0);
        v.setPrefWidth(120.0);
        top.getChildren().add((Object)container);
        container = new VBox();
        container.getChildren().add((Object)new Label(Messages.getString("FontDialog.Size")));
        f = new TextField();
        f.setText("" + ((Font)this.font.get()).getSize());
        container.getChildren().add((Object)f);
        v = new ListView();
        ObservableList sizes = FXCollections.observableArrayList((Object[])new Double[]{8.0, 9.0, 10.0, 11.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0, 36.0, 48.0, 72.0});
        if (!sizes.contains((Object)((Font)this.font.get()).getSize())) {
            int i = 0;
            while (i < sizes.size()) {
                if (((Font)this.font.get()).getSize() > (Double)sizes.get(i)) {
                    sizes.add(i, (Object)((Font)this.font.get()).getSize());
                    break;
                }
                ++i;
            }
        }
        v.setItems(sizes);
        v.getSelectionModel().select((Object)((Font)this.font.get()).getSize());
        v.setPrefWidth(80.0);
        v.setPrefHeight(250.0);
        container.getChildren().add((Object)v);
        top.getChildren().add((Object)container);
        p.getChildren().add((Object)top);
        TitledPane tb = new TitledPane();
        tb.setCollapsible(false);
        tb.setText(Messages.getString("FontDialog.Preview"));
        TextField f3 = new TextField("AaBbYyZz");
        f3.fontProperty().bind(this.font);
        f3.setPrefHeight(80.0);
        tb.setContent((Node)f3);
        p.getChildren().add((Object)tb);
        return p;
    }
}

