/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.builder.ModulePathEntry;

class ModuleEntryProcessor {
    ModuleEntryProcessor() {
    }

    static String pushPatchToFront(IClasspathEntry[] classpathEntries) {
        String patchedModule = null;
        int i = 0;
        while (i < classpathEntries.length) {
            IClasspathEntry entry = classpathEntries[i];
            patchedModule = ClasspathEntry.getExtraAttribute(entry, "patch-module");
            if (patchedModule != null) {
                if (i > 0) {
                    IClasspathEntry tmp = classpathEntries[0];
                    classpathEntries[0] = entry;
                    classpathEntries[i] = tmp;
                }
                return patchedModule;
            }
            ++i;
        }
        return null;
    }

    static void combinePatchIntoModuleEntry(ClasspathLocation sourceLocation, IModule patchedModule, Map<String, IModulePathEntry> moduleEntries) {
        sourceLocation.setModule(patchedModule);
        String patchedModuleName = String.valueOf(patchedModule.name());
        IModulePathEntry mainEntry = moduleEntries.get(patchedModuleName);
        ClasspathLocation[] combinedLocations = null;
        if (mainEntry instanceof ModulePathEntry.Multi) {
            ((ModulePathEntry.Multi)mainEntry).addPatchLocation(sourceLocation);
            return;
        }
        if (mainEntry instanceof ClasspathJrt) {
            combinedLocations = new ClasspathLocation[]{(ClasspathLocation)((Object)mainEntry), sourceLocation};
            moduleEntries.put(patchedModuleName, new ModulePathEntry.Multi(null, patchedModule, combinedLocations));
            return;
        }
        if (mainEntry instanceof ModulePathEntry) {
            ClasspathLocation[] mainLocs = ((ModulePathEntry)mainEntry).locations;
            combinedLocations = Arrays.copyOf(mainLocs, mainLocs.length + 1);
            combinedLocations[combinedLocations.length - 1] = sourceLocation;
        } else if (mainEntry instanceof ClasspathLocation) {
            combinedLocations = new ClasspathLocation[]{(ClasspathLocation)((Object)mainEntry), sourceLocation};
        } else {
            throw new IllegalStateException("Cannot patch the module of classpath entry " + mainEntry);
        }
        moduleEntries.put(patchedModuleName, new ModulePathEntry(null, patchedModule, combinedLocations));
    }

    static Set<String> computeLimitModules(ClasspathEntry entry) {
        String extraAttribute = ClasspathEntry.getExtraAttribute(entry, "limit-modules");
        if (extraAttribute == null) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(extraAttribute.split(",")));
    }
}

