/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.scene.Node;
import org.eclipse.fx.drift.impl.NGDriftFXSurface;
import org.eclipse.fx.drift.internal.GraphicsPipelineUtil;
import org.eclipse.fx.drift.internal.JNINativeSurface;
import org.eclipse.fx.drift.internal.Log;
import org.eclipse.fx.drift.internal.NativeAPI;

public class DriftFXSurface
extends Node {
    private long nativeSurfaceId;
    private double _width;
    private ReadOnlyDoubleWrapper width;
    private double _height;
    private ReadOnlyDoubleWrapper height;
    private static boolean initialized = false;

    public long getNativeSurfaceHandle() {
        return this.nativeSurfaceId;
    }

    public DriftFXSurface() {
        JNINativeSurface jni = new JNINativeSurface(frame -> {
            NGDriftFXSurface ngSurface = (NGDriftFXSurface)this.impl_getPeer();
            ngSurface.present((JNINativeSurface.FrameData)frame);
            this.impl_markDirty(DirtyBits.NODE_CONTENTS);
        });
        this.nativeSurfaceId = NativeAPI.createNativeSurface(jni);
    }

    protected NGNode impl_createPeer() {
        NGDriftFXSurface peer = new NGDriftFXSurface(this, this.nativeSurfaceId);
        return peer;
    }

    public double minHeight(double width) {
        return 0.0;
    }

    public double minWidth(double height) {
        return 0.0;
    }

    public double prefWidth(double height) {
        return 100.0;
    }

    public double prefHeight(double width) {
        return 100.0;
    }

    public double maxWidth(double height) {
        return Double.MAX_VALUE;
    }

    public double maxHeight(double width) {
        return Double.MAX_VALUE;
    }

    public BaseBounds impl_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        bounds = new RectBounds(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        bounds = tx.transform(bounds, bounds);
        return bounds;
    }

    protected boolean impl_computeContains(double localX, double localY) {
        double w = this.getWidth();
        double h = this.getHeight();
        return w > 0.0 && h > 0.0 && localX >= 0.0 && localY >= 0.0 && localX < w && localY < h;
    }

    public Object impl_processMXNode(MXNodeAlgorithm alg, MXNodeAlgorithmContext ctx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void widthChanged(double value) {
        if (value != this._width) {
            this._width = value;
            this.impl_layoutBoundsChanged();
            this.impl_geomChanged();
            this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
        }
    }

    public final double getWidth() {
        return this.width == null ? this._width : this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new ReadOnlyDoubleWrapper(this._width){

                protected void invalidated() {
                    DriftFXSurface.this.widthChanged(this.get());
                }

                public Object getBean() {
                    return DriftFXSurface.this;
                }

                public String getName() {
                    return "width";
                }
            };
        }
        return this.width.getReadOnlyProperty();
    }

    protected void setWidth(double value) {
        if (this.width == null) {
            this.widthChanged(value);
        } else {
            this.width.set(value);
        }
    }

    private void heightChanged(double value) {
        if (this._height != value) {
            this._height = value;
            this.impl_geomChanged();
            this.impl_layoutBoundsChanged();
            this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
        }
    }

    public final double getHeight() {
        return this.height == null ? this._height : this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new ReadOnlyDoubleWrapper(this._height){

                protected void invalidated() {
                    DriftFXSurface.this.heightChanged(this.get());
                }

                public Object getBean() {
                    return DriftFXSurface.this;
                }

                public String getName() {
                    return "height";
                }
            };
        }
        return this.height.getReadOnlyProperty();
    }

    protected void setHeight(double value) {
        if (this.height == null) {
            this.heightChanged(value);
        } else {
            this.height.set(value);
        }
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        Log.debug("Initializing NativeSurface system");
        try {
            GraphicsPipelineUtil.initialize();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (GraphicsPipelineUtil.isD3D()) {
            Log.debug(" * D3D Prism Pipeline active");
        } else if (GraphicsPipelineUtil.isSW()) {
            Log.debug(" * SW Prism Pipline active");
        }
        Toolkit.getToolkit().addShutdownHook(DriftFXSurface::destroy);
        initialized = true;
    }

    public static void destroy() {
        if (!initialized) {
            return;
        }
        Log.debug("Destroying NativeSurface system");
        GraphicsPipelineUtil.destroy();
    }

    @Deprecated
    public void impl_updatePeer() {
        super.impl_updatePeer();
        NGDriftFXSurface peer = (NGDriftFXSurface)this.impl_getPeer();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            peer.updateSize((float)this.getWidth(), (float)this.getHeight());
            peer.markDirty();
        }
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            peer.markDirty();
        }
    }

    public boolean isResizable() {
        return true;
    }

    public void resize(double width, double height) {
        this.setWidth(width);
        this.setHeight(height);
        this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
    }

    public void relocate(double x, double y) {
        super.relocate(x, y);
    }

    public void dirty() {
        this.impl_markDirty(DirtyBits.NODE_CONTENTS);
    }
}

