/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal;

import org.eclipse.fx.drift.Placement;

public class SurfaceData {
    public final float width;
    public final float height;
    public final float renderScaleX;
    public final float renderScaleY;
    public final float userScaleX;
    public final float userScaleY;
    public final int transferMode;
    public final Placement placementStrategy;

    public SurfaceData(float width, float height, float renderScaleX, float renderScaleY, float userScaleX, float userScaleY, int transferMode, Placement placementStrategy) {
        this.width = width;
        this.height = height;
        this.renderScaleX = renderScaleX;
        this.renderScaleY = renderScaleY;
        this.userScaleX = userScaleX;
        this.userScaleY = userScaleY;
        this.transferMode = transferMode;
        this.placementStrategy = placementStrategy;
    }

    public String toString() {
        return String.format("SurfaceData[%5.3f x %5.3f] (renderScale: %5.3f x %5.3f, userScale: %5.3f x %5.3f, placement: %s)", Float.valueOf(this.width), Float.valueOf(this.height), Float.valueOf(this.renderScaleX), Float.valueOf(this.renderScaleY), Float.valueOf(this.userScaleX), Float.valueOf(this.userScaleY), this.placementStrategy.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.height);
        result = 31 * result + (this.placementStrategy == null ? 0 : this.placementStrategy.hashCode());
        result = 31 * result + Float.floatToIntBits(this.renderScaleX);
        result = 31 * result + Float.floatToIntBits(this.renderScaleY);
        result = 31 * result + this.transferMode;
        result = 31 * result + Float.floatToIntBits(this.userScaleX);
        result = 31 * result + Float.floatToIntBits(this.userScaleY);
        result = 31 * result + Float.floatToIntBits(this.width);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SurfaceData other = (SurfaceData)obj;
        if (Float.floatToIntBits(this.height) != Float.floatToIntBits(other.height)) {
            return false;
        }
        if (this.placementStrategy != other.placementStrategy) {
            return false;
        }
        if (Float.floatToIntBits(this.renderScaleX) != Float.floatToIntBits(other.renderScaleX)) {
            return false;
        }
        if (Float.floatToIntBits(this.renderScaleY) != Float.floatToIntBits(other.renderScaleY)) {
            return false;
        }
        if (this.transferMode != other.transferMode) {
            return false;
        }
        if (Float.floatToIntBits(this.userScaleX) != Float.floatToIntBits(other.userScaleX)) {
            return false;
        }
        if (Float.floatToIntBits(this.userScaleY) != Float.floatToIntBits(other.userScaleY)) {
            return false;
        }
        return Float.floatToIntBits(this.width) == Float.floatToIntBits(other.width);
    }
}

