/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.impl;

import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLayoutFactory;
import com.sun.javafx.tk.Toolkit;
import com.sun.prism.Graphics;
import com.sun.prism.paint.Paint;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import org.eclipse.fx.drift.internal.DriftUtil;
import org.eclipse.fx.drift.internal.FPSCounter;

public class NGRenderUtil {
    public static void drawFPSGraph(Graphics g, float x, float y, float width, float height, String label, FPSCounter c) {
        int count = 30;
        com.sun.prism.paint.Color bg = new com.sun.prism.paint.Color(0.0f, 0.0f, 0.0f, 0.5f);
        com.sun.prism.paint.Color fg = new com.sun.prism.paint.Color(1.0f, 1.0f, 1.0f, 1.0f);
        float padding = 3.0f;
        g.setPaint((Paint)bg);
        g.fillRect(x, y, width, height);
        float graphWidth = width - 2.0f * padding;
        float graphHeight = height - 2.0f * padding;
        float lineAvail = graphWidth / (float)count;
        float lineWidth = lineAvail * 8.0f / 10.0f;
        for (int i = 0; i < count; ++i) {
            double fps = c.fpsHistory[i];
            double hue = Math.min(1.0, fps / 60.0);
            Color hsb = Color.hsb((double)(hue * 100.0), (double)0.7, (double)0.7);
            g.setPaint((Paint)new com.sun.prism.paint.Color((float)hsb.getRed(), (float)hsb.getGreen(), (float)hsb.getBlue(), 0.5f));
            int norm = (int)Math.round(Math.min((double)graphHeight, fps / 100.0 * (double)graphHeight));
            g.fillRect(x + padding + graphWidth - (float)i * lineAvail - lineAvail, y + padding + graphHeight - (float)norm, lineWidth, (float)norm);
        }
        NGRenderUtil.writeText(g, x, y, 12, String.format("%s", label), fg, false);
        NGRenderUtil.writeText(g, x - width + 100.0f, y + height / 2.0f - 15.0f, 24, String.format("%5.1ffps", c.fps), fg, true);
    }

    public static void writeText(Graphics g, float x, float y, int fontSize, String text, com.sun.prism.paint.Color color, boolean rightAligned) {
        Font font = Font.font((double)fontSize);
        PGFont pgFont = DriftUtil.getFont(font);
        FontStrike strike = pgFont.getStrike(BaseTransform.IDENTITY_TRANSFORM);
        TextLayoutFactory factory = Toolkit.getToolkit().getTextLayoutFactory();
        TextLayout layout = factory.createLayout();
        layout.setContent(text, (Object)pgFont);
        layout.setAlignment(rightAligned ? TextAlignment.RIGHT.ordinal() : TextAlignment.LEFT.ordinal());
        layout.setLineSpacing(0.0f);
        layout.setWrapWidth(0.0f);
        GlyphList[] runs = layout.getRuns();
        float layoutX = x;
        float layoutY = -pgFont.getSize() - y;
        g.setPaint((Paint)color);
        for (int i = 0; i < runs.length; ++i) {
            GlyphList run = runs[i];
            Point2D pt = run.getLocation();
            float gx = pt.x - layoutX;
            float gy = pt.y - layoutY;
            BaseTransform t = BaseTransform.getTranslateInstance((double)gx, (double)gy);
            g.fill(strike.getOutline(run, t));
        }
    }
}

