/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.marker;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public final class SiriusEditorInterpreterMarkerService {
    public static final String TARGET_ATTRIBUTE = "target";
    public static final String FIELD_ATTRIBUTE = "field";

    private SiriusEditorInterpreterMarkerService() {
    }

    public static Collection<IMarker> getValidationMarkersForElement(IResource resource, final String elementURI) {
        Object[] markers = SiriusEditorInterpreterMarkerService.findResourceMarkers(resource, "org.eclipse.emf.ecore.diagnostic");
        ArrayList validationMarkers = markers != null ? Lists.newArrayList((Object[])markers) : new ArrayList();
        ArrayList validationMarkersRelativeToElement = Lists.newArrayList((Iterable)Iterables.filter(validationMarkers, (Predicate)new Predicate<IMarker>(){

            public boolean apply(IMarker input) {
                String uriAttribute = input.getAttribute("uri", null);
                return elementURI.equals(uriAttribute);
            }
        }));
        return validationMarkersRelativeToElement;
    }

    public static Collection<IMarker> getValidationMarkersForElementAndChildren(IResource resource, String elementURI) {
        Object[] markers = SiriusEditorInterpreterMarkerService.findResourceMarkers(resource, "org.eclipse.emf.ecore.diagnostic");
        ArrayList validationMarkers = markers != null ? Lists.newArrayList((Object[])markers) : new ArrayList();
        LinkedHashSet<IMarker> elementMarkers = new LinkedHashSet<IMarker>();
        for (IMarker marker : validationMarkers) {
            String attribute = marker.getAttribute("uri", null);
            if (attribute == null || !attribute.contains(elementURI)) continue;
            elementMarkers.add(marker);
        }
        return elementMarkers;
    }

    private static IMarker[] findResourceMarkers(IResource resource, String type) {
        try {
            return resource.findMarkers(type, true, 2);
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

