/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.InlineMethodDescriptor;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.CallInliner;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.jdt.internal.corext.refactoring.code.TargetProvider;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.util.Progress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class InlineMethodRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_MODE = "mode";
    private static final String ATTRIBUTE_DELETE = "delete";
    private ITypeRoot fInitialTypeRoot;
    private ASTNode fInitialNode;
    private TextChangeManager fChangeManager;
    private SourceProvider fSourceProvider;
    private TargetProvider fTargetProvider;
    private boolean fDeleteSource;
    private Mode fCurrentMode;
    private Mode fInitialMode;
    private int fSelectionStart;
    private int fSelectionLength;

    private InlineMethodRefactoring(ITypeRoot typeRoot, ASTNode node, int offset, int length) {
        Assert.isNotNull((Object)typeRoot);
        Assert.isTrue((boolean)JavaElementUtil.isSourceAvailable((ISourceReference)typeRoot));
        Assert.isNotNull((Object)node);
        this.fInitialTypeRoot = typeRoot;
        this.fInitialNode = node;
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, MethodInvocation node, int offset, int length) {
        this((ITypeRoot)unit, (ASTNode)node, offset, length);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_SINGLE;
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, SuperMethodInvocation node, int offset, int length) {
        this((ITypeRoot)unit, (ASTNode)node, offset, length);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_SINGLE;
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, ConstructorInvocation node, int offset, int length) {
        this((ITypeRoot)unit, (ASTNode)node, offset, length);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_SINGLE;
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ITypeRoot typeRoot, MethodDeclaration node, int offset, int length) {
        this(typeRoot, (ASTNode)node, offset, length);
        this.fSourceProvider = new SourceProvider(typeRoot, node);
        this.fTargetProvider = TargetProvider.create(node);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_ALL;
        this.fDeleteSource = this.canEnableDeleteSource();
    }

    public static InlineMethodRefactoring create(ITypeRoot unit, CompilationUnit node, int selectionStart, int selectionLength) {
        ASTNode target = RefactoringAvailabilityTesterCore.getInlineableMethodNode(unit, node, selectionStart, selectionLength);
        if (target == null) {
            return null;
        }
        if (target.getNodeType() == 31) {
            return new InlineMethodRefactoring(unit, (MethodDeclaration)target, selectionStart, selectionLength);
        }
        ICompilationUnit cu = (ICompilationUnit)unit;
        if (target.getNodeType() == 32) {
            return new InlineMethodRefactoring(cu, (MethodInvocation)target, selectionStart, selectionLength);
        }
        if (target.getNodeType() == 48) {
            return new InlineMethodRefactoring(cu, (SuperMethodInvocation)target, selectionStart, selectionLength);
        }
        if (target.getNodeType() == 17) {
            return new InlineMethodRefactoring(cu, (ConstructorInvocation)target, selectionStart, selectionLength);
        }
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.InlineMethodRefactoring_name;
    }

    public IMethod getMethod() {
        if (this.fSourceProvider == null) {
            return null;
        }
        IMethodBinding binding = this.fSourceProvider.getDeclaration().resolveBinding();
        if (binding == null) {
            return null;
        }
        return (IMethod)binding.getJavaElement();
    }

    public boolean canEnableDeleteSource() {
        return !(this.fSourceProvider.getTypeRoot() instanceof IClassFile);
    }

    public boolean getDeleteSource() {
        return this.fDeleteSource;
    }

    public void setDeleteSource(boolean remove) {
        if (remove) {
            Assert.isTrue((boolean)this.canEnableDeleteSource());
        }
        this.fDeleteSource = remove;
    }

    public Mode getInitialMode() {
        return this.fInitialMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus setCurrentMode(Mode mode) throws JavaModelException {
        if (this.fCurrentMode == mode) {
            return new RefactoringStatus();
        }
        Assert.isTrue((this.getInitialMode() == Mode.INLINE_SINGLE ? 1 : 0) != 0);
        this.fCurrentMode = mode;
        if (mode == Mode.INLINE_SINGLE) {
            if (this.fInitialNode instanceof MethodInvocation) {
                this.fTargetProvider = TargetProvider.create((ICompilationUnit)this.fInitialTypeRoot, (MethodInvocation)this.fInitialNode);
                return this.fTargetProvider.checkActivation();
            } else if (this.fInitialNode instanceof SuperMethodInvocation) {
                this.fTargetProvider = TargetProvider.create((ICompilationUnit)this.fInitialTypeRoot, (SuperMethodInvocation)this.fInitialNode);
                return this.fTargetProvider.checkActivation();
            } else {
                if (!(this.fInitialNode instanceof ConstructorInvocation)) throw new IllegalStateException(String.valueOf(this.fInitialNode));
                this.fTargetProvider = TargetProvider.create((ICompilationUnit)this.fInitialTypeRoot, (ConstructorInvocation)this.fInitialNode);
            }
            return this.fTargetProvider.checkActivation();
        } else {
            this.fTargetProvider = TargetProvider.create(this.fSourceProvider.getDeclaration());
        }
        return this.fTargetProvider.checkActivation();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.fSourceProvider == null && Invocations.isInvocation(this.fInitialNode)) {
            this.fSourceProvider = InlineMethodRefactoring.resolveSourceProvider(result, this.fInitialTypeRoot, this.fInitialNode);
            if (result.hasFatalError()) {
                return result;
            }
        }
        result.merge(this.fSourceProvider.checkActivation());
        result.merge(this.fTargetProvider.checkActivation());
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 20);
        this.fChangeManager = new TextChangeManager();
        RefactoringStatus result = new RefactoringStatus();
        this.fSourceProvider.initialize();
        this.fTargetProvider.initialize();
        pm.setTaskName(RefactoringCoreMessages.InlineMethodRefactoring_searching);
        RefactoringStatus searchStatus = new RefactoringStatus();
        String binaryRefsDescription = Messages.format(RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, BasicElementLabels.getJavaElementName(this.fSourceProvider.getMethodName()));
        ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
        ICompilationUnit[] units = this.fTargetProvider.getAffectedCompilationUnits(searchStatus, binaryRefs, Progress.subMonitor(pm, 1));
        binaryRefs.addErrorIfNecessary(searchStatus);
        if (searchStatus.hasFatalError()) {
            result.merge(searchStatus);
            return result;
        }
        IFile[] filesToBeModified = this.getFilesToBeModified(units);
        result.merge(Checks.validateModifiesFiles(filesToBeModified, this.getValidationContext(), pm));
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(ResourceChangeChecker.checkFilesToBeChanged((IFile[])filesToBeModified, (IProgressMonitor)Progress.subMonitor(pm, 1)));
        this.checkOverridden(result, Progress.subMonitor(pm, 4));
        IProgressMonitor sub = Progress.subMonitor(pm, 15);
        sub.beginTask("", units.length * 3);
        ICompilationUnit[] iCompilationUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            block21: {
                ICompilationUnit unit = iCompilationUnitArray[n2];
                sub.subTask(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_processing, BasicElementLabels.getFileName((ITypeRoot)unit)));
                CallInliner inliner = null;
                try {
                    int n3;
                    boolean added = false;
                    MultiTextEdit root = new MultiTextEdit();
                    CompilationUnitChange change = (CompilationUnitChange)this.fChangeManager.get(unit);
                    change.setEdit((TextEdit)root);
                    BodyDeclaration[] bodies = this.fTargetProvider.getAffectedBodyDeclarations(unit, Progress.subMonitor(pm, 1));
                    if (bodies.length == 0) break block21;
                    inliner = new CallInliner(unit, (CompilationUnit)bodies[0].getRoot(), this.fSourceProvider);
                    BodyDeclaration[] bodyDeclarationArray = bodies;
                    int n4 = bodies.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        ASTNode[] invocations;
                        BodyDeclaration body = bodyDeclarationArray[n5];
                        inliner.initialize(body);
                        RefactoringStatus nestedInvocations = new RefactoringStatus();
                        ASTNode[] aSTNodeArray = invocations = this.removeNestedCalls(nestedInvocations, unit, this.fTargetProvider.getInvocations(body, Progress.subMonitor(sub, 2)));
                        int n6 = invocations.length;
                        n3 = 0;
                        while (n3 < n6) {
                            ASTNode invocation = aSTNodeArray[n3];
                            result.merge(inliner.initialize(invocation, this.fTargetProvider.getStatusSeverity()));
                            if (result.hasFatalError()) break;
                            if (result.getSeverity() < this.fTargetProvider.getStatusSeverity()) {
                                added = true;
                                TextEditGroup group = new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_inline);
                                change.addTextEditGroup(group);
                                result.merge(inliner.perform(group));
                            } else {
                                this.fDeleteSource = false;
                            }
                            ++n3;
                        }
                        if (!nestedInvocations.isOK()) {
                            result.merge(nestedInvocations);
                            this.fDeleteSource = false;
                        }
                        ++n5;
                    }
                    if (!added) {
                        this.fChangeManager.remove(unit);
                    } else {
                        root.addChild(inliner.getModifications());
                        ImportRewrite rewrite = inliner.getImportEdit();
                        if (rewrite.hasRecordedChanges()) {
                            TextEdit edit;
                            String[] stringArray = rewrite.getAddedImports();
                            int n7 = stringArray.length;
                            n4 = 0;
                            while (n4 < n7) {
                                String s = stringArray[n4];
                                IType[] iTypeArray = unit.getTypes();
                                n3 = iTypeArray.length;
                                int n8 = 0;
                                while (n8 < n3) {
                                    IType t = iTypeArray[n8];
                                    if (s.startsWith(t.getFullyQualifiedName())) {
                                        rewrite.removeImport(s);
                                    }
                                    ++n8;
                                }
                                ++n4;
                            }
                            if (rewrite.hasRecordedChanges() && (!((edit = rewrite.rewriteImports(null)) instanceof MultiTextEdit) || ((MultiTextEdit)edit).getChildrenSize() > 0)) {
                                root.addChild(edit);
                                change.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_import, new TextEdit[]{edit}));
                            }
                        }
                    }
                }
                finally {
                    if (inliner != null) {
                        inliner.dispose();
                    }
                }
                sub.worked(1);
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++n2;
        }
        result.merge(searchStatus);
        sub.done();
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.fDeleteSource && this.fCurrentMode == Mode.INLINE_ALL) {
            TextChange change = this.fChangeManager.get((ICompilationUnit)this.fSourceProvider.getTypeRoot());
            TextEdit delete = this.fSourceProvider.getDeleteEdit();
            TextEditGroup description = new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_delete, new TextEdit[]{delete});
            TextEdit root = change.getEdit();
            if (root != null) {
                TextChangeCompatibility.insert(root, delete);
            } else {
                change.setEdit(delete);
            }
            change.addTextEditGroup(description);
        }
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fInitialTypeRoot.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 786434;
        IMethodBinding binding = this.fSourceProvider.getDeclaration().resolveBinding();
        ITypeBinding declaring = binding.getDeclaringClass();
        if (!Modifier.isPrivate((int)binding.getModifiers())) {
            flags |= 4;
        }
        String description = Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(binding.getName()));
        String header = Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_descriptor_description, new String[]{BindingLabelProviderCore.getBindingLabel((IBinding)binding, 2235681801344L), BindingLabelProviderCore.getBindingLabel((IBinding)declaring, 2235681801344L)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_original_pattern, BindingLabelProviderCore.getBindingLabel((IBinding)binding, 2235681801344L)));
        if (this.fDeleteSource) {
            comment.addSetting(RefactoringCoreMessages.InlineMethodRefactoring_remove_method);
        }
        if (this.fCurrentMode == Mode.INLINE_ALL) {
            comment.addSetting(RefactoringCoreMessages.InlineMethodRefactoring_replace_references);
        }
        InlineMethodDescriptor descriptor = RefactoringSignatureDescriptorFactory.createInlineMethodDescriptor(project, description, comment.asString(), arguments, flags);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fInitialTypeRoot));
        arguments.put("selection", Integer.toString(this.fSelectionStart) + " " + Integer.toString(this.fSelectionLength));
        arguments.put(ATTRIBUTE_DELETE, Boolean.toString(this.fDeleteSource));
        arguments.put(ATTRIBUTE_MODE, Integer.toString(this.fCurrentMode == Mode.INLINE_ALL ? 1 : 0));
        return new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.InlineMethodRefactoring_edit_inlineCall, (Change[])this.fChangeManager.getAllChanges());
    }

    private static SourceProvider resolveSourceProvider(RefactoringStatus status, ITypeRoot typeRoot, ASTNode invocation) {
        CompilationUnit root = (CompilationUnit)invocation.getRoot();
        IMethodBinding methodBinding = Invocations.resolveBinding(invocation);
        if (methodBinding == null) {
            status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
            return null;
        }
        MethodDeclaration declaration = (MethodDeclaration)root.findDeclaringNode((IBinding)methodBinding);
        if (declaration != null) {
            return new SourceProvider(typeRoot, declaration);
        }
        IMethod method = (IMethod)methodBinding.getJavaElement();
        if (method != null) {
            CompilationUnit methodDeclarationAstRoot;
            ICompilationUnit methodCu = method.getCompilationUnit();
            if (methodCu != null) {
                methodDeclarationAstRoot = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse((ITypeRoot)methodCu, true);
            } else {
                IClassFile classFile = method.getClassFile();
                if (!JavaElementUtil.isSourceAvailable((ISourceReference)classFile)) {
                    String methodLabel = JavaElementLabelsCore.getTextLabel(method, 129L);
                    status.addFatalError(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_error_classFile, methodLabel));
                    return null;
                }
                methodDeclarationAstRoot = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse((ITypeRoot)classFile, true);
            }
            ASTNode node = methodDeclarationAstRoot.findDeclaringNode(methodBinding.getMethodDeclaration().getKey());
            if (node instanceof MethodDeclaration) {
                return new SourceProvider(methodDeclarationAstRoot.getTypeRoot(), (MethodDeclaration)node);
            }
        }
        status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
        return null;
    }

    private IFile[] getFilesToBeModified(ICompilationUnit[] units) {
        IFile file;
        ArrayList<IFile> result = new ArrayList<IFile>(units.length + 1);
        ICompilationUnit[] iCompilationUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit unit = iCompilationUnitArray[n2];
            file = this.getFile(unit);
            if (file != null) {
                result.add(file);
            }
            ++n2;
        }
        if (this.fDeleteSource && (file = this.getFile((ICompilationUnit)this.fSourceProvider.getTypeRoot())) != null && !result.contains(file)) {
            result.add(file);
        }
        return result.toArray(new IFile[result.size()]);
    }

    private IFile getFile(ICompilationUnit unit) {
        IResource resource = (unit = unit.getPrimary()).getResource();
        if (resource != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    private void checkOverridden(RefactoringStatus status, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 9);
        pm.setTaskName(RefactoringCoreMessages.InlineMethodRefactoring_checking_overridden);
        MethodDeclaration decl = this.fSourceProvider.getDeclaration();
        IMethod method = (IMethod)decl.resolveBinding().getJavaElement();
        if (method == null || Flags.isPrivate((int)method.getFlags())) {
            pm.worked(8);
            return;
        }
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = type.newTypeHierarchy(Progress.subMonitor(pm, 6));
        this.checkSubTypes(status, method, hierarchy.getAllSubtypes(type), Progress.subMonitor(pm, 1));
        this.checkSuperClasses(status, method, hierarchy.getAllSuperclasses(type), Progress.subMonitor(pm, 1));
        this.checkSuperInterfaces(status, method, hierarchy.getAllSuperInterfaces(type), Progress.subMonitor(pm, 1));
        pm.setTaskName("");
    }

    private void checkSubTypes(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, RefactoringCoreMessages.InlineMethodRefactoring_checking_overridden_error, pm);
    }

    private void checkSuperClasses(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, RefactoringCoreMessages.InlineMethodRefactoring_checking_overrides_error, pm);
    }

    private void checkSuperInterfaces(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, RefactoringCoreMessages.InlineMethodRefactoring_checking_implements_error, pm);
    }

    private void checkTypes(RefactoringStatus result, IMethod method, IType[] types, String key, IProgressMonitor pm) {
        pm.beginTask("", types.length);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            pm.worked(1);
            IMethod[] overridden = type.findMethods(method);
            if (overridden != null && overridden.length > 0) {
                result.addError(Messages.format(key, JavaElementLabelsCore.getElementLabel((IJavaElement)type, 0x200009L)), JavaStatusContext.create((IMember)overridden[0]));
            }
            ++n2;
        }
    }

    private ASTNode[] removeNestedCalls(RefactoringStatus status, ICompilationUnit unit, ASTNode[] invocations) {
        if (invocations.length <= 1) {
            return invocations;
        }
        ASTNode[] parents = new ASTNode[invocations.length];
        int i = 0;
        while (i < invocations.length) {
            parents[i] = invocations[i].getParent();
            ++i;
        }
        i = 0;
        while (i < invocations.length) {
            this.removeNestedCalls(status, unit, parents, invocations, i);
            ++i;
        }
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        ASTNode[] aSTNodeArray = invocations;
        int n = invocations.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode invocation = aSTNodeArray[n2];
            if (invocation != null) {
                result.add(invocation);
            }
            ++n2;
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    private void removeNestedCalls(RefactoringStatus status, ICompilationUnit unit, ASTNode[] parents, ASTNode[] invocations, int index) {
        ASTNode invocation = invocations[index];
        ASTNode[] aSTNodeArray = parents;
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode parent2;
            ASTNode parent = parent2 = aSTNodeArray[n2];
            while (parent != null) {
                if (parent == invocation) {
                    status.addError(RefactoringCoreMessages.InlineMethodRefactoring_nestedInvocation, JavaStatusContext.create((ITypeRoot)unit, parent));
                    invocations[index] = null;
                }
                parent = parent.getParent();
            }
            ++n2;
        }
    }

    public static class Mode {
        public static final Mode INLINE_ALL = new Mode();
        public static final Mode INLINE_SINGLE = new Mode();

        private Mode() {
        }
    }
}

