/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.attrdecl.ad_name.ad_name00111.ad_name00111;

import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class AD_name00111_CTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        AD_name00111_CTTests test = new AD_name00111_CTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status Get001( ) {
        Root root = (Root)unmarshal("AD_name00111_p.xml");
        String failure = "";

        if (root.getAA() != 0) {
            failure += "; root.getAA() returns " + root.getAA();
        }
        if (root.getBB() != 1) {
            failure += "; root.getBB() returns " + root.getBB();
        }
        if (root.getCC() != 2) {
            failure += "; root.getCC() returns " + root.getCC();
        }
        if (root.getDD() != 3) {
            failure += "; root.getDD() returns " + root.getDD();
        }
        if (root.getEE() != 4) {
            failure += "; root.getEE() returns " + root.getEE();
        }
        if (root.getFF() != 5) {
            failure += "; root.getFF() returns " + root.getFF();
        }
        if (root.getGG() != 6) {
            failure += "; root.getGG() returns " + root.getGG();
        }

        if (failure.length() == 0) {
            return Status.passed("OK");
        }

        return Status.failed(failure.substring(2));
    }

    public Status Set001( ) {
        Root root = (Root)unmarshal("AD_name00111_p.xml");
        String failure = "";

        root.setAA(11);
        root.setBB(22);
        root.setCC(33);
        root.setDD(44);
        root.setEE(55);
        root.setFF(66);
        root.setGG(77);

        if (root.getAA() != 11) {
            failure += "; root.getAA() returns " + root.getAA();
        }
        if (root.getBB() != 22) {
            failure += "; root.getBB() returns " + root.getBB();
        }
        if (root.getCC() != 33) {
            failure += "; root.getCC() returns " + root.getCC();
        }
        if (root.getDD() != 44) {
            failure += "; root.getDD() returns " + root.getDD();
        }
        if (root.getEE() != 55) {
            failure += "; root.getEE() returns " + root.getEE();
        }
        if (root.getFF() != 66) {
            failure += "; root.getFF() returns " + root.getFF();
        }
        if (root.getGG() != 77) {
            failure += "; root.getGG() returns " + root.getGG();
        }

        if (failure.length() == 0) {
            return Status.passed("OK");
        }

        return Status.failed(failure.substring(2));
    }


}

