/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Connection;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class SerialPortConnection
implements Connection {
    private String name;
    private SerialPort port;
    private InputStream portInputStream;
    private OutputStream portOutputStream;
    private boolean closed;
    private static final int baudRate = Integer.getInteger("javatest.serialPort.baudRate", 38400);

    public SerialPortConnection(String name, String app, int timeout) throws IOException, NoSuchPortException, PortInUseException, InterruptedException {
        this(SerialPortConnection.open(CommPortIdentifier.getPortIdentifier((String)name), app, timeout));
    }

    public SerialPortConnection(CommPortIdentifier portId, String app, int timeout) throws IOException, PortInUseException, InterruptedException {
        this(SerialPortConnection.open(portId, app, timeout));
    }

    private SerialPortConnection(SerialPort port) throws IOException, InterruptedException {
        this.port = port;
        this.portInputStream = port.getInputStream();
        this.portOutputStream = port.getOutputStream();
        try {
            port.setSerialPortParams(baudRate, 8, 1, 0);
            port.setFlowControlMode(3);
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException(e.toString());
        }
        int bytesToFlush = this.portInputStream.available();
        if (bytesToFlush > 0) {
            this.portInputStream.skip(bytesToFlush);
        }
        port.setDTR(true);
        try {
            port.addEventListener(new SerialPortEventListener(){

                public void serialEvent(SerialPortEvent ev) {
                    int t = ev.getEventType();
                    switch (ev.getEventType()) {
                        case 4: 
                        case 6: {
                            SerialPortConnection.this.updateReadyStatus();
                        }
                    }
                }
            });
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        port.notifyOnCarrierDetect(true);
        port.notifyOnDSR(true);
        this.waitUntilReady();
    }

    @Override
    public String getName() {
        return this.port.getName();
    }

    @Override
    public InputStream getInputStream() {
        return this.portInputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return new FilterOutputStream(this.portOutputStream){

            @Override
            public void flush() throws IOException {
                if (!SerialPortConnection.this.closed) {
                    super.flush();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            try {
                this.port.setDTR(false);
                this.port.close();
            }
            finally {
                this.closed = true;
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void waitUntilClosed(int timeout) throws InterruptedException {
        long now = System.currentTimeMillis();
        long end = now + (long)timeout;
        while (now < end && !this.closed) {
            this.wait(end - now);
            now = System.currentTimeMillis();
        }
    }

    private static SerialPort open(CommPortIdentifier cpi, String app, int timeout) throws IOException, PortInUseException {
        if (cpi.getPortType() != 1) {
            throw new IllegalArgumentException("not a serial port: " + cpi.getName());
        }
        return (SerialPort)cpi.open(app, timeout);
    }

    private synchronized void updateReadyStatus() {
        if (this.port.isDSR() || this.port.isCD()) {
            this.notifyAll();
        } else {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        SerialPortConnection.this.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            t.start();
        }
    }

    private synchronized void waitUntilReady() throws InterruptedException {
        while (!this.port.isDSR() && !this.port.isCD()) {
            this.wait();
        }
    }

    private String parityToString(int parity) {
        switch (parity) {
            case 0: {
                return "none";
            }
            case 1: {
                return "odd";
            }
            case 2: {
                return "even";
            }
            case 3: {
                return "mark";
            }
            case 4: {
                return "space";
            }
        }
        return "?" + parity + "?";
    }

    private String flowControlToString(int flowControl) {
        switch (flowControl) {
            case 0: {
                return "none";
            }
            case 3: {
                return "h/w";
            }
            case 12: {
                return "s/w";
            }
        }
        return "?" + flowControl + "?";
    }
}

