/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._short.totaldigits.totaldigits_5;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class totalDigits5_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        totalDigits5_ValidateCTTests test = new totalDigits5_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final short[] validValues = {(short)-32768, (short)-1000, (short)-100, (short)-10, (short)0, (short)10, (short)100, (short)1000, (short)32767};
    
    JAXBElement<Short> elemObj;

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "totalDigits-5-1.xml";
        elemObj = (JAXBElement<Short>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<Short>)(new ObjectFactory()).createNISTSchemaShortTotalDigits5((short)-10);
        
        return testValid();
    }


}

