/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public final class Utils8 {
    @SafeVarargs
    public static <U> Set<U> setOf(U ... UArray) {
        HashSet<U> hashSet = new HashSet<U>(UArray.length);
        for (U u : UArray) {
            hashSet.add(u);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @SafeVarargs
    public static <U> List<U> listOf(U ... UArray) {
        ArrayList<U> arrayList = new ArrayList<U>(UArray.length);
        for (U u : UArray) {
            arrayList.add(u);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static <U> CompletableFuture<U> failedFuture(Throwable throwable) {
        CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.completeExceptionally(throwable);
        return completableFuture;
    }

    public static <U> void completeAsync(CompletableFuture<U> completableFuture, Supplier<? extends U> supplier, Executor executor) {
        executor.execute(() -> completableFuture.complete(supplier.get()));
    }

    private Utils8() {
    }
}

