/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.launcher;

import java.nio.charset.Charset;
import org.glassfish.cluster.ssh.launcher.OperatingSystem;

public class RemoteSystemCapabilities {
    private final String javaHome;
    private final String javaExecutable;
    private final Runtime.Version javaVersion;
    private final OperatingSystem operatingSystem;
    private final Charset charset;

    RemoteSystemCapabilities(String javaHome, Runtime.Version javaVersion, OperatingSystem operatingSystem, Charset charset) {
        this.javaHome = javaHome;
        this.javaVersion = javaVersion;
        this.operatingSystem = operatingSystem;
        this.charset = charset;
        this.javaExecutable = javaHome + (operatingSystem == OperatingSystem.WINDOWS ? "/bin/java.exe" : "/bin/java");
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public boolean isJavaSupported() {
        return this.javaHome != null && this.javaVersion != null;
    }

    public boolean isChmodSupported() {
        return this.operatingSystem != OperatingSystem.WINDOWS;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[os=" + String.valueOf((Object)this.operatingSystem) + ", charset=" + String.valueOf(this.charset) + ", javaHome=" + this.javaHome + ", javaVersion=" + String.valueOf(this.javaVersion) + "]";
    }
}

