/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import com.sun.corba.ee.impl.util.PackagePrefixChecker;
import java.io.File;
import org.glassfish.rmic.Constants;
import org.glassfish.rmic.iiop.BatchEnvironment;
import org.glassfish.rmic.tools.java.Identifier;

public final class Util
implements Constants {
    public static String packagePrefix() {
        return PackagePrefixChecker.packagePrefix();
    }

    private static File getOutputDirectoryFor(Identifier theClass, File rootDir, BatchEnvironment env, boolean idl) {
        File outputDir = null;
        String className = theClass.getFlatName().toString().replace('.', '$');
        Object qualifiedClassName = className;
        String packagePath = null;
        String packageName = theClass.getQualifier().toString();
        if ((packageName = Util.correctPackageName(packageName, idl, env.getStandardPackage())).length() > 0) {
            qualifiedClassName = packageName + "." + className;
            packagePath = packageName.replace('.', File.separatorChar);
        }
        if (rootDir != null) {
            if (packagePath != null) {
                outputDir = new File(rootDir, packagePath);
                Util.ensureDirectory(outputDir, env);
            } else {
                outputDir = rootDir;
            }
        } else {
            String workingDirPath = System.getProperty("user.dir");
            File workingDir = new File(workingDirPath);
            if (packagePath == null) {
                outputDir = workingDir;
            } else {
                outputDir = new File(workingDir, packagePath);
                Util.ensureDirectory(outputDir, env);
            }
        }
        return outputDir;
    }

    public static File getOutputDirectoryForIDL(Identifier theClass, File rootDir, BatchEnvironment env) {
        return Util.getOutputDirectoryFor(theClass, rootDir, env, true);
    }

    public static File getOutputDirectoryForStub(Identifier theClass, File rootDir, BatchEnvironment env) {
        return Util.getOutputDirectoryFor(theClass, rootDir, env, false);
    }

    private static void ensureDirectory(File dir, BatchEnvironment env) {
        if (!dir.exists()) {
            dir.mkdirs();
            if (!dir.exists()) {
                env.error(0L, "rmic.cannot.create.dir", dir.getAbsolutePath());
                throw new InternalError();
            }
        }
    }

    public static String correctPackageName(String p, boolean idl, boolean standardPackage) {
        if (idl) {
            return p;
        }
        if (standardPackage) {
            return p;
        }
        return PackagePrefixChecker.correctPackageName((String)p);
    }

    public static boolean isOffendingPackage(String p) {
        return PackagePrefixChecker.isOffendingPackage((String)p);
    }

    public static boolean hasOffendingPrefix(String p) {
        return PackagePrefixChecker.hasOffendingPrefix((String)p);
    }
}

