/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;

public final class Huffman {
    public static final Huffman INSTANCE = new Huffman();
    private final Code EOS = new Code(0x3FFFFFFF, 30);
    private final Code[] codes = new Code[257];
    private final Node root = new Node(this){

        @Override
        public String toString() {
            return "root";
        }
    };

    private Huffman() {
        this.addChar(0, 8184, 13);
        this.addChar(1, 8388568, 23);
        this.addChar(2, 0xFFFFFE2, 28);
        this.addChar(3, 0xFFFFFE3, 28);
        this.addChar(4, 0xFFFFFE4, 28);
        this.addChar(5, 0xFFFFFE5, 28);
        this.addChar(6, 0xFFFFFE6, 28);
        this.addChar(7, 0xFFFFFE7, 28);
        this.addChar(8, 0xFFFFFE8, 28);
        this.addChar(9, 0xFFFFEA, 24);
        this.addChar(10, 0x3FFFFFFC, 30);
        this.addChar(11, 0xFFFFFE9, 28);
        this.addChar(12, 0xFFFFFEA, 28);
        this.addChar(13, 0x3FFFFFFD, 30);
        this.addChar(14, 0xFFFFFEB, 28);
        this.addChar(15, 0xFFFFFEC, 28);
        this.addChar(16, 0xFFFFFED, 28);
        this.addChar(17, 0xFFFFFEE, 28);
        this.addChar(18, 0xFFFFFEF, 28);
        this.addChar(19, 0xFFFFFF0, 28);
        this.addChar(20, 0xFFFFFF1, 28);
        this.addChar(21, 0xFFFFFF2, 28);
        this.addChar(22, 0x3FFFFFFE, 30);
        this.addChar(23, 0xFFFFFF3, 28);
        this.addChar(24, 0xFFFFFF4, 28);
        this.addChar(25, 0xFFFFFF5, 28);
        this.addChar(26, 0xFFFFFF6, 28);
        this.addChar(27, 0xFFFFFF7, 28);
        this.addChar(28, 0xFFFFFF8, 28);
        this.addChar(29, 0xFFFFFF9, 28);
        this.addChar(30, 0xFFFFFFA, 28);
        this.addChar(31, 0xFFFFFFB, 28);
        this.addChar(32, 20, 6);
        this.addChar(33, 1016, 10);
        this.addChar(34, 1017, 10);
        this.addChar(35, 4090, 12);
        this.addChar(36, 8185, 13);
        this.addChar(37, 21, 6);
        this.addChar(38, 248, 8);
        this.addChar(39, 2042, 11);
        this.addChar(40, 1018, 10);
        this.addChar(41, 1019, 10);
        this.addChar(42, 249, 8);
        this.addChar(43, 2043, 11);
        this.addChar(44, 250, 8);
        this.addChar(45, 22, 6);
        this.addChar(46, 23, 6);
        this.addChar(47, 24, 6);
        this.addChar(48, 0, 5);
        this.addChar(49, 1, 5);
        this.addChar(50, 2, 5);
        this.addChar(51, 25, 6);
        this.addChar(52, 26, 6);
        this.addChar(53, 27, 6);
        this.addChar(54, 28, 6);
        this.addChar(55, 29, 6);
        this.addChar(56, 30, 6);
        this.addChar(57, 31, 6);
        this.addChar(58, 92, 7);
        this.addChar(59, 251, 8);
        this.addChar(60, 32764, 15);
        this.addChar(61, 32, 6);
        this.addChar(62, 4091, 12);
        this.addChar(63, 1020, 10);
        this.addChar(64, 8186, 13);
        this.addChar(65, 33, 6);
        this.addChar(66, 93, 7);
        this.addChar(67, 94, 7);
        this.addChar(68, 95, 7);
        this.addChar(69, 96, 7);
        this.addChar(70, 97, 7);
        this.addChar(71, 98, 7);
        this.addChar(72, 99, 7);
        this.addChar(73, 100, 7);
        this.addChar(74, 101, 7);
        this.addChar(75, 102, 7);
        this.addChar(76, 103, 7);
        this.addChar(77, 104, 7);
        this.addChar(78, 105, 7);
        this.addChar(79, 106, 7);
        this.addChar(80, 107, 7);
        this.addChar(81, 108, 7);
        this.addChar(82, 109, 7);
        this.addChar(83, 110, 7);
        this.addChar(84, 111, 7);
        this.addChar(85, 112, 7);
        this.addChar(86, 113, 7);
        this.addChar(87, 114, 7);
        this.addChar(88, 252, 8);
        this.addChar(89, 115, 7);
        this.addChar(90, 253, 8);
        this.addChar(91, 8187, 13);
        this.addChar(92, 524272, 19);
        this.addChar(93, 8188, 13);
        this.addChar(94, 16380, 14);
        this.addChar(95, 34, 6);
        this.addChar(96, 32765, 15);
        this.addChar(97, 3, 5);
        this.addChar(98, 35, 6);
        this.addChar(99, 4, 5);
        this.addChar(100, 36, 6);
        this.addChar(101, 5, 5);
        this.addChar(102, 37, 6);
        this.addChar(103, 38, 6);
        this.addChar(104, 39, 6);
        this.addChar(105, 6, 5);
        this.addChar(106, 116, 7);
        this.addChar(107, 117, 7);
        this.addChar(108, 40, 6);
        this.addChar(109, 41, 6);
        this.addChar(110, 42, 6);
        this.addChar(111, 7, 5);
        this.addChar(112, 43, 6);
        this.addChar(113, 118, 7);
        this.addChar(114, 44, 6);
        this.addChar(115, 8, 5);
        this.addChar(116, 9, 5);
        this.addChar(117, 45, 6);
        this.addChar(118, 119, 7);
        this.addChar(119, 120, 7);
        this.addChar(120, 121, 7);
        this.addChar(121, 122, 7);
        this.addChar(122, 123, 7);
        this.addChar(123, 32766, 15);
        this.addChar(124, 2044, 11);
        this.addChar(125, 16381, 14);
        this.addChar(126, 8189, 13);
        this.addChar(127, 0xFFFFFFC, 28);
        this.addChar(128, 1048550, 20);
        this.addChar(129, 4194258, 22);
        this.addChar(130, 1048551, 20);
        this.addChar(131, 1048552, 20);
        this.addChar(132, 0x3FFFD3, 22);
        this.addChar(133, 4194260, 22);
        this.addChar(134, 4194261, 22);
        this.addChar(135, 8388569, 23);
        this.addChar(136, 4194262, 22);
        this.addChar(137, 8388570, 23);
        this.addChar(138, 8388571, 23);
        this.addChar(139, 8388572, 23);
        this.addChar(140, 0x7FFFDD, 23);
        this.addChar(141, 8388574, 23);
        this.addChar(142, 0xFFFFEB, 24);
        this.addChar(143, 0x7FFFDF, 23);
        this.addChar(144, 0xFFFFEC, 24);
        this.addChar(145, 0xFFFFED, 24);
        this.addChar(146, 4194263, 22);
        this.addChar(147, 8388576, 23);
        this.addChar(148, 0xFFFFEE, 24);
        this.addChar(149, 8388577, 23);
        this.addChar(150, 8388578, 23);
        this.addChar(151, 8388579, 23);
        this.addChar(152, 8388580, 23);
        this.addChar(153, 2097116, 21);
        this.addChar(154, 4194264, 22);
        this.addChar(155, 8388581, 23);
        this.addChar(156, 4194265, 22);
        this.addChar(157, 8388582, 23);
        this.addChar(158, 0x7FFFE7, 23);
        this.addChar(159, 0xFFFFEF, 24);
        this.addChar(160, 4194266, 22);
        this.addChar(161, 0x1FFFDD, 21);
        this.addChar(162, 1048553, 20);
        this.addChar(163, 4194267, 22);
        this.addChar(164, 4194268, 22);
        this.addChar(165, 8388584, 23);
        this.addChar(166, 8388585, 23);
        this.addChar(167, 2097118, 21);
        this.addChar(168, 8388586, 23);
        this.addChar(169, 0x3FFFDD, 22);
        this.addChar(170, 4194270, 22);
        this.addChar(171, 0xFFFFF0, 24);
        this.addChar(172, 0x1FFFDF, 21);
        this.addChar(173, 0x3FFFDF, 22);
        this.addChar(174, 8388587, 23);
        this.addChar(175, 8388588, 23);
        this.addChar(176, 2097120, 21);
        this.addChar(177, 0x1FFFE1, 21);
        this.addChar(178, 4194272, 22);
        this.addChar(179, 2097122, 21);
        this.addChar(180, 8388589, 23);
        this.addChar(181, 4194273, 22);
        this.addChar(182, 0x7FFFEE, 23);
        this.addChar(183, 0x7FFFEF, 23);
        this.addChar(184, 1048554, 20);
        this.addChar(185, 4194274, 22);
        this.addChar(186, 0x3FFFE3, 22);
        this.addChar(187, 4194276, 22);
        this.addChar(188, 0x7FFFF0, 23);
        this.addChar(189, 4194277, 22);
        this.addChar(190, 4194278, 22);
        this.addChar(191, 0x7FFFF1, 23);
        this.addChar(192, 67108832, 26);
        this.addChar(193, 67108833, 26);
        this.addChar(194, 1048555, 20);
        this.addChar(195, 524273, 19);
        this.addChar(196, 4194279, 22);
        this.addChar(197, 0x7FFFF2, 23);
        this.addChar(198, 4194280, 22);
        this.addChar(199, 33554412, 25);
        this.addChar(200, 67108834, 26);
        this.addChar(201, 0x3FFFFE3, 26);
        this.addChar(202, 67108836, 26);
        this.addChar(203, 134217694, 27);
        this.addChar(204, 0x7FFFFDF, 27);
        this.addChar(205, 67108837, 26);
        this.addChar(206, 0xFFFFF1, 24);
        this.addChar(207, 33554413, 25);
        this.addChar(208, 524274, 19);
        this.addChar(209, 2097123, 21);
        this.addChar(210, 67108838, 26);
        this.addChar(211, 134217696, 27);
        this.addChar(212, 134217697, 27);
        this.addChar(213, 67108839, 26);
        this.addChar(214, 134217698, 27);
        this.addChar(215, 0xFFFFF2, 24);
        this.addChar(216, 2097124, 21);
        this.addChar(217, 2097125, 21);
        this.addChar(218, 67108840, 26);
        this.addChar(219, 67108841, 26);
        this.addChar(220, 0xFFFFFFD, 28);
        this.addChar(221, 134217699, 27);
        this.addChar(222, 134217700, 27);
        this.addChar(223, 134217701, 27);
        this.addChar(224, 1048556, 20);
        this.addChar(225, 0xFFFFF3, 24);
        this.addChar(226, 1048557, 20);
        this.addChar(227, 2097126, 21);
        this.addChar(228, 4194281, 22);
        this.addChar(229, 2097127, 21);
        this.addChar(230, 2097128, 21);
        this.addChar(231, 0x7FFFF3, 23);
        this.addChar(232, 4194282, 22);
        this.addChar(233, 4194283, 22);
        this.addChar(234, 0x1FFFFEE, 25);
        this.addChar(235, 0x1FFFFEF, 25);
        this.addChar(236, 0xFFFFF4, 24);
        this.addChar(237, 0xFFFFF5, 24);
        this.addChar(238, 67108842, 26);
        this.addChar(239, 0x7FFFF4, 23);
        this.addChar(240, 67108843, 26);
        this.addChar(241, 134217702, 27);
        this.addChar(242, 67108844, 26);
        this.addChar(243, 67108845, 26);
        this.addChar(244, 0x7FFFFE7, 27);
        this.addChar(245, 134217704, 27);
        this.addChar(246, 134217705, 27);
        this.addChar(247, 134217706, 27);
        this.addChar(248, 134217707, 27);
        this.addChar(249, 0xFFFFFFE, 28);
        this.addChar(250, 134217708, 27);
        this.addChar(251, 134217709, 27);
        this.addChar(252, 0x7FFFFEE, 27);
        this.addChar(253, 0x7FFFFEF, 27);
        this.addChar(254, 0x7FFFFF0, 27);
        this.addChar(255, 0x3FFFFEE, 26);
        this.addEOS(256, this.EOS.code, this.EOS.length);
    }

    public int lengthOf(CharSequence value) {
        return this.lengthOf(value, 0, value.length());
    }

    public int lengthOf(CharSequence value, int start, int end) {
        int len = 0;
        for (int i = start; i < end; ++i) {
            char c = value.charAt(i);
            len += Huffman.INSTANCE.codeOf((char)c).length;
        }
        assert (len / 8 + (len % 8 != 0 ? 1 : 0) == (len + 7) / 8) : len;
        return (len + 7) / 8;
    }

    private void addChar(int c, int code, int bitLength) {
        this.addLeaf(c, code, bitLength, false);
        this.codes[c] = new Code(code, bitLength);
    }

    private void addEOS(int c, int code, int bitLength) {
        this.addLeaf(c, code, bitLength, true);
        this.codes[c] = new Code(code, bitLength);
    }

    private void addLeaf(int c, int code, int bitLength, boolean isEOS) {
        if (bitLength < 1) {
            throw new IllegalArgumentException("bitLength < 1");
        }
        Node curr = this.root;
        for (int p = 1 << bitLength - 1; p != 0 && !curr.isLeaf(); p >>= 1) {
            curr.isEOSPath |= isEOS;
            curr = curr.addChildIfAbsent(p & code);
        }
        curr.isEOSPath |= isEOS;
        if (curr.isLeaf()) {
            throw new IllegalStateException("Specified code is already taken");
        }
        curr.setChar((char)c);
    }

    private Code codeOf(char c) {
        if (c > '\u00ff') {
            throw new IllegalArgumentException("char=" + c);
        }
        return this.codes[c];
    }

    Node getRoot() {
        return this.root;
    }

    private static final class Code {
        final int code;
        final int length;

        private Code(int code, int length) {
            this.code = code;
            this.length = length;
        }

        public int getCode() {
            return this.code;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            long p = 1 << this.length;
            return Long.toBinaryString((long)this.code + p).substring(1) + ", length=" + this.length;
        }
    }

    static class Node {
        Node left;
        Node right;
        boolean isEOSPath;
        boolean charIsSet;
        char c;

        Node() {
        }

        Node getChild(int selector) {
            Node result;
            if (this.isLeaf()) {
                throw new IllegalStateException("This is a leaf node");
            }
            Node node = result = selector == 0 ? this.left : this.right;
            if (result == null) {
                throw new IllegalStateException(String.format("Node doesn't have a child (selector=%s)", selector));
            }
            return result;
        }

        boolean isLeaf() {
            return this.charIsSet;
        }

        char getChar() {
            if (!this.isLeaf()) {
                throw new IllegalStateException("This node is not a leaf node");
            }
            return this.c;
        }

        void setChar(char c) {
            if (this.charIsSet) {
                throw new IllegalStateException("This node has been taken already");
            }
            if (this.left != null || this.right != null) {
                throw new IllegalStateException("The node cannot be made a leaf as it's already has a child");
            }
            this.c = c;
            this.charIsSet = true;
        }

        Node addChildIfAbsent(int i) {
            Node child;
            if (this.charIsSet) {
                throw new IllegalStateException("The node cannot have a child as it's already a leaf node");
            }
            if (i == 0) {
                child = this.left;
                if (child == null) {
                    child = this.left = new Node();
                }
            } else {
                child = this.right;
                if (child == null) {
                    child = this.right = new Node();
                }
            }
            return child;
        }

        public String toString() {
            if (this.isLeaf()) {
                if (this.isEOSPath) {
                    return "EOS";
                }
                return String.format("char: (%3s) '%s'", this.c, Character.valueOf(this.c));
            }
            return "/\\";
        }
    }

    static final class Writer {
        private int pos;
        private int avail = 8;
        private int curr;
        private int rem;
        private int code;
        private CharSequence source;
        private int end;

        Writer() {
        }

        public Writer from(CharSequence input, int start, int end) {
            if (start < 0 || end < 0 || end > input.length() || start > end) {
                throw new IndexOutOfBoundsException(String.format("input.length()=%s, start=%s, end=%s", input.length(), start, end));
            }
            this.pos = start;
            this.end = end;
            this.source = input;
            return this;
        }

        public boolean write(Buffer destination) {
            while (this.pos < this.end) {
                if (this.rem == 0) {
                    Code desc = INSTANCE.codeOf(this.source.charAt(this.pos));
                    this.rem = desc.length;
                    this.code = desc.code;
                }
                while (this.rem > 0) {
                    if (this.rem < this.avail) {
                        this.curr |= this.code << this.avail - this.rem;
                        this.avail -= this.rem;
                        this.rem = 0;
                        continue;
                    }
                    int c = this.curr | this.code >>> this.rem - this.avail;
                    if (!destination.hasRemaining()) {
                        return false;
                    }
                    destination.put((byte)c);
                    this.curr = c;
                    this.code <<= 32 - this.rem + this.avail;
                    this.code >>>= 32 - this.rem + this.avail;
                    this.rem -= this.avail;
                    this.curr = 0;
                    this.avail = 8;
                }
                ++this.pos;
            }
            if (this.avail < 8) {
                if (destination.hasRemaining()) {
                    destination.put((byte)(this.curr | Huffman.INSTANCE.EOS.code >>> Huffman.INSTANCE.EOS.length - this.avail));
                    this.avail = 8;
                } else {
                    return false;
                }
            }
            return true;
        }

        public Writer reset() {
            this.source = null;
            this.end = -1;
            this.pos = -1;
            this.avail = 8;
            this.curr = 0;
            this.code = 0;
            return this;
        }
    }

    static final class Reader {
        private Node curr;
        private int len;
        private int p;

        Reader() {
            this.reset();
        }

        public void read(Buffer source, Appendable destination, boolean isLast) {
            this.read(source, destination, true, isLast);
        }

        void read(Buffer source, Appendable destination, boolean reportEOS, boolean isLast) {
            Node c = this.curr;
            int l = this.len;
            int pos = source.position();
            while (source.hasRemaining()) {
                byte d = source.get();
                while (this.p != 0) {
                    c = c.getChild(this.p & d);
                    ++l;
                    if (c.isLeaf()) {
                        if (reportEOS && c.isEOSPath) {
                            throw new IllegalArgumentException("Encountered EOS");
                        }
                        try {
                            destination.append(c.getChar());
                        }
                        catch (Error | RuntimeException e) {
                            source.position(pos);
                            throw e;
                        }
                        catch (IOException e) {
                            source.position(pos);
                            throw new RuntimeException(e);
                        }
                        c = Huffman.INSTANCE.root;
                        l = 0;
                    }
                    this.curr = c;
                    this.len = l;
                    this.p >>= 1;
                }
                this.resetProbe();
                ++pos;
            }
            if (!isLast) {
                return;
            }
            if (c.isLeaf()) {
                return;
            }
            if (c.isEOSPath && this.len <= 7) {
                return;
            }
            if (c.isEOSPath) {
                throw new IllegalArgumentException("Padding is too long (len=" + this.len + ") or unexpected end of data");
            }
            throw new IllegalArgumentException("Not a EOS prefix padding or unexpected end of data");
        }

        public void reset() {
            this.curr = Huffman.INSTANCE.root;
            this.len = 0;
            this.resetProbe();
        }

        private void resetProbe() {
            this.p = 128;
        }
    }
}

