/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.client.am.ClientBlob;

class BlobOutputStream
extends OutputStream {
    private ClientBlob blob_;
    private long offset_;

    BlobOutputStream(ClientBlob clientBlob, long l) {
        this.blob_ = clientBlob;
        this.offset_ = l;
        if (this.offset_ - 1L > (long)(this.blob_.binaryString_.length - this.blob_.dataOffset_)) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.writeX(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.writeX(byArray, n, n2);
    }

    private void writeX(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[(int)this.offset_ - 1 + n2 + this.blob_.dataOffset_];
        System.arraycopy(this.blob_.binaryString_, 0, byArray2, 0, (int)this.offset_ - 1 + this.blob_.dataOffset_);
        this.blob_.binaryString_ = byArray2;
        int n3 = 0;
        while (n3 < n2) {
            this.blob_.binaryString_[(int)this.offset_ + this.blob_.dataOffset_ - 1] = byArray[n + n3];
            ++n3;
            ++this.offset_;
        }
        this.blob_.binaryStream_ = new ByteArrayInputStream(this.blob_.binaryString_);
        this.blob_.setSqlLength(this.blob_.binaryString_.length - this.blob_.dataOffset_);
    }
}

