/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.logging.Logger;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.jdbc.util.JdbcResourcesUtil;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@ResourceDeployerInfo(value=JdbcResource.class)
@Singleton
public class JdbcResourceDeployer
implements ResourceDeployer {
    private static Logger _logger = LogDomains.getLogger(JdbcResourceDeployer.class, (String)"javax.enterprise.resource.resourceadapter");
    @Inject
    private ConnectorRuntime runtime;

    public synchronized void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        String jndiName = jdbcRes.getJndiName();
        String poolName = jdbcRes.getPoolName();
        PoolInfo poolInfo = new PoolInfo(poolName, applicationName, moduleName);
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
        this.runtime.createConnectorResource(resourceInfo, poolInfo, null);
        if (ConnectorsUtil.getValidSuffix((String)jndiName) == null) {
            ResourceInfo pmResourceInfo = new ResourceInfo(ConnectorsUtil.getPMJndiName((String)jndiName), resourceInfo.getApplicationName(), resourceInfo.getModuleName());
            this.runtime.createConnectorResource(pmResourceInfo, poolInfo, null);
        }
        _logger.finest(() -> "deployed resource " + jndiName);
    }

    public void deployResource(Object resource) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)jdbcRes);
        this.deployResource(jdbcRes, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(jdbcRes.getJndiName(), applicationName, moduleName);
        this.deleteResource(jdbcRes, resourceInfo);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        this.deleteResource(jdbcRes, ConnectorsUtil.getResourceInfo((BindableResource)jdbcRes));
    }

    private void deleteResource(JdbcResource jdbcResource, ResourceInfo resourceInfo) throws Exception {
        this.runtime.deleteConnectorResource(resourceInfo);
        ConnectorRegistry.getInstance().removeResourceFactories(resourceInfo);
        if (ConnectorsUtil.getValidSuffix((String)resourceInfo.getName()) == null) {
            String pmJndiName = ConnectorsUtil.getPMJndiName((String)resourceInfo.getName());
            ResourceInfo pmResourceInfo = new ResourceInfo(pmJndiName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
            this.runtime.deleteConnectorResource(pmResourceInfo);
            ConnectorRegistry.getInstance().removeResourceFactories(pmResourceInfo);
        }
        this.checkAndDeletePool(jdbcResource);
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof JdbcResource;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    private void checkAndDeletePool(JdbcResource jdbcResource) throws Exception {
        String poolName = jdbcResource.getPoolName();
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)jdbcResource);
        PoolInfo poolInfo = new PoolInfo(poolName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        Resources resources = (Resources)jdbcResource.getParent();
        if (resources != null) {
            try {
                boolean poolReferred = JdbcResourcesUtil.createInstance().isJdbcPoolReferredInServerInstance(poolInfo);
                if (!poolReferred) {
                    _logger.fine(() -> "Deleting JDBC pool [" + poolName + " ] as there are no more resource-refs to the pool in this server instance");
                    JdbcConnectionPool jcp = (JdbcConnectionPool)ConnectorsUtil.getResourceByName((Resources)resources, JdbcConnectionPool.class, (String)poolName);
                    this.runtime.getResourceDeployer(jcp).undeployResource((Object)jcp);
                }
            }
            catch (Exception ce) {
                _logger.warning(ce.getMessage());
                _logger.fine(() -> "Exception while deleting pool [ " + poolName + " ] : " + ce);
                throw ce;
            }
        }
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }
}

