/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.apache.felix.bundlerepository.DataModelHelper;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.jvnet.hk2.osgiadapter.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.util.tracker.ServiceTracker;

class ObrHandler
extends ServiceTracker {
    private boolean deployFragments = false;
    private boolean deployOptionalRequirements = false;
    private List<Repository> repositories = new ArrayList<Repository>();

    public ObrHandler(BundleContext bctx) {
        super(bctx, RepositoryAdmin.class.getName(), null);
        this.deployFragments = Boolean.valueOf(bctx.getProperty("com.sun.enterprise.hk2.obrDeploysFragments"));
        this.deployOptionalRequirements = Boolean.valueOf(bctx.getProperty("com.sun.enterprise.hk2.obrDeploysOptionalRequirements"));
        this.open();
    }

    public Object addingService(ServiceReference reference) {
        if (this.getTrackingCount() == 1) {
            Logger.logger.logp(Level.INFO, "ObrHandler", "addingService", "We already have a repository admin service, so ignoring {0}", new Object[]{reference});
            return null;
        }
        RepositoryAdmin repositoryAdmin = (RepositoryAdmin)this.context.getService(reference);
        this.repositories.add(repositoryAdmin.getSystemRepository());
        this.repositories.add(repositoryAdmin.getLocalRepository());
        return super.addingService(reference);
    }

    public void remove(ServiceReference reference) {
        super.remove(reference);
    }

    public RepositoryAdmin getRepositoryAdmin() {
        assert (this.getTrackingCount() < 2);
        try {
            return (RepositoryAdmin)this.waitForService(10000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public synchronized void addRepository(URI obrUri) throws Exception {
        if (this.isDirectory(obrUri)) {
            this.setupRepository(new File(obrUri), this.isSynchronous());
        } else {
            this.repositories.add(this.getRepositoryAdmin().getHelper().repository(obrUri.toURL()));
        }
    }

    private boolean isDirectory(URI obrUri) {
        try {
            return new File(obrUri).isDirectory();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void setupRepository(final File repoDir, boolean synchronous) throws Exception {
        if (synchronous) {
            this._setupRepository(repoDir);
        } else {
            Executors.newSingleThreadExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ObrHandler.this._setupRepository(repoDir);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private boolean isSynchronous() {
        String property = this.context.getProperty("com.sun.enterprise.hk2.initializeRepoSynchronously");
        return property == null || Boolean.TRUE.toString().equalsIgnoreCase(property);
    }

    private synchronized void _setupRepository(File repoDir) throws Exception {
        Repository repository;
        File repoFile = this.getRepositoryFile(repoDir);
        long tid = Thread.currentThread().getId();
        if (repoFile != null && repoFile.exists()) {
            long t = System.currentTimeMillis();
            repository = this.updateRepository(repoFile, repoDir);
            long t2 = System.currentTimeMillis();
            Logger.logger.logp(Level.INFO, "ObrHandler", "_setupRepository", "Thread #{0}: updateRepository took {1} ms", new Object[]{tid, t2 - t});
        } else {
            long t = System.currentTimeMillis();
            repository = this.createRepository(repoFile, repoDir);
            long t2 = System.currentTimeMillis();
            Logger.logger.logp(Level.INFO, "ObrHandler", "_setupRepository", "Thread #{0}: createRepository took {1} ms", new Object[]{tid, t2 - t});
        }
        this.repositories.add(repository);
    }

    private File getRepositoryFile(File repoDir) {
        String extn = ".xml";
        String cacheDir = this.context.getProperty("com.sun.enterprise.hk2.cacheDir");
        if (cacheDir == null) {
            return null;
        }
        return new File(cacheDir, "obr-" + repoDir.getName() + extn);
    }

    private Repository createRepository(File repoFile, File repoDir) throws IOException {
        DataModelHelper dmh = this.getRepositoryAdmin().getHelper();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (File jar : this.findAllJars(repoDir)) {
            Resource r = dmh.createResource(jar.toURI().toURL());
            if (r == null) {
                Logger.logger.logp(Level.WARNING, "ObrHandler", "createRepository", "{0} not an OSGi bundle", jar.toURI().toURL());
                continue;
            }
            resources.add(r);
        }
        Repository repository = dmh.repository(resources.toArray(new Resource[resources.size()]));
        Logger.logger.logp(Level.INFO, "ObrHandler", "createRepository", "Created {0} containing {1} resources.", new Object[]{repoFile, resources.size()});
        if (repoFile != null) {
            this.saveRepository(repoFile, repository);
        }
        return repository;
    }

    private void saveRepository(File repoFile, Repository repository) throws IOException {
        assert (repoFile != null);
        FileWriter writer = new FileWriter(repoFile);
        this.getRepositoryAdmin().getHelper().writeRepository(repository, (Writer)writer);
        writer.flush();
    }

    private Repository loadRepository(File repoFile) throws Exception {
        assert (repoFile != null);
        return this.getRepositoryAdmin().getHelper().repository(repoFile.toURI().toURL());
    }

    private Repository updateRepository(File repoFile, File repoDir) throws Exception {
        Repository repository = this.loadRepository(repoFile);
        if (this.isObsoleteRepo(repository, repoFile, repoDir)) {
            if (!repoFile.delete()) {
                throw new IOException("Failed to delete " + repoFile.getAbsolutePath());
            }
            Logger.logger.logp(Level.INFO, "ObrHandler", "updateRepository", "Recreating {0}", new Object[]{repoFile});
            repository = this.createRepository(repoFile, repoDir);
        }
        return repository;
    }

    private boolean isObsoleteRepo(Repository repository, File repoFile, File repoDir) {
        long lastModifiedTime = repoFile.lastModified();
        if (repoDir.lastModified() > lastModifiedTime) {
            return true;
        }
        long totalSize = 0L;
        for (File jar : this.findAllJars(repoDir)) {
            if (jar.lastModified() > lastModifiedTime) {
                Logger.logger.logp(Level.INFO, "ObrHandler", "isObsoleteRepo", "{0} is newer than {1}", new Object[]{jar, repoFile});
                return true;
            }
            totalSize += jar.length();
        }
        for (Resource r : repository.getResources()) {
            totalSize -= r.getSize().longValue();
        }
        if (totalSize != 0L) {
            Logger.logger.logp(Level.INFO, "ObrHandler", "isObsoleteRepo", "Change in size detected by {0} bytes", new Object[]{totalSize});
            return true;
        }
        return false;
    }

    private List<File> findAllJars(File repo) {
        final ArrayList<File> files = new ArrayList<File>();
        repo.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    pathname.listFiles(this);
                } else if (pathname.getName().endsWith("jar")) {
                    files.add(pathname);
                }
                return true;
            }
        });
        return files;
    }

    synchronized Bundle deploy(Resource resource) {
        Resolver resolver = this.getRepositoryAdmin().resolver(this.getRepositories());
        boolean resolved = this.resolve(resolver, resource);
        if (resolved) {
            int flags = !this.deployOptionalRequirements ? 1 : 0;
            resolver.deploy(flags);
            return this.getBundle(resource);
        }
        Object[] reqs = resolver.getUnsatisfiedRequirements();
        Logger.logger.logp(Level.WARNING, "ObrHandler", "deploy", "Unable to satisfy the requirements: {0}", new Object[]{Arrays.toString(reqs)});
        return null;
    }

    boolean resolve(Resolver resolver, Resource resource) {
        resolver.add(resource);
        boolean resolved = resolver.resolve();
        Logger.logger.logp(Level.INFO, "ObrHandler", "resolve", "At the end of first pass, resolver outcome is \n: {0}", new Object[]{this.getResolverOutput(resolver)});
        return resolved;
    }

    synchronized Bundle deploy(String name, String version) {
        Resource resource = this.findResource(name, version);
        if (resource == null) {
            Logger.logger.logp(Level.INFO, "ObrHandler", "deploy", "No resource matching name = {0} and version = {1} ", new Object[]{name, version});
            return null;
        }
        if (resource.isLocal()) {
            return this.getBundle(resource);
        }
        return this.deploy(resource);
    }

    private Bundle getBundle(Resource resource) {
        for (Bundle b : this.context.getBundles()) {
            boolean nameMatching;
            String bsn = b.getSymbolicName();
            Version bv = b.getVersion();
            String rsn = resource.getSymbolicName();
            Version rv = resource.getVersion();
            boolean versionMatching = rv == bv || rv != null && rv.equals((Object)bv);
            boolean bl = nameMatching = bsn == rsn || bsn != null && bsn.equals(rsn);
            if (!nameMatching || !versionMatching) continue;
            return b;
        }
        return null;
    }

    private Resource findResource(String name, String version) {
        RepositoryAdmin repositoryAdmin = this.getRepositoryAdmin();
        if (repositoryAdmin == null) {
            Logger.logger.logp(Level.WARNING, "ObrHandler", "findResource", "OBR is not yet available, so can't find resource with name = {0} and version = {1} from repository", new Object[]{name, version});
            return null;
        }
        String s1 = "(symbolicname=" + name + ")";
        String s2 = "(version=" + version + ")";
        String query = version != null ? "(&" + s1 + s2 + ")" : s1;
        try {
            Object[] resources = this.discoverResources(query);
            Logger.logger.logp(Level.INFO, "ObrHandler", "findResource", "Using the first one from the list of {0} discovered bundles shown below: {1}", new Object[]{resources.length, Arrays.toString(resources)});
            return resources.length > 0 ? resources[0] : null;
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Resource[] discoverResources(String filterExpr) throws InvalidSyntaxException {
        Filter filter = filterExpr != null ? this.getRepositoryAdmin().getHelper().filter(filterExpr) : null;
        Repository[] repos = this.getRepositories();
        ArrayList<Resource> matchList = new ArrayList<Resource>();
        for (int repoIdx = 0; repos != null && repoIdx < repos.length; ++repoIdx) {
            Resource[] resources = repos[repoIdx].getResources();
            for (int resIdx = 0; resources != null && resIdx < resources.length; ++resIdx) {
                Hashtable dict = new Hashtable();
                dict.putAll(resources[resIdx].getProperties());
                if (filter != null && !filter.match(dict)) continue;
                matchList.add(resources[resIdx]);
            }
        }
        return matchList.toArray(new Resource[matchList.size()]);
    }

    private void printResolverOutput(Resolver resolver) {
        StringBuffer sb = this.getResolverOutput(resolver);
        Logger.logger.logp(Level.INFO, "ObrHandler", "printResolverOutput", "OBR resolver state: {0}", new Object[]{sb});
    }

    private StringBuffer getResolverOutput(Resolver resolver) {
        Resource[] addedResources = resolver.getAddedResources();
        Resource[] requiredResources = resolver.getRequiredResources();
        Resource[] optionalResources = resolver.getOptionalResources();
        Reason[] unsatisfiedRequirements = resolver.getUnsatisfiedRequirements();
        StringBuffer sb = new StringBuffer("Added resources: [");
        for (Resource r : addedResources) {
            sb.append("\n").append(r.getSymbolicName()).append(", ").append(r.getVersion()).append(", ").append(r.getURI());
        }
        sb.append("]\nRequired Resources: [");
        for (Resource r : requiredResources) {
            sb.append("\n").append(r.getURI());
        }
        String optionalRequirementsDeployed = this.deployOptionalRequirements ? "deployed" : "not deployed";
        sb.append("]\nOptional resources (").append(optionalRequirementsDeployed).append("): [");
        for (Resource resource : optionalResources) {
            sb.append("\n").append(resource.getURI());
        }
        sb.append("]\nUnsatisfied requirements: [");
        for (Resource resource : unsatisfiedRequirements) {
            sb.append("\n").append(resource.getRequirement());
        }
        sb.append("]");
        return sb;
    }

    private Repository[] getRepositories() {
        return this.repositories.toArray(new Repository[this.repositories.size()]);
    }
}

