/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ActiveOutboundResourceAdapter;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.module.ConnectorApplication;
import com.sun.enterprise.connectors.util.RARUtils;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.logging.LogDomains;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterAssociation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.DelegatingClassLoader;

public class ConnectorConfigParserUtils {
    private static final Logger _logger = LogDomains.getLogger(ConnectorConfigParserUtils.class, (String)"javax.enterprise.resource.resourceadapter");

    public Properties mergeProps(Set ddVals, Properties introspectedVals) {
        Properties mergedVals = new Properties(introspectedVals);
        if (ddVals != null) {
            Object[] ddProps = ddVals.toArray();
            String name = null;
            String value = null;
            for (int i = 0; i < ddProps.length; ++i) {
                name = ((ConnectorConfigProperty)ddProps[i]).getName();
                value = ((ConnectorConfigProperty)ddProps[i]).getValue();
                mergedVals.setProperty(name, value);
            }
        }
        return mergedVals;
    }

    public Properties mergePropsReturnTypes(Set ddVals, Properties introspectedVals) {
        Properties mergedVals = new Properties(introspectedVals);
        if (ddVals != null) {
            Object[] ddProps = ddVals.toArray();
            String name = null;
            String value = null;
            for (int i = 0; i < ddProps.length; ++i) {
                name = ((ConnectorConfigProperty)ddProps[i]).getName();
                value = ((ConnectorConfigProperty)ddProps[i]).getType();
                mergedVals.setProperty(name, value);
            }
        }
        return mergedVals;
    }

    public Properties introspectJavaBean(String className, Set ddPropsSet) throws ConnectorRuntimeException {
        return this.introspectJavaBean(className, ddPropsSet, false, null);
    }

    public Properties introspectJavaBean(String className, Set ddPropsSet, boolean associateResourceAdapter, String resourceAdapterName) throws ConnectorRuntimeException {
        Object loadedInstance;
        block6: {
            Class loadedClass = this.loadClass(className, resourceAdapterName);
            loadedInstance = this.instantiate(loadedClass);
            try {
                if (associateResourceAdapter) {
                    ActiveResourceAdapter activeRA = ConnectorRegistry.getInstance().getActiveResourceAdapter(resourceAdapterName);
                    if (activeRA == null) {
                        ConnectorRuntime.getRuntime().loadDeferredResourceAdapter(resourceAdapterName);
                        activeRA = ConnectorRegistry.getInstance().getActiveResourceAdapter(resourceAdapterName);
                    }
                    if (activeRA instanceof ActiveOutboundResourceAdapter) {
                        ResourceAdapter raInstance = activeRA.getResourceAdapter();
                        if (loadedInstance instanceof ResourceAdapterAssociation) {
                            ((ResourceAdapterAssociation)loadedInstance).setResourceAdapter(raInstance);
                        }
                    }
                }
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "rardeployment.error_associating_ra", e);
                if (!_logger.isLoggable(Level.FINE)) break block6;
                _logger.log(Level.FINE, "Exception while associating the resource adapter to the JavaBean", e);
            }
        }
        return this.introspectJavaBean(loadedInstance, ddPropsSet);
    }

    public Properties introspectJavaBean(Object javaBeanInstance, Set ddPropsSet) throws ConnectorRuntimeException {
        Class<?> loadedClass = javaBeanInstance.getClass();
        Method[] methods = loadedClass.getMethods();
        Properties props = new Properties();
        String name = null;
        String value = null;
        Object[] ddProps = null;
        if (ddPropsSet != null) {
            ddProps = ddPropsSet.toArray();
        }
        for (int i = 0; i < methods.length; ++i) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Method -> " + methods[i].getName() + ":" + methods[i].getReturnType());
            }
            if (!this.isProperty(methods[i]) || this.presentInDDProps(methods[i], ddProps) || !this.isValid(methods[i], loadedClass)) continue;
            name = this.getPropName(methods[i]);
            value = this.getPropValue(methods[i], loadedClass, javaBeanInstance);
            props.setProperty(name, value);
        }
        return props;
    }

    public Properties introspectJavaBeanReturnTypes(String className, Set ddPropsSet, String rarName) throws ConnectorRuntimeException {
        Class loadedClass = this.loadClass(className, rarName);
        Method[] methods = loadedClass.getMethods();
        Properties props = new Properties();
        String name = null;
        String value = null;
        Object[] ddProps = null;
        if (ddPropsSet != null) {
            ddProps = ddPropsSet.toArray();
        }
        for (int i = 0; i < methods.length; ++i) {
            if (!this.isProperty(methods[i]) || this.presentInDDProps(methods[i], ddProps)) continue;
            name = this.getPropName(methods[i]);
            value = this.getPropType(methods[i]);
            if (value == null) continue;
            props.setProperty(name, value);
        }
        return props;
    }

    private boolean presentInDDProps(Method method, Object[] ddProps) {
        String name = null;
        String ddPropName = null;
        int length = "set".length();
        if (method != null) {
            name = method.getName().substring(length);
        }
        for (int i = 0; name != null && ddProps != null && i < ddProps.length; ++i) {
            ddPropName = ((ConnectorConfigProperty)ddProps[i]).getName();
            if (!name.equalsIgnoreCase(ddPropName)) continue;
            return true;
        }
        return false;
    }

    private boolean isValid(Method setMethod, Class loadedClass) {
        Method getMethod = this.correspondingGetMethod(setMethod, loadedClass);
        if (getMethod != null) {
            return RARUtils.isValidRABeanConfigProperty(getMethod.getReturnType());
        }
        return false;
    }

    private boolean isProperty(Method method) {
        if (method == null) {
            return false;
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        return methodName.startsWith("set") && parameterTypes.length == 1;
    }

    private String getPropName(Method method) {
        if (method == null) {
            return null;
        }
        String methodName = method.getName();
        int length = "set".length();
        String retValue = methodName.substring(length, length + 1).toUpperCase(Locale.getDefault()) + methodName.substring(length + 1);
        return retValue;
    }

    private Method correspondingGetMethod(Method setMethod, Class loadedClass) {
        Method[] allMethods = loadedClass.getMethods();
        int length = "set".length();
        String methodName = setMethod.getName();
        Class<?>[] parameterTypes = null;
        String[] possibleGetMethodNames = new String[]{"is" + methodName.substring(length), "get" + methodName.substring(length)};
        for (int i = 0; i < allMethods.length; ++i) {
            if (!allMethods[i].getName().equals(possibleGetMethodNames[0]) && !allMethods[i].getName().equals(possibleGetMethodNames[1]) || (parameterTypes = allMethods[i].getParameterTypes()).length != 0) continue;
            return allMethods[i];
        }
        return null;
    }

    private String getPropValue(Method method, Class loadedClass, Object loadedInstance) {
        Object retValue;
        block5: {
            retValue = null;
            Method getMethod = this.correspondingGetMethod(method, loadedClass);
            if (getMethod != null) {
                try {
                    retValue = getMethod.invoke(loadedInstance, (Object[])null);
                }
                catch (IllegalAccessException ie) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "rardeployment.illegalaccess_error", loadedClass.getName());
                    }
                }
                catch (InvocationTargetException ie) {
                    if (!_logger.isLoggable(Level.FINE)) break block5;
                    _logger.log(Level.FINE, "Failed to invoke the method", loadedClass.getName());
                }
            }
        }
        return this.convertToString(retValue);
    }

    private String getPropType(Method method) {
        Class<?>[] parameterTypeClass = method.getParameterTypes();
        if (parameterTypeClass.length != 1) {
            return null;
        }
        if (parameterTypeClass[0].isPrimitive() || parameterTypeClass[0].getName().equals("java.lang.String")) {
            return parameterTypeClass[0].getName();
        }
        return null;
    }

    private String convertToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Integer || obj instanceof Float || obj instanceof Long || obj instanceof Double || obj instanceof Character || obj instanceof Boolean || obj instanceof Byte || obj instanceof Short) {
            return String.valueOf(obj);
        }
        return "";
    }

    private Class loadClass(String className, String resourceAdapterName) throws ConnectorRuntimeException {
        Class loadedClass = null;
        try {
            if (ConnectorsUtil.belongsToSystemRA((String)resourceAdapterName)) {
                DelegatingClassLoader classLoader = ConnectorRuntime.getRuntime().getConnectorClassLoader();
                loadedClass = classLoader.loadClass(className);
            } else {
                ConnectorApplication app = ConnectorRegistry.getInstance().getConnectorApplication(resourceAdapterName);
                if (app == null) {
                    _logger.log(Level.FINE, "unable to load class [ " + className + " ] of RAR [ " + resourceAdapterName + " ] from server instance, trying other instances' deployments");
                    loadedClass = RARUtils.loadClassFromRar(resourceAdapterName, className);
                } else {
                    loadedClass = app.getClassLoader().loadClass(className);
                }
            }
        }
        catch (ClassNotFoundException e1) {
            _logger.log(Level.FINE, "rardeployment.class_not_found", className);
            throw new ConnectorRuntimeException("Class Not Found : " + className);
        }
        return loadedClass;
    }

    private Object instantiate(Class loadedClass) throws ConnectorRuntimeException {
        try {
            return loadedClass.newInstance();
        }
        catch (InstantiationException ie) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "rardeployment.class_instantiation_error", loadedClass.getName());
            }
            throw new ConnectorRuntimeException("Could not instantiate class : " + loadedClass.getName());
        }
        catch (IllegalAccessException ie) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "rardeployment.illegalaccess_error", loadedClass.getName());
            }
            throw new ConnectorRuntimeException("Couldnot access class : " + loadedClass.getName());
        }
    }
}

