/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.ArrayList;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.Http2Session;
import org.glassfish.grizzly.http2.Http2SessionException;
import org.glassfish.grizzly.http2.NetLogger;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

public class Http2FrameCodec {
    public List<Http2Frame> parse(Http2Session http2Session, FrameParsingState parsingState, Buffer srcMessage) throws Http2SessionException {
        if (parsingState.bytesToSkip() > 0 && !this.skip(parsingState, srcMessage)) {
            return null;
        }
        srcMessage = parsingState.appendToRemainder(http2Session.getMemoryManager(), srcMessage);
        ParsingResult parsingResult = this.parseFrame(http2Session, parsingState, srcMessage);
        if (!parsingResult.isReady()) {
            return null;
        }
        Buffer remainder = parsingResult.remainder();
        while (remainder.remaining() >= 9) {
            parsingResult = this.parseFrame(http2Session, parsingState, remainder);
            if (!parsingResult.isReady()) {
                return parsingResult.frameList();
            }
            remainder = parsingResult.remainder();
        }
        return parsingResult.frameList();
    }

    public Buffer serializeAndRecycle(Http2Session http2Session, Http2Frame frame) {
        NetLogger.log(NetLogger.Context.TX, http2Session, frame);
        Buffer resultBuffer = frame.toBuffer(http2Session.getMemoryManager());
        frame.recycle();
        return resultBuffer;
    }

    public Buffer serializeAndRecycle(Http2Session http2Session, List<Http2Frame> frames) {
        Buffer resultBuffer = null;
        int framesCount = frames.size();
        for (int i = 0; i < framesCount; ++i) {
            Http2Frame frame = frames.get(i);
            NetLogger.log(NetLogger.Context.TX, http2Session, frame);
            Buffer buffer = frame.toBuffer(http2Session.getMemoryManager());
            frame.recycle();
            resultBuffer = Buffers.appendBuffers(http2Session.getMemoryManager(), resultBuffer, buffer);
        }
        frames.clear();
        return resultBuffer;
    }

    private ParsingResult parseFrame(Http2Session http2Session, FrameParsingState state, Buffer buffer) throws Http2SessionException {
        int bufferSize = buffer.remaining();
        ParsingResult parsingResult = state.parsingResult();
        if (bufferSize < 9) {
            return parsingResult.setNeedMore(buffer);
        }
        int len = http2Session.getFrameSize(buffer);
        if (len > http2Session.getPeerMaxFramePayloadSize() + 9) {
            Buffer remainder;
            http2Session.onOversizedFrame(buffer);
            buffer.position(buffer.position() + 9);
            int remaining = buffer.remaining();
            if (remaining > len) {
                int bufferPos = buffer.position();
                remainder = buffer.split(bufferPos + len);
            } else {
                remainder = Buffers.EMPTY_BUFFER;
                state.bytesToSkip(len - remaining);
            }
            return parsingResult.setParsed(null, remainder);
        }
        if (buffer.remaining() < len) {
            return parsingResult.setNeedMore(buffer);
        }
        Buffer remainder = buffer.split(buffer.position() + len);
        Http2Frame frame = http2Session.parseHttp2FrameHeader(buffer);
        return parsingResult.setParsed(frame, remainder);
    }

    private boolean skip(FrameParsingState parsingState, Buffer message) {
        int bytesToSkip = parsingState.bytesToSkip();
        int dec = Math.min(bytesToSkip, message.remaining());
        parsingState.bytesToSkip(bytesToSkip - dec);
        message.position(message.position() + dec);
        if (message.hasRemaining()) {
            message.shrink();
            return true;
        }
        message.tryDispose();
        return false;
    }

    static final class ParsingResult {
        private Buffer remainder;
        private boolean isReady;
        private final List<Http2Frame> frameList = new ArrayList<Http2Frame>(4);

        private ParsingResult() {
        }

        ParsingResult setParsed(Http2Frame frame, Buffer remainder) {
            if (frame != null) {
                this.frameList.add(frame);
            }
            this.remainder = remainder;
            this.isReady = true;
            return this;
        }

        ParsingResult setNeedMore(Buffer remainder) {
            this.remainder = remainder;
            this.isReady = false;
            return this;
        }

        List<Http2Frame> frameList() {
            return this.frameList;
        }

        Buffer remainder() {
            return this.remainder;
        }

        boolean isReady() {
            return this.isReady;
        }
    }

    public static final class FrameParsingState {
        private int bytesToSkip;
        private final ParsingResult parsingResult = new ParsingResult();

        List<Http2Frame> getList() {
            return this.parsingResult.frameList;
        }

        Buffer appendToRemainder(MemoryManager mm, Buffer buffer) {
            Buffer remainderBuffer = this.parsingResult.remainder;
            this.parsingResult.remainder = null;
            return Buffers.appendBuffers(mm, remainderBuffer, buffer, true);
        }

        int bytesToSkip() {
            return this.bytesToSkip;
        }

        void bytesToSkip(int bytesToSkip) {
            this.bytesToSkip = bytesToSkip;
        }

        ParsingResult parsingResult() {
            return this.parsingResult;
        }
    }
}

