/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.appserv.ProxyHandler;
import java.io.CharConversionException;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Constants;
import org.apache.catalina.connector.CoyotePrincipal;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.util.ServerInfo;
import org.glassfish.common.util.InputValidationUtil;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Note;
import org.glassfish.grizzly.http.server.AfterServiceListener;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.MessageBytes;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.web.valve.GlassFishValve;
import org.glassfish.web.valve.ServletContainerInterceptor;

public class CoyoteAdapter
extends HttpHandler {
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private static final String POWERED_BY = "Servlet/3.1 JSP/2.3 (" + ServerInfo.getServerInfo() + " Java/" + System.getProperty("java.vm.vendor") + "/" + System.getProperty("java.specification.version") + ")";
    static final String JVM_ROUTE = System.getProperty("jvmRoute");
    private Collection<ServletContainerInterceptor> interceptors = null;
    protected static final boolean ALLOW_BACKSLASH = Boolean.valueOf(System.getProperty("org.glassfish.grizzly.tcp.tomcat5.CoyoteAdapter.ALLOW_BACKSLASH", "false"));
    private static final boolean COLLAPSE_ADJACENT_SLASHES = Boolean.valueOf(System.getProperty("com.sun.enterprise.web.collapseAdjacentSlashes", "true"));
    private boolean compatWithTomcat = false;
    private String serverName = ServerInfo.getPublicServerInfo();
    protected static final Note<MappingData> MAPPING_DATA = org.glassfish.grizzly.http.server.Request.createNote((String)"MappingData");
    static final Note<Request> CATALINA_REQUEST_NOTE = org.glassfish.grizzly.http.server.Request.createNote((String)Request.class.getName());
    static final Note<Response> CATALINA_RESPONSE_NOTE = org.glassfish.grizzly.http.server.Request.createNote((String)Response.class.getName());
    static final CatalinaAfterServiceListener catalinaAfterServiceListener = new CatalinaAfterServiceListener();
    private static final Note<DataChunk> DATA_CHUNK = org.glassfish.grizzly.http.server.Request.createNote((String)"DataChunk");
    private Connector connector = null;

    public CoyoteAdapter(Connector connector) {
        this.connector = connector;
        this.initServletInterceptors();
    }

    public void service(org.glassfish.grizzly.http.server.Request req, org.glassfish.grizzly.http.server.Response res) throws Exception {
        boolean v3Enabled;
        res.getResponse().setAllowCustomReasonPhrase(Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER);
        Request request = (Request)req.getNote(CATALINA_REQUEST_NOTE);
        Response response = (Response)req.getNote(CATALINA_RESPONSE_NOTE);
        MappingData md = (MappingData)req.getNote(MAPPING_DATA);
        boolean bl = v3Enabled = md != null;
        if (request == null) {
            request = (Request)this.connector.createRequest();
            response = (Response)this.connector.createResponse();
            request.setResponse(response);
            response.setRequest(request);
            req.setNote(CATALINA_REQUEST_NOTE, (Object)request);
            req.setNote(CATALINA_RESPONSE_NOTE, (Object)response);
            req.getRequest().getRequestURIRef().setDefaultURIEncoding(Charset.forName(this.connector.getURIEncoding()));
        }
        request.setCoyoteRequest(req);
        response.setCoyoteResponse(res);
        if (v3Enabled && !this.compatWithTomcat) {
            request.setMappingData(md);
            request.updatePaths(md);
        }
        req.addAfterServiceListener((AfterServiceListener)catalinaAfterServiceListener);
        try {
            this.doService(req, request, res, response, v3Enabled);
            request.onExitService();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00037", t);
        }
    }

    private void enteringServletContainer(Request req, Response res) {
        if (this.interceptors == null) {
            return;
        }
        for (ServletContainerInterceptor interceptor : this.interceptors) {
            try {
                interceptor.preInvoke(req, res);
            }
            catch (Throwable th) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00493", th);
            }
        }
    }

    private void leavingServletContainer(Request req, Response res) {
        if (this.interceptors == null) {
            return;
        }
        for (ServletContainerInterceptor interceptor : this.interceptors) {
            try {
                interceptor.postInvoke(req, res);
            }
            catch (Throwable th) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00493", th);
            }
        }
    }

    private void initServletInterceptors() {
        try {
            ServiceLocator services = Globals.getDefaultHabitat();
            this.interceptors = services.getAllServices(ServletContainerInterceptor.class, new Annotation[0]);
        }
        catch (Throwable th) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00494", th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doService(org.glassfish.grizzly.http.server.Request req, Request request, org.glassfish.grizzly.http.server.Response res, Response response, boolean v3Enabled) throws Exception {
        if (!this.connector.isEnabled()) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00038"), String.valueOf(this.connector.getPort()));
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, msg);
            }
            response.sendError(404, msg);
            return;
        }
        if (this.postParseRequest(req, request, res, response, v3Enabled)) {
            boolean authPassthroughEnabled = this.connector.getAuthPassthroughEnabled();
            ProxyHandler proxyHandler = this.connector.getProxyHandler();
            if (authPassthroughEnabled && proxyHandler != null) {
                if (proxyHandler.getSSLKeysize(request.getRequest()) > 0) {
                    request.setSecure(true);
                }
                X509Certificate[] certs = null;
                try {
                    certs = proxyHandler.getSSLClientCertificateChain(request.getRequest());
                }
                catch (CertificateException ce) {
                    log.log(Level.SEVERE, "AS-WEB-CORE-00039", ce);
                }
                if (certs != null) {
                    request.setAttribute("jakarta.servlet.request.X509Certificate", certs);
                }
            }
            this.connector.requestStartEvent(request.getRequest(), request.getHost(), request.getContext());
            Container container = this.connector.getContainer();
            this.enteringServletContainer(request, response);
            try {
                request.lockSession();
                if (container.getPipeline().hasNonBasicValves() || container.hasCustomPipeline()) {
                    container.getPipeline().invoke(request, response);
                } else {
                    Host host = request.getHost();
                    if (host == null) {
                        response.sendError(400);
                        String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00040"), request.getRequest().getServerName());
                        response.setDetailMessage(msg);
                        return;
                    }
                    if (host.getPipeline().hasNonBasicValves() || host.hasCustomPipeline()) {
                        host.getPipeline().invoke(request, response);
                    } else {
                        GlassFishValve hostValve = host.getPipeline().getBasic();
                        hostValve.invoke(request, response);
                        hostValve.postInvoke(request, response);
                    }
                }
            }
            finally {
                try {
                    this.connector.requestEndEvent(request.getRequest(), request.getHost(), request.getContext(), response.getStatus());
                }
                finally {
                    this.leavingServletContainer(request, response);
                }
            }
        }
    }

    protected boolean postParseRequest(org.glassfish.grizzly.http.server.Request req, Request request, org.glassfish.grizzly.http.server.Response res, Response response, boolean v3Enabled) throws Exception {
        Context ctx;
        DataChunk decodedURI;
        request.setSecure(req.isSecure());
        try {
            decodedURI = req.getRequest().getRequestURIRef().getDecodedRequestURIBC();
        }
        catch (CharConversionException cce) {
            response.sendError(400, "Invalid URI");
            return false;
        }
        if (this.compatWithTomcat || !v3Enabled) {
            String authtype;
            String principal = req.getRemoteUser();
            if (principal != null) {
                request.setUserPrincipal(new CoyotePrincipal(principal));
            }
            if ((authtype = req.getAuthType()) != null) {
                request.setAuthType(authtype);
            }
        }
        CharChunk uriParamsCC = request.getURIParams();
        CharChunk uriCC = decodedURI.getCharChunk();
        int semicolon = uriCC.indexOf(';');
        if (semicolon > 0) {
            int absSemicolon = uriCC.getStart() + semicolon;
            uriParamsCC.setChars(uriCC.getBuffer(), absSemicolon, uriCC.getEnd() - absSemicolon);
            decodedURI.setChars(uriCC.getBuffer(), uriCC.getStart(), absSemicolon - uriCC.getStart());
        }
        if (this.compatWithTomcat || !v3Enabled) {
            DataChunk localDecodedURI = decodedURI;
            if (semicolon > 0) {
                localDecodedURI = (DataChunk)req.getNote(DATA_CHUNK);
                if (localDecodedURI == null) {
                    localDecodedURI = DataChunk.newInstance();
                    req.setNote(DATA_CHUNK, (Object)localDecodedURI);
                }
                localDecodedURI.duplicate(decodedURI);
            }
            this.connector.getMapper().map(req.getRequest().serverName(), localDecodedURI, request.getMappingData());
            MappingData md = request.getMappingData();
            req.setNote(MAPPING_DATA, (Object)md);
            request.updatePaths(md);
        }
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            req.setServerPort(proxyPort);
        }
        if (proxyName != null) {
            req.setServerName(proxyName);
        }
        if ((ctx = (Context)request.getMappingData().context) != null) {
            if (req.isRequestedSessionIdFromURL() && "jsessionid".equals(ctx.getSessionParameterName())) {
                request.obtainSessionId();
            } else if (!uriParamsCC.isNull()) {
                request.parseSessionId(ctx.getSessionParameterName(), uriParamsCC);
            }
        }
        request.setDefaultContext(request.getMappingData().isDefaultContext);
        request.setContext(ctx);
        if (ctx != null && !uriParamsCC.isNull()) {
            request.parseSessionVersion(uriParamsCC);
        }
        if (!uriParamsCC.isNull()) {
            request.parseJReplica(uriParamsCC);
        }
        request.setWrapper((Wrapper)request.getMappingData().wrapper);
        if (!this.connector.getAllowTrace() && Method.TRACE.equals(req.getMethod())) {
            String[] methods;
            Wrapper wrapper = request.getWrapper();
            Object header = null;
            if (wrapper != null && (methods = wrapper.getServletMethods()) != null) {
                for (String method : methods) {
                    if ("TRACE".equals(method)) continue;
                    header = header == null ? method : (String)header + ", " + method;
                }
            }
            res.setStatus(405, "TRACE method is not allowed");
            res.addHeader("Allow", header);
            return false;
        }
        DataChunk redirectPathMB = request.getMappingData().redirectPath;
        if (!(redirectPathMB.isNull() || ctx.hasAdHocPaths() && ctx.getAdHocServletName(request.getRequest().getServletPath()) != null)) {
            Object redirectPath = redirectPathMB.toString();
            String query = request.getQueryString();
            if (request.isRequestedSessionIdFromURL()) {
                redirectPath = (String)redirectPath + ";" + ctx.getSessionParameterName() + "=" + request.getRequestedSessionId();
            }
            redirectPath = response.encode((String)redirectPath);
            if (query != null) {
                redirectPath = (String)redirectPath + "?" + query;
            }
            boolean authPassthroughEnabled = this.connector.getAuthPassthroughEnabled();
            ProxyHandler proxyHandler = this.connector.getProxyHandler();
            if (authPassthroughEnabled && proxyHandler != null && proxyHandler.getSSLKeysize(request.getRequest()) > 0) {
                request.setSecure(true);
            }
            if (InputValidationUtil.validateStringforCRLF((String)redirectPath)) {
                response.sendError(403, "Forbidden");
            } else {
                response.sendRedirect(InputValidationUtil.removeLinearWhiteSpaces((String)redirectPath), false);
            }
            return false;
        }
        request.parseSessionCookiesId();
        request.parseJrouteCookie();
        return true;
    }

    public static boolean normalize(MessageBytes uriMB) {
        int type = uriMB.getType();
        if (type == 3) {
            return CoyoteAdapter.normalizeChars(uriMB);
        }
        return CoyoteAdapter.normalizeBytes(uriMB);
    }

    private static boolean normalizeBytes(MessageBytes uriMB) {
        int end;
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        if (start == (end = uriBC.getEnd())) {
            return false;
        }
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                if (ALLOW_BACKSLASH) {
                    b[pos] = 47;
                } else {
                    return false;
                }
            }
            if (b[pos] != 0) continue;
            return false;
        }
        if (b[start] != 47) {
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (b[pos] != 47) continue;
                while (pos + 1 < end && b[pos + 1] == 47) {
                    CoyoteAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                    --end;
                }
            }
        }
        if (end - start > 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            CoyoteAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    private static boolean normalizeChars(MessageBytes uriMB) {
        CharChunk uriCC = uriMB.getCharChunk();
        char[] c = uriCC.getChars();
        int start = uriCC.getStart();
        int end = uriCC.getEnd();
        if (end - start == 1 && c[start] == '*') {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (c[pos] == '\\') {
                if (ALLOW_BACKSLASH) {
                    c[pos] = 47;
                } else {
                    return false;
                }
            }
            if (c[pos] != '\u0000') continue;
            return false;
        }
        if (c[start] != '/') {
            return false;
        }
        if (COLLAPSE_ADJACENT_SLASHES) {
            for (pos = start; pos < end - 1; ++pos) {
                if (c[pos] != '/') continue;
                while (pos + 1 < end && c[pos + 1] == '/') {
                    CoyoteAdapter.copyChars(c, pos, pos + 1, end - pos - 1);
                    --end;
                }
            }
        }
        if (end - start > 2 && c[end - 1] == '.' && (c[end - 2] == '/' || c[end - 2] == '.' && c[end - 3] == '/')) {
            c[end] = 47;
            ++end;
        }
        uriCC.setEnd(end);
        index = 0;
        while ((index = uriCC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyChars(c, start + index, start + index + 2, end - start - index - 2);
            uriCC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriCC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (c[pos] != '/') continue;
                index2 = pos;
            }
            CoyoteAdapter.copyChars(c, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriCC.setEnd(end);
            index = index2;
        }
        uriCC.setChars(c, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            b[pos + dest] = b[pos + src];
        }
    }

    private static void copyChars(char[] c, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            c[pos + dest] = c[pos + src];
        }
    }

    protected void log(String message) {
        log.log(Level.INFO, message);
    }

    protected void log(String message, Throwable throwable) {
        log.log(Level.SEVERE, message, throwable);
    }

    public void fireAdapterEvent(String type, Object data) {
        if (this.connector != null && this.connector.getContainer() != null) {
            try {
                ((ContainerBase)this.connector.getContainer()).fireContainerEvent(type, data);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00037", t);
            }
        }
    }

    public boolean isCompatWithTomcat() {
        return this.compatWithTomcat;
    }

    public void setCompatWithTomcat(boolean compatWithTomcat) {
        this.compatWithTomcat = compatWithTomcat;
        this.serverName = compatWithTomcat ? "Apache/" + this.serverName : ServerInfo.getPublicServerInfo();
    }

    public int getPort() {
        return this.connector.getPort();
    }

    static final class CatalinaAfterServiceListener
    implements AfterServiceListener {
        CatalinaAfterServiceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAfterService(org.glassfish.grizzly.http.server.Request request) {
            Request servletRequest = (Request)request.getNote(CATALINA_REQUEST_NOTE);
            Response servletResponse = (Response)request.getNote(CATALINA_RESPONSE_NOTE);
            if (servletRequest != null) {
                try {
                    if (!servletRequest.isUpgrade()) {
                        servletResponse.finishResponse();
                    } else {
                        servletResponse.setUpgrade(servletRequest.isUpgrade());
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "AS-WEB-CORE-00037", e);
                }
                finally {
                    try {
                        servletRequest.unlockSession();
                    }
                    finally {
                        servletRequest.recycle();
                        servletResponse.recycle();
                    }
                }
            }
        }
    }
}

