/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts.iiop;

import com.sun.jts.pi.InterceptorImpl;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.hk2.api.ServiceLocator;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CosTransactions.OTSPolicy;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;

public class TxIORInterceptor
extends LocalObject
implements IORInterceptor {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = LogDomains.getLogger(InterceptorImpl.class, (String)"javax.enterprise.system.core.transaction");
    private Codec codec;
    private ServiceLocator serviceLocator;

    public TxIORInterceptor(Codec codec, ServiceLocator serviceLocator) {
        this.codec = codec;
        this.serviceLocator = serviceLocator;
    }

    public String name() {
        return "TxIORInterceptor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establish_components(IORInfo iorInfo) {
        try {
            _logger.log(Level.FINE, "TxIORInterceptor.establish_components->:");
            OTSPolicy otsPolicy = null;
            try {
                otsPolicy = (OTSPolicy)iorInfo.get_effective_policy(((GlassFishORBHelper)this.serviceLocator.getService(GlassFishORBHelper.class, new Annotation[0])).getOTSPolicyType());
            }
            catch (INV_POLICY ex) {
                _logger.log(Level.FINE, "TxIORInterceptor.establish_components: OTSPolicy not present");
            }
            this.addOTSComponents(iorInfo, otsPolicy);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception in establish_components", e);
        }
        finally {
            _logger.log(Level.FINE, "TxIORInterceptor.establish_components<-:");
        }
    }

    public void destroy() {
    }

    private void addOTSComponents(IORInfo iorInfo, OTSPolicy otsPolicy) {
        short invPolicyValue = 1;
        short otsPolicyValue = 3;
        if (otsPolicy != null) {
            otsPolicyValue = otsPolicy.value();
        }
        Any otsAny = ORB.init().create_any();
        Any invAny = ORB.init().create_any();
        otsAny.insert_short(otsPolicyValue);
        invAny.insert_short(invPolicyValue);
        byte[] otsCompValue = null;
        byte[] invCompValue = null;
        try {
            otsCompValue = this.codec.encode_value(otsAny);
            invCompValue = this.codec.encode_value(invAny);
        }
        catch (InvalidTypeForEncoding e) {
            throw new INTERNAL("InvalidTypeForEncoding " + e.getMessage());
        }
        TaggedComponent otsComp = new TaggedComponent(31, otsCompValue);
        iorInfo.add_ior_component(otsComp);
        TaggedComponent invComp = new TaggedComponent(32, invCompValue);
        iorInfo.add_ior_component(invComp);
    }
}

