/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Query;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryDelegate;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaEntityManagerFactory;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.factories.SessionFactory;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;

public class JpaHelper {
    public static boolean isEclipseLink(EntityManager em) {
        return JpaHelper.getEntityManager(em) != null;
    }

    public static boolean isEclipseLink(EntityManagerFactory emf) {
        try {
            JpaHelper.getEntityManagerFactory(emf);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return true;
    }

    public static boolean isEclipseLink(Query query) {
        return query instanceof JpaQuery;
    }

    public static boolean isReportQuery(Query query) {
        return JpaHelper.isEclipseLink(query) && JpaHelper.getDatabaseQuery(query).isReportQuery();
    }

    public static ReportQuery getReportQuery(Query query) {
        DatabaseQuery dbQuery = JpaHelper.getDatabaseQuery(query);
        if (dbQuery.isReportQuery()) {
            return (ReportQuery)dbQuery;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)("jpa_helper_invalid_report_query" + query.getClass())));
    }

    public static DatabaseQuery getDatabaseQuery(Query query) {
        if (query instanceof JpaQuery) {
            return ((JpaQuery)query).getDatabaseQuery();
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)("jpa_helper_invalid_query" + query.getClass())));
    }

    public static ReadAllQuery getReadAllQuery(Query query) {
        DatabaseQuery dbQuery = JpaHelper.getDatabaseQuery(query);
        if (dbQuery.isReadAllQuery()) {
            return (ReadAllQuery)dbQuery;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)("jpa_helper_invalid_read_all_query" + query.getClass())));
    }

    public static Query createQuery(DatabaseQuery query, EntityManager em) {
        return JpaHelper.getEntityManager(em).createQuery(query);
    }

    public static JpaEntityManager getEntityManager(EntityManager entityManager) {
        if (entityManager instanceof JpaEntityManager) {
            return (JpaEntityManager)entityManager;
        }
        if (entityManager.getDelegate() != null) {
            return JpaHelper.getEntityManager((EntityManager)entityManager.getDelegate());
        }
        return null;
    }

    @Deprecated
    public static EntityManagerFactoryImpl getEntityManagerFactory(EntityManagerFactoryImpl emf) {
        return emf;
    }

    public static JpaEntityManagerFactory getEntityManagerFactory(EntityManagerFactory emf) {
        if (emf instanceof JpaEntityManagerFactory) {
            return (JpaEntityManagerFactory)emf;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"jpa_helper_invalid_entity_manager_factory", (Object[])new Object[]{emf.getClass()}));
    }

    public static JpaEntityManagerFactory getEntityManagerFactory(EntityManager em) {
        JpaEntityManager entityManager = JpaHelper.getEntityManager(em);
        if (entityManager != null && entityManager.getEntityManagerFactory() != null) {
            return ((EntityManagerFactoryDelegate)entityManager.getEntityManagerFactory()).getOwner();
        }
        return null;
    }

    public static DatabaseSession getDatabaseSession(EntityManagerFactory emf) {
        return JpaHelper.getEntityManagerFactory(emf).getDatabaseSession();
    }

    public static Server getServerSession(EntityManagerFactory emf) {
        return JpaHelper.getEntityManagerFactory(emf).getServerSession();
    }

    public static SessionBroker getSessionBroker(EntityManagerFactory emf) {
        return JpaHelper.getEntityManagerFactory(emf).getSessionBroker();
    }

    public static EntityManagerFactory createEntityManagerFactory(Server session) {
        return new EntityManagerFactoryImpl((AbstractSession)((ServerSession)session));
    }

    public static EntityManagerFactory createEntityManagerFactory(String sessionName) {
        SessionFactory sf = new SessionFactory(sessionName);
        return new EntityManagerFactoryImpl((AbstractSession)((ServerSession)sf.getSharedSession()));
    }

    public static void loadUnfetchedObject(FetchGroupTracker entity) {
        if (entity._persistence_getFetchGroup() != null) {
            EntityManagerImpl.processUnfetchedAttribute(entity, null);
        }
    }
}

