/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.jsf;

import jakarta.el.ELContextListener;
import jakarta.el.ExpressionFactory;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationWrapper;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.JspApplicationContext;
import jakarta.servlet.jsp.JspFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.glassfish.weld.util.Util;

public class WeldApplication
extends ApplicationWrapper {
    private final Application application;
    private ExpressionFactory expressionFactory;

    public WeldApplication(Application application) {
        this.application = application;
        BeanManager beanManager = this.getBeanManager();
        if (beanManager != null) {
            application.addELContextListener((ELContextListener)Util.newInstance("org.jboss.weld.module.web.el.WeldELContextListener"));
            application.addELResolver(beanManager.getELResolver());
            JspApplicationContext jspAppContext = JspFactory.getDefaultFactory().getJspApplicationContext((ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext());
            this.expressionFactory = beanManager.wrapExpressionFactory(jspAppContext.getExpressionFactory());
            ((JspApplicationContextImpl)jspAppContext).setExpressionFactory(this.expressionFactory);
        }
    }

    @Override
    public Application getWrapped() {
        return this.application;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        if (this.expressionFactory == null) {
            BeanManager beanManager = this.getBeanManager();
            this.expressionFactory = beanManager != null ? beanManager.wrapExpressionFactory(this.getWrapped().getExpressionFactory()) : this.getWrapped().getExpressionFactory();
        }
        return this.expressionFactory;
    }

    private BeanManager getBeanManager() {
        try {
            InitialContext context = new InitialContext();
            return (BeanManager)context.lookup("java:comp/BeanManager");
        }
        catch (NamingException e) {
            return null;
        }
    }
}

