/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.facelets.tag.jsf.core.ActionListenerHandlerBase;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.view.ActionSource2AttachedObjectHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public final class ResetValuesHandler
extends ActionListenerHandlerBase
implements ActionSource2AttachedObjectHandler {
    private final TagAttribute render = this.getAttribute("render");
    private static Pattern SPLIT_PATTERN = Pattern.compile(" ");

    public ResetValuesHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)((Object)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY));
        ActionSource as = (ActionSource)((Object)parent);
        String renderStr = (String)this.render.getObject(ctx, String.class);
        LazyActionListener listener = new LazyActionListener(ResetValuesHandler.toList(renderStr));
        as.addActionListener(listener);
    }

    private static List<String> toList(String strValue) {
        if (strValue.indexOf(32) == -1) {
            return Collections.singletonList(strValue);
        }
        String[] values = SPLIT_PATTERN.split(strValue);
        if (values == null || values.length == 0) {
            return null;
        }
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    private static final class LazyActionListener
    implements ActionListener,
    Serializable {
        Collection<String> render;
        private static final long serialVersionUID = -5676209243297546166L;

        public LazyActionListener(Collection<String> render) {
            this.render = new ArrayList<String>(render);
        }

        @Override
        public void processAction(ActionEvent event) throws AbortProcessingException {
            FacesContext context = FacesContext.getCurrentInstance();
            UIViewRoot root = context.getViewRoot();
            root.resetValues(context, this.render);
        }
    }
}

