/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.constraints.transformer;

import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebUserDataPermission;
import jakarta.servlet.annotation.ServletSecurity;
import java.security.Permission;
import java.security.Permissions;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.exousia.constraints.SecurityConstraint;
import org.glassfish.exousia.constraints.WebResourceCollection;
import org.glassfish.exousia.constraints.transformer.ConstraintValue;
import org.glassfish.exousia.constraints.transformer.MethodValue;
import org.glassfish.exousia.constraints.transformer.PatternBuilder;
import org.glassfish.exousia.permissions.JakartaPermissions;

public class ConstraintsToPermissionsTransformer {
    static final Logger logger = Logger.getLogger(ConstraintsToPermissionsTransformer.class.getName());
    static final String CLASS_NAME = ConstraintsToPermissionsTransformer.class.getSimpleName();
    private static final int DEFAULT_MAPPING = 0;
    private static final int EXTENSION_MAPPING = 1;
    private static final int PREFIX_MAPPING = 2;
    private static final int EXACT_MAPPING = 3;

    private ConstraintsToPermissionsTransformer() {
    }

    public static JakartaPermissions createResourceAndDataPermissions(Set<String> declaredRoles, boolean isDenyUncoveredHttpMethods, List<SecurityConstraint> securityConstraints) {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(ConstraintsToPermissionsTransformer.class.getSimpleName(), "createResourceAndDataPermissions");
            logger.log(Level.FINE, "Jakarta Authorization: constraint translation");
        }
        Collection<PatternBuilder> patterns = ConstraintsToPermissionsTransformer.constraintsToIntermediatePatterns(declaredRoles, securityConstraints);
        JakartaPermissions jakartaPermissions = ConstraintsToPermissionsTransformer.intermediatePatternsToPermissions(patterns, isDenyUncoveredHttpMethods);
        ConstraintsToPermissionsTransformer.logExcludedUncheckedPermissionsWritten(jakartaPermissions.getExcluded(), jakartaPermissions.getUnchecked());
        for (Map.Entry<String, Permissions> roleEntry : jakartaPermissions.getPerRole().entrySet()) {
            ConstraintsToPermissionsTransformer.logPerRolePermissionsWritten(roleEntry.getKey(), roleEntry.getValue());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "processConstraints");
        }
        return jakartaPermissions;
    }

    private static Collection<PatternBuilder> constraintsToIntermediatePatterns(Set<String> declaredRoles, List<SecurityConstraint> securityConstraints) {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "parseConstraints");
        }
        HashMap<String, PatternBuilder> patternBuilderMap = new HashMap<String, PatternBuilder>();
        patternBuilderMap.put("/", new PatternBuilder("/"));
        for (SecurityConstraint securityConstraint : securityConstraints) {
            logger.fine("Jakarta Authorization: constraint translation: begin parsing security constraint");
            Set<String> constraintRolesAllowed = securityConstraint.getRolesAllowed();
            ServletSecurity.TransportGuarantee transportGuarantee = securityConstraint.getTransportGuarantee();
            for (WebResourceCollection webResourceCollection : securityConstraint.getWebResourceCollections()) {
                logger.fine("Jakarta Authorization: constraint translation: begin parsing web resource collection");
                for (String urlPattern : webResourceCollection.getUrlPatterns()) {
                    PatternBuilder patternBuilder;
                    urlPattern = urlPattern.replaceAll(":", "%3A");
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Jakarta Authorization: constraint translation: process url pattern: " + urlPattern);
                    }
                    if ((patternBuilder = (PatternBuilder)patternBuilderMap.get(urlPattern)) == null) {
                        patternBuilder = new PatternBuilder(urlPattern);
                        for (Map.Entry patternBuilderEntry : patternBuilderMap.entrySet()) {
                            String otherUrl = (String)patternBuilderEntry.getKey();
                            int otherUrlType = ConstraintsToPermissionsTransformer.patternType(otherUrl);
                            switch (ConstraintsToPermissionsTransformer.patternType(urlPattern)) {
                                case 2: {
                                    if ((otherUrlType == 2 || otherUrlType == 3) && ConstraintsToPermissionsTransformer.implies(urlPattern, otherUrl)) {
                                        patternBuilder.addQualifier(otherUrl);
                                        break;
                                    }
                                    if (otherUrlType == 2 && ConstraintsToPermissionsTransformer.implies(otherUrl, urlPattern)) {
                                        ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                        break;
                                    }
                                    if (otherUrlType != 1 && otherUrlType != 0) break;
                                    ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                    break;
                                }
                                case 1: {
                                    if (otherUrlType == 2 || otherUrlType == 3 && ConstraintsToPermissionsTransformer.implies(urlPattern, otherUrl)) {
                                        patternBuilder.addQualifier(otherUrl);
                                        break;
                                    }
                                    if (otherUrlType != 0) break;
                                    ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                    break;
                                }
                                case 0: {
                                    if (otherUrlType == 0) break;
                                    patternBuilder.addQualifier(otherUrl);
                                    break;
                                }
                                case 3: {
                                    if ((otherUrlType == 2 || otherUrlType == 1) && ConstraintsToPermissionsTransformer.implies(otherUrl, urlPattern)) {
                                        ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                        break;
                                    }
                                    if (otherUrlType != 0) break;
                                    ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                    break;
                                }
                            }
                        }
                        patternBuilderMap.put(urlPattern, patternBuilder);
                    }
                    BitSet methods = MethodValue.encodeMethodsToBits(webResourceCollection.getHttpMethods());
                    BitSet omittedMethods = null;
                    if (methods.isEmpty()) {
                        omittedMethods = MethodValue.encodeMethodsToBits(webResourceCollection.getHttpMethodOmissions());
                    }
                    patternBuilder.setMethodOutcomes(declaredRoles, constraintRolesAllowed, transportGuarantee, methods, omittedMethods);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Jakarta Authorization: constraint translation: end processing url pattern: " + urlPattern);
                }
                logger.fine("Jakarta Authorization: constraint translation: end parsing web resource collection");
            }
            logger.fine("Jakarta Authorization: constraint translation: end parsing security constraint");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "parseConstraints");
        }
        return patternBuilderMap.values();
    }

    private static JakartaPermissions intermediatePatternsToPermissions(Collection<PatternBuilder> patterns, boolean isDenyUncoveredHttpMethods) {
        logger.log(Level.FINE, () -> "Jakarta Authorization: constraint capture: begin processing qualified url patterns - uncovered http methods will be " + (isDenyUncoveredHttpMethods ? "denied" : "permitted"));
        JakartaPermissions jakartaPermissions = new JakartaPermissions();
        for (PatternBuilder patternBuilder : patterns) {
            if (patternBuilder.isIrrelevantByQualifier()) continue;
            String urlPatternSpec = patternBuilder.getUrlPatternSpec();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Jakarta Authorization: constraint capture: urlPattern: " + urlPatternSpec);
            }
            patternBuilder.handleUncovered(isDenyUncoveredHttpMethods);
            ConstraintsToPermissionsTransformer.handleExcluded(jakartaPermissions.getExcluded(), patternBuilder, urlPatternSpec);
            ConstraintsToPermissionsTransformer.handlePerRole(jakartaPermissions.getPerRole(), patternBuilder, urlPatternSpec);
            ConstraintsToPermissionsTransformer.handleUnchecked(jakartaPermissions.getUnchecked(), patternBuilder, urlPatternSpec);
            ConstraintsToPermissionsTransformer.handleConnections(jakartaPermissions.getUnchecked(), patternBuilder, urlPatternSpec);
        }
        return jakartaPermissions;
    }

    private static void handleExcluded(Permissions collection, PatternBuilder patternBuilder, String name) {
        Object actions = null;
        BitSet excludedMethods = patternBuilder.getExcludedMethods();
        if (patternBuilder.getOtherConstraint().isExcluded()) {
            BitSet methods = patternBuilder.getMethodSet();
            methods.andNot(excludedMethods);
            if (!methods.isEmpty()) {
                actions = "!" + MethodValue.getActions(methods);
            }
        } else if (!excludedMethods.isEmpty()) {
            actions = MethodValue.getActions(excludedMethods);
        } else {
            return;
        }
        collection.add((Permission)new WebResourcePermission(name, (String)actions));
        collection.add((Permission)new WebUserDataPermission(name, (String)actions));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Jakarta Authorization: constraint capture: adding excluded methods: " + (String)actions);
        }
    }

    private static void handlePerRole(Map<String, Permissions> map, PatternBuilder patternBuilder, String urlPatternSpec) {
        BitSet methods;
        HashMap<String, BitSet> roleMap = patternBuilder.getRoleMap();
        List<String> roleList = null;
        if (!patternBuilder.getOtherConstraint().isExcluded() && patternBuilder.getOtherConstraint().isAuthConstrained()) {
            roleList = patternBuilder.getOtherConstraint().getRoles();
            for (String roleName : roleList) {
                BitSet methods2 = patternBuilder.getMethodSet();
                BitSet roleMethods = (BitSet)roleMap.get(roleName);
                if (roleMethods != null) {
                    methods2.andNot(roleMethods);
                }
                String httpMethodSpec = null;
                if (!methods2.isEmpty()) {
                    httpMethodSpec = "!" + MethodValue.getActions(methods2);
                }
                ConstraintsToPermissionsTransformer.addToRoleMap(map, roleName, (Permission)new WebResourcePermission(urlPatternSpec, httpMethodSpec));
            }
        }
        if (!(methods = patternBuilder.getMethodSet()).isEmpty()) {
            for (Map.Entry roleEntry : roleMap.entrySet()) {
                BitSet roleMethods;
                String roleName = (String)roleEntry.getKey();
                if (roleList != null && roleList.contains(roleName) || (roleMethods = (BitSet)roleEntry.getValue()).isEmpty()) continue;
                ConstraintsToPermissionsTransformer.addToRoleMap(map, roleName, (Permission)new WebResourcePermission(urlPatternSpec, MethodValue.getActions(roleMethods)));
            }
        }
    }

    private static void handleUnchecked(Permissions collection, PatternBuilder patternBuilder, String urlPatternSpec) {
        Object httpMethodSpec = null;
        BitSet noAuthMethods = patternBuilder.getNoAuthMethods();
        if (!patternBuilder.getOtherConstraint().isAuthConstrained()) {
            BitSet methods = patternBuilder.getMethodSet();
            methods.andNot(noAuthMethods);
            if (!methods.isEmpty()) {
                httpMethodSpec = "!" + MethodValue.getActions(methods);
            }
        } else if (!noAuthMethods.isEmpty()) {
            httpMethodSpec = MethodValue.getActions(noAuthMethods);
        } else {
            return;
        }
        collection.add((Permission)new WebResourcePermission(urlPatternSpec, (String)httpMethodSpec));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Jakarta Authorization: constraint capture: adding unchecked (for authorization) methods: " + (String)httpMethodSpec);
        }
    }

    private static void handleConnections(Permissions permissions, PatternBuilder patternBuilder, String name) {
        BitSet allConnectMethods = null;
        boolean allConnectAtOther = patternBuilder.getOtherConstraint().isConnectAllowed(1);
        for (int i = 0; i < ConstraintValue.connectKeys.length; ++i) {
            Object actions = null;
            String transport = ConstraintValue.connectKeys[i];
            BitSet connectMethods = patternBuilder.getConnectMap(1 << i);
            if (i == 0) {
                allConnectMethods = connectMethods;
            } else {
                connectMethods.andNot(allConnectMethods);
            }
            if (patternBuilder.getOtherConstraint().isConnectAllowed(1 << i)) {
                if (i != 0 && allConnectAtOther) {
                    if (connectMethods.isEmpty()) continue;
                    actions = MethodValue.getActions(connectMethods);
                } else {
                    BitSet methods = patternBuilder.getMethodSet();
                    methods.andNot(connectMethods);
                    if (!methods.isEmpty()) {
                        actions = "!" + MethodValue.getActions(methods);
                    }
                }
            } else {
                if (connectMethods.isEmpty()) continue;
                actions = MethodValue.getActions(connectMethods);
            }
            actions = actions == null ? "" : actions;
            String combinedActions = (String)actions + ":" + transport;
            permissions.add((Permission)new WebUserDataPermission(name, combinedActions));
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Jakarta Authorization: constraint capture: adding methods that accept connections with protection: " + transport + " methods: " + (String)actions);
        }
    }

    static int patternType(Object urlPattern) {
        String pattern = urlPattern.toString();
        if (pattern.startsWith("*.")) {
            return 1;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            return 2;
        }
        if (pattern.equals("/")) {
            return 0;
        }
        return 3;
    }

    static boolean implies(String pattern, String path) {
        if (pattern.equals(path)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            int length = (pattern = pattern.substring(0, pattern.length() - 2)).length();
            if (length == 0) {
                return true;
            }
            return path.startsWith(pattern) && (path.length() == length || path.substring(length).startsWith("/"));
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }

    private static void addToRoleMap(Map<String, Permissions> roleMap, String roleName, Permission permission) {
        roleMap.computeIfAbsent(roleName, e -> new Permissions()).add(permission);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Jakarta Authorization: constraint capture: adding methods to role: " + roleName + " methods: " + permission.getActions());
        }
    }

    private static void logExcludedUncheckedPermissionsWritten(Permissions excluded, Permissions unchecked) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Jakarta Authorization: constraint capture: end processing qualified url patterns");
            for (Permission permission : Collections.list(excluded.elements())) {
                logger.fine("Jakarta Authorization: permission(excluded) type: " + ConstraintsToPermissionsTransformer.permissionType(permission) + " name: " + permission.getName() + " actions: " + permission.getActions());
            }
            for (Permission permission : Collections.list(unchecked.elements())) {
                logger.fine("Jakarta Authorization: permission(unchecked) type: " + ConstraintsToPermissionsTransformer.permissionType(permission) + " name: " + permission.getName() + " actions: " + permission.getActions());
            }
        }
    }

    private static void logPerRolePermissionsWritten(String role, Permissions permissions) {
        if (logger.isLoggable(Level.FINE)) {
            for (Permission permission : Collections.list(permissions.elements())) {
                logger.fine("Jakarta Authorization: permission(" + role + ") type: " + ConstraintsToPermissionsTransformer.permissionType(permission) + " name: " + permission.getName() + " actions: " + permission.getActions());
            }
        }
    }

    private static String permissionType(Permission permission) {
        return permission instanceof WebResourcePermission ? "WRP  " : "WUDP ";
    }
}

