/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.sse.impl;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import org.glassfish.sse.api.ServerSentEventHandler;
import org.glassfish.sse.impl.ServerSentEventApplication;
import org.glassfish.sse.impl.ServerSentEventCdiExtension;
import org.glassfish.sse.impl.ServerSentEventConnectionImpl;

@WebServlet(asyncSupported=true)
public final class ServerSentEventServlet
extends HttpServlet {
    @Inject
    private transient ServerSentEventCdiExtension extension;
    @Inject
    private transient BeanManager bm;

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.extension == null) {
            throw new RuntimeException("Enable CDI by including empty WEB-INF/beans.xml");
        }
        Map<String, ServerSentEventApplication> applicationMap = this.extension.getApplicationMap();
        ServerSentEventApplication sseApp = applicationMap.get(req.getServletPath());
        Class<?> clazz = sseApp.getHandlerClass();
        Iterator it = this.bm.getBeans(clazz, new Annotation[0]).iterator();
        if (!it.hasNext()) {
            throw new RuntimeException("Cannot create ServerSentEventHandler using CDI");
        }
        Bean bean = (Bean)it.next();
        CreationalContext cc = this.bm.createCreationalContext((Contextual)bean);
        ServerSentEventHandler sseh = (ServerSentEventHandler)bean.create(cc);
        ServerSentEventHandler.Status status = sseh.onConnecting(req);
        if (status == ServerSentEventHandler.Status.DONT_RECONNECT) {
            resp.setStatus(204);
            cc.release();
            return;
        }
        if (status != ServerSentEventHandler.Status.OK) {
            throw new RuntimeException("Internal Error: need to handle status " + status);
        }
        resp.setStatus(200);
        resp.setContentType("text/event-stream");
        resp.flushBuffer();
        AsyncContext ac = req.startAsync(req, resp);
        ac.setTimeout(0L);
        ServerSentEventConnectionImpl con = sseApp.createConnection(req, sseh, cc, ac);
        ac.addListener(con);
        con.init();
    }
}

