/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jauth;

import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.ConfigFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.AppConfigurationEntry;

final class AuthContext {
    static final String INIT = "initialize";
    static final String DISPOSE_SUBJECT = "disposeSubject";
    static final String SECURE_REQUEST = "secureRequest";
    static final String VALIDATE_RESPONSE = "validateResponse";
    static final String VALIDATE_REQUEST = "validateRequest";
    static final String SECURE_RESPONSE = "secureResponse";
    static final String MANAGES_SESSIONS = "managesSessions";
    static final String MANAGES_SESSIONS_OPTION = "managessessions";
    private ConfigFile.Entry[] entries;
    private Logger logger;

    AuthContext(ConfigFile.Entry[] entries, Logger logger) throws AuthException {
        this.entries = entries;
        this.logger = logger;
    }

    Object[] invoke(final String methodName, final Object[] args) throws AuthException {
        final Object[] rValues = new Object[this.entries.length];
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws AuthException {
                    AuthContext.this.invokePriv(methodName, args, rValues);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof AuthException) {
                throw (AuthException)((Object)pae.getException());
            }
            AuthException ae = new AuthException();
            ae.initCause(pae.getException());
            throw ae;
        }
        return rValues;
    }

    void invokePriv(String methodName, Object[] args, Object[] rValues) throws AuthException {
        if (methodName.equals(MANAGES_SESSIONS)) {
            for (int i = 0; i < this.entries.length; ++i) {
                Map<String, ?> options = this.entries[i].getOptions();
                String mS = (String)options.get(MANAGES_SESSIONS_OPTION);
                rValues[i] = Boolean.valueOf(mS);
            }
            return;
        }
        boolean success = false;
        AuthException firstRequiredError = null;
        AuthException firstError = null;
        for (int i = 0; i < this.entries.length; ++i) {
            AuthException ae;
            Object module = this.entries[i].module;
            try {
                Method[] mArray;
                for (Method element : mArray = module.getClass().getMethods()) {
                    if (!element.getName().equals(methodName)) continue;
                    rValues[i] = element.invoke(module, args);
                    if (firstRequiredError == null && this.entries[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
                        if (this.logger != null && this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine(this.entries[i].getLoginModuleName() + "." + methodName + " SUFFICIENT success");
                        }
                        return;
                    }
                    if (this.logger != null && this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(this.entries[i].getLoginModuleName() + "." + methodName + " success");
                    }
                    success = true;
                    break;
                }
                if (success) continue;
                NoSuchMethodException nsme = new NoSuchMethodException("module " + module.getClass().getName() + " does not implement " + methodName);
                AuthException ae2 = new AuthException();
                ae2.initCause(nsme);
                throw ae2;
            }
            catch (IllegalAccessException iae) {
                ae = new AuthException();
                ae.initCause(iae);
                throw ae;
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof AuthException) {
                    ae = (AuthException)((Object)ite.getCause());
                } else {
                    ae = new AuthException();
                    ae.initCause(ite.getCause());
                }
                if (this.entries[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                    if (this.logger != null && this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(this.entries[i].getLoginModuleName() + "." + methodName + " REQUISITE failure");
                    }
                    if (firstRequiredError != null) {
                        throw firstRequiredError;
                    }
                    throw ae;
                }
                if (this.entries[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                    if (this.logger != null && this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(this.entries[i].getLoginModuleName() + "." + methodName + " REQUIRED failure");
                    }
                    if (firstRequiredError != null) continue;
                    firstRequiredError = ae;
                    continue;
                }
                if (this.logger != null && this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(this.entries[i].getLoginModuleName() + "." + methodName + " OPTIONAL failure");
                }
                if (firstError != null) continue;
                firstError = ae;
            }
        }
        if (firstRequiredError != null) {
            throw firstRequiredError;
        }
        if (firstError != null && !success) {
            throw firstError;
        }
        if (this.logger != null && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("overall " + methodName + " success");
        }
    }
}

