/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.common.signature;

import ee.jakarta.tck.concurrent.common.signature.SigTestResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public abstract class SignatureTestDriver {
    private static final String SIG_FILE_EXT = ".sig";

    public String getPackageFileImpl(String binDir) {
        String thePkgListFile = "sig-test-pkg-list.txt";
        System.out.println("Using the following as the SigTest Package file: " + thePkgListFile);
        String theFile = binDir + File.separator + thePkgListFile;
        File ff = new File(theFile);
        if (!ff.exists()) {
            System.out.println("The SigTest Package file does not exist: " + thePkgListFile);
            theFile = binDir + File.separator + "sig-test-pkg-list.txt";
            File ff2 = new File(theFile);
            if (!ff2.exists()) {
                System.out.println("The Default SigTest Package file does not exist either: " + theFile);
            } else {
                System.out.println("Defaulting to using SigTest Package file: " + theFile);
            }
        }
        return theFile;
    }

    public String getMapFileImpl(String binDir) {
        String theMapFile = "sig-test.map";
        System.out.println("Using the following as the sig-Test map file: " + theMapFile);
        String theFile = binDir + File.separator + theMapFile;
        File ff = new File(theFile);
        if (!ff.exists()) {
            System.out.println("The SigTest Map file does not exist: " + theMapFile);
            theFile = binDir + File.separator + "sig-test.map";
            File ff2 = new File(theFile);
            if (!ff2.exists()) {
                System.out.println("The SigTest Map file does not exist either: " + theFile);
            } else {
                System.out.println("Defaulting to using SigTest Map file: " + theFile);
            }
        }
        return theFile;
    }

    public Boolean isJavaSEVersion(String ver) {
        String strOSVersion = System.getProperty("java.version");
        return strOSVersion.startsWith(ver);
    }

    public String getRepositoryDirImpl(String tsHome) {
        return tsHome + File.separator + "src" + File.separator + "com" + File.separator + "sun" + File.separator + "ts" + File.separator + "tests" + File.separator + "signaturetest" + File.separator + "signature-repository" + File.separator;
    }

    public void cleanupImpl() throws Exception {
        try {
            System.out.println("cleanup");
        }
        catch (Exception e) {
            System.out.println("Exception in cleanup method" + e);
            throw e;
        }
    }

    public SigTestResult executeSigTest(String packageListFile, String mapFile, String signatureRepositoryDir, String[] packagesUnderTest, String[] classesUnderTest, String classpath, ArrayList<String> unaccountedTechPkgs, String optionalPkgToIgnore) throws Exception {
        String[] args2;
        String[] args;
        String packageName;
        int i;
        SigTestResult result = new SigTestResult();
        System.out.println("optionalPkgToIgnore = " + optionalPkgToIgnore);
        String[] arrayOptionalPkgsToIgnore = null;
        if (optionalPkgToIgnore != null) {
            arrayOptionalPkgsToIgnore = optionalPkgToIgnore.split(",");
        }
        if (packagesUnderTest != null && packagesUnderTest.length > 0) {
            System.out.println("********** BEGIN PACKAGE LEVEL SIGNATURE VALIDATION **********\n\n");
            for (i = 0; i < packagesUnderTest.length; ++i) {
                packageName = packagesUnderTest[i];
                System.out.println("********** BEGIN VALIDATE PACKAGE '" + packagesUnderTest[i] + "' **********\n");
                System.out.println("********** VALIDATE IN STATIC MODE - TO CHECK CONSANT VALUES ****");
                System.out.println("Static mode supports checks of static constants values ");
                args = this.createTestArguments(packageListFile, mapFile, signatureRepositoryDir, packageName, classpath, true);
                SignatureTestDriver.dumpTestArguments(args);
                if (this.runSignatureTest(packageName, args)) {
                    System.out.println("********** Package '" + packageName + "' - PASSED (STATIC MODE) **********");
                    result.addPassedPkg(packageName + "(static mode)");
                } else {
                    result.addFailedPkg(packageName + "(static mode)");
                    System.out.println("********** Package '" + packageName + "' - FAILED (STATIC MODE) **********");
                }
                System.out.println("\n\n");
                System.out.println("********** VALIDATE IN REFLECTIVE MODE  ****");
                System.out.println("Reflective mode supports verification within containers (ie ejb, servlet, etc)");
                args2 = this.createTestArguments(packageListFile, mapFile, signatureRepositoryDir, packageName, classpath, false);
                SignatureTestDriver.dumpTestArguments(args2);
                if (this.runSignatureTest(packageName, args2)) {
                    System.out.println("********** Package '" + packageName + "' - PASSED (REFLECTION MODE) **********");
                    result.addPassedPkg(packageName + "(reflection mode)");
                } else {
                    result.addFailedPkg(packageName + "(reflection mode)");
                    System.out.println("********** Package '" + packageName + "' - FAILED (REFLECTION MODE) **********");
                }
                System.out.println("********** END VALIDATE PACKAGE '" + packagesUnderTest[i] + "' **********\n");
                System.out.println("\n");
                System.out.println("\n");
            }
        }
        if (classesUnderTest != null && classesUnderTest.length > 0) {
            System.out.println("********** BEGIN CLASS LEVEL SIGNATURE VALIDATION **********\n\n");
            for (i = 0; i < classesUnderTest.length; ++i) {
                String className = classesUnderTest[i];
                System.out.println("********** BEGIN VALIDATE CLASS '" + classesUnderTest[i] + "' **********\n");
                System.out.println("********** VALIDATE IN STATIC MODE - TO CHECK CONSANT VALUES ****");
                System.out.println("Static mode supports checks of static constants values ");
                args = this.createTestArguments(packageListFile, mapFile, signatureRepositoryDir, className, classpath, true);
                SignatureTestDriver.dumpTestArguments(args);
                if (this.runSignatureTest(className, args)) {
                    System.out.println("********** Class '" + className + "' - PASSED (STATIC MODE) **********");
                    result.addPassedClass(className + "(static mode)");
                } else {
                    System.out.println("********** Class '" + className + "' - FAILED (STATIC MODE) **********");
                    result.addFailedClass(className + "(static mode)");
                }
                System.out.println("\n\n");
                System.out.println("********** VALIDATE IN REFLECTIVE MODE  ****");
                System.out.println("Reflective mode supports verification within containers (ie ejb, servlet, etc)");
                args2 = this.createTestArguments(packageListFile, mapFile, signatureRepositoryDir, className, classpath, false);
                SignatureTestDriver.dumpTestArguments(args2);
                if (this.runSignatureTest(className, args2)) {
                    System.out.println("********** Class '" + className + "' - PASSED (REFLECTION MODE) **********");
                    result.addPassedClass(className + "(reflection mode)");
                } else {
                    System.out.println("********** Class '" + className + "' - FAILED (REFLECTION MODE) **********");
                    result.addFailedClass(className + "(reflection mode)");
                }
                System.out.println("********** END VALIDATE CLASS '" + classesUnderTest[i] + "' **********\n");
                System.out.println("\n");
                System.out.println("\n");
            }
        }
        if (unaccountedTechPkgs != null) {
            for (int ii = 0; ii < unaccountedTechPkgs.size(); ++ii) {
                packageName = unaccountedTechPkgs.get(ii);
                if (SignatureTestDriver.isIgnorePackageUnderTest(packageName, arrayOptionalPkgsToIgnore)) {
                    System.out.println("Ignoring special optional technology package: " + packageName);
                    continue;
                }
                System.out.println("\n\n");
                System.out.println("********** CHECK IF OPTIONAL TECHNOLOGIES EXIST IN REFLECTIVE MODE  ****");
                System.out.println("Reflective mode supports verification within containers (ie ejb, servlet, etc)");
                String[] args3 = this.createTestArguments(packageListFile, mapFile, signatureRepositoryDir, packageName, classpath, false);
                SignatureTestDriver.dumpTestArguments(args3);
                if (this.runPackageSearch(packageName, args3)) {
                    System.out.println("********** Package '" + packageName + "' - WAS FOUND BUT SHOULD NOT BE (REFLECTION MODE) **********");
                    Object err = "ERROR:  An area of concern has been identified.  ";
                    err = (String)err + "You must run sigtests with (ts.jte) javaee.level set to ";
                    err = (String)err + "include all optional technology keywords.  Whole and/or ";
                    err = (String)err + "partial implementations of Optional Technologies ";
                    err = (String)err + "must be implemented according to the specs AND must pass ";
                    err = (String)err + "all related TCK tests.  To properly pass the ";
                    err = (String)err + "signature tests - you must identify all Optional Technology ";
                    err = (String)err + "areas (via javaee.level) that you wish to pass signature tests for.";
                    System.out.println((String)err);
                    result.addFailedPkg(packageName + " (Undeclared Optional Technology package found in reflection mode)");
                    continue;
                }
                System.out.println("********** Undeclared Optional Technology package '" + packageName + "' - PASSED (REFLECTION MODE) **********");
            }
        }
        return result;
    }

    protected abstract String[] createTestArguments(String var1, String var2, String var3, String var4, String var5, boolean var6) throws Exception;

    protected abstract boolean runSignatureTest(String var1, String[] var2) throws Exception;

    protected abstract boolean runPackageSearch(String var1, String[] var2) throws Exception;

    protected abstract boolean verifyJTAJarForNoXA(String var1, String var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadMapFile(String mapFile) throws IOException, FileNotFoundException {
        FileInputStream in = null;
        try {
            File map = new File(mapFile);
            Properties props = new Properties();
            in = new FileInputStream(map);
            props.load(in);
            Properties properties = props;
            return properties;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    protected String getSigFileName(String baseName, String repositoryDir, String version) throws FileNotFoundException {
        String sigFile = repositoryDir.endsWith(File.separator) ? repositoryDir + baseName + SIG_FILE_EXT : repositoryDir + File.separator + baseName + SIG_FILE_EXT;
        File testFile = new File(sigFile);
        if (!testFile.exists() && !testFile.isFile()) {
            throw new FileNotFoundException("Signature file \"" + sigFile + "\" does not exist.");
        }
        return testFile.toString();
    }

    protected abstract String normalizeFileName(File var1);

    protected SignatureFileInfo getSigFileInfo(String originalPackage, String mapFile, String repositoryDir) throws Exception {
        String packageName = originalPackage;
        String name = null;
        String version = null;
        Properties props = this.loadMapFile(mapFile);
        while (true) {
            boolean packageFound = false;
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                if (!name.equals(packageName)) continue;
                version = props.getProperty(name);
                packageFound = true;
                break;
            }
            if (packageFound) break;
            int index = packageName.lastIndexOf(".");
            if (index <= 0) {
                throw new Exception("Package \"" + originalPackage + "\" not specified in mapping file \"" + mapFile + "\".");
            }
            packageName = packageName.substring(0, index);
        }
        return new SignatureFileInfo(this.getSigFileName(name, repositoryDir, version), version);
    }

    private static boolean isIgnorePackageUnderTest(String packageName, String[] arrayOptionalPkgsToIgnore) {
        if (packageName == null || arrayOptionalPkgsToIgnore == null) {
            return false;
        }
        for (int ii = 0; ii < arrayOptionalPkgsToIgnore.length; ++ii) {
            if (!packageName.equals(arrayOptionalPkgsToIgnore[ii])) continue;
            return true;
        }
        return false;
    }

    private static void dumpTestArguments(String[] params) {
        if (params != null && params.length > 0) {
            System.out.println("----------------- BEGIN SIG PARAM DUMP -----------------");
            for (int i = 0; i < params.length; ++i) {
                System.out.println("   Param[" + i + "]: " + params[i]);
            }
            System.out.println("------------------ END SIG PARAM DUMP ------------------");
        }
    }

    protected static class SignatureFileInfo {
        private String file;
        private String version;

        public SignatureFileInfo(String file, String version) {
            if (file == null) {
                throw new IllegalArgumentException("'file' argument cannot be null");
            }
            if (version == null) {
                throw new IllegalArgumentException("'version' argument cannot be null");
            }
            this.file = file;
            this.version = version;
        }

        public String getFile() {
            return this.file;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

