/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.dynamic.destroy.normal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

public abstract class AbstractContext
implements Context {
    protected final Map<Contextual<?>, Instance> storage = new ConcurrentHashMap();

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        T instance = this.get(contextual);
        if (instance == null) {
            this.storage.put(contextual, new Instance(contextual.create(creationalContext), creationalContext));
            instance = this.get(contextual);
        }
        return instance;
    }

    public <T> T get(Contextual<T> contextual) {
        Instance instance = this.storage.get(contextual);
        if (instance != null) {
            return (T)instance.instance;
        }
        return null;
    }

    public boolean isActive() {
        return true;
    }

    protected static class Instance {
        private final Object instance;
        private final CreationalContext<?> ctx;

        public Instance(Object instance, CreationalContext<?> ctx) {
            this.instance = instance;
            this.ctx = ctx;
        }

        public Object getInstance() {
            return this.instance;
        }

        public CreationalContext<?> getCtx() {
            return this.ctx;
        }
    }
}

