/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation.event;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Destroyed;
import javax.enterprise.event.Observes;
import javax.servlet.ServletRequest;

@ApplicationScoped
public class ApplicationScopedObserver {
    private final AtomicBoolean destroyedCalled = new AtomicBoolean();
    private final AtomicBoolean beforeDestroyedCalled = new AtomicBoolean();

    void observeBeforeDestroyed(@Observes @BeforeDestroyed(value=ConversationScoped.class) ServletRequest event) {
        if (event.getAttribute("foo") != null) {
            this.beforeDestroyedCalled.set(true);
        }
    }

    void observeRequestDestroyed(@Observes @Destroyed(value=ConversationScoped.class) ServletRequest event) {
        if (event.getAttribute("foo") != null) {
            this.destroyedCalled.set(true);
        }
    }

    boolean isBeforeDestroyedCalled() {
        return this.beforeDestroyedCalled.get();
    }

    boolean isDestroyedCalled() {
        return this.destroyedCalled.get();
    }

    public void reset() {
        this.beforeDestroyedCalled.set(false);
        this.destroyedCalled.set(false);
    }
}

