/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.Set;
import org.jboss.cdi.tck.util.ParameterizedTypeImpl;

public class HierarchyDiscovery {
    private final Type type;
    private Set<Type> types;

    public HierarchyDiscovery(Type type) {
        this.type = type;
    }

    protected void add(Type type) {
        this.types.add(type);
    }

    public Set<Type> getFlattenedTypes() {
        if (this.types == null) {
            this.types = new HashSet<Type>();
            this.discoverTypes(this.type);
        }
        return this.types;
    }

    public Type getResolvedType() {
        return this.resolveType(this.type, this.type);
    }

    private void discoverTypes(Type type) {
        if (type != null) {
            Type rawType;
            this.add(type);
            if (type instanceof Class) {
                this.discoverFromClass((Class)type);
            } else if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
                this.discoverFromClass((Class)rawType);
            }
        }
    }

    private void discoverFromClass(Class<?> clazz) {
        this.discoverTypes(this.resolveType(this.type, clazz.getGenericSuperclass()));
        for (Type c : clazz.getGenericInterfaces()) {
            this.discoverTypes(this.resolveType(this.type, c));
        }
    }

    private Type resolveType(Type beanType, Type type) {
        if (type instanceof ParameterizedType) {
            if (beanType instanceof ParameterizedType) {
                return this.resolveParameterizedType((ParameterizedType)beanType, (ParameterizedType)type);
            }
            if (beanType instanceof Class) {
                return this.resolveType(((Class)beanType).getGenericSuperclass(), type);
            }
        }
        if (type instanceof TypeVariable) {
            if (beanType instanceof ParameterizedType) {
                return this.resolveTypeParameter((ParameterizedType)beanType, (TypeVariable)type);
            }
            if (beanType instanceof Class) {
                return this.resolveType(((Class)beanType).getGenericSuperclass(), type);
            }
        }
        return type;
    }

    private Type resolveParameterizedType(ParameterizedType beanType, ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        Type[] actualTypes = parameterizedType.getActualTypeArguments();
        Type resolvedRawType = this.resolveType(beanType, rawType);
        Type[] resolvedActualTypes = new Type[actualTypes.length];
        for (int i = 0; i < actualTypes.length; ++i) {
            resolvedActualTypes[i] = this.resolveType(beanType, actualTypes[i]);
        }
        return new ParameterizedTypeImpl(resolvedRawType, resolvedActualTypes, parameterizedType.getOwnerType());
    }

    private Type resolveTypeParameter(ParameterizedType beanType, TypeVariable<?> typeVariable) {
        Class actualType = (Class)beanType.getRawType();
        TypeVariable<Class<T>>[] typeVariables = actualType.getTypeParameters();
        Type[] actualTypes = beanType.getActualTypeArguments();
        for (int i = 0; i < typeVariables.length; ++i) {
            if (!typeVariables[i].equals(typeVariable)) continue;
            return this.resolveType(this.type, actualTypes[i]);
        }
        Type genericSuperType = actualType.getGenericSuperclass();
        Type type = this.resolveType(genericSuperType, typeVariable);
        if (!(type instanceof TypeVariable)) {
            return type;
        }
        for (Type interfaceType : actualType.getGenericInterfaces()) {
            Type resolvedType = this.resolveType(interfaceType, typeVariable);
            if (resolvedType instanceof TypeVariable) continue;
            return resolvedType;
        }
        return typeVariable;
    }
}

