/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.lifecycle.bbd;

import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.bbd.DataAccess;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.bbd.NotAuthorizedException;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.bbd.User;
import org.jboss.cdi.tck.util.SimpleLogger;

@Decorator
public class DataAccessAuthorizationDecorator
implements DataAccess {
    private static final SimpleLogger logger = new SimpleLogger(DataAccessAuthorizationDecorator.class);
    @Inject
    @Delegate
    DataAccess delegate;
    @Inject
    User user;

    @Override
    public void save() {
        this.authorize("save");
        this.delegate.save();
    }

    @Override
    public void delete() {
        this.authorize("delete");
        this.delegate.delete();
    }

    private void authorize(String action) {
        Object id = this.delegate.getId();
        Class<?> type = this.delegate.getDataType();
        if (!this.user.hasPermission(action, type, id)) {
            logger.log("Not authorized for " + action, new Object[0]);
            throw new NotAuthorizedException(action);
        }
        logger.log("Authorized for " + action, new Object[0]);
    }

    @Override
    public Class<?> getDataType() {
        return this.delegate.getDataType();
    }

    @Override
    public Object getId() {
        return this.delegate.getId();
    }

    @Override
    public Object load(Object id) {
        return this.delegate.load(id);
    }
}

