/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.events.lifecycle;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Shutdown;
import jakarta.enterprise.event.Startup;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.tests.se.events.lifecycle.ObservingBean;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"se"})
@SpecVersion(spec="cdi", version="4.0")
public class StartupShutdownTest {
    @Deployment
    public static Archive<?> createTestArchive() {
        return ClassPath.builder().add((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage(StartupShutdownTest.class.getPackage())).build();
    }

    @Test
    public void testEvents() {
        Assert.assertTrue((boolean)ObservingBean.OBSERVED_STARTING_EVENTS.isEmpty());
        Assert.assertTrue((boolean)ObservingBean.OBSERVED_SHUTDOWN_EVENTS.isEmpty());
        try (SeContainer seContainer = SeContainerInitializer.newInstance().addBeanClasses(new Class[]{ObservingBean.class}).initialize();){
            Assert.assertTrue((ObservingBean.OBSERVED_STARTING_EVENTS.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ObservingBean.OBSERVED_STARTING_EVENTS.get(0).equals(ApplicationScoped.class.getSimpleName()));
            Assert.assertTrue((boolean)ObservingBean.OBSERVED_STARTING_EVENTS.get(1).equals(Startup.class.getSimpleName()));
        }
        Assert.assertTrue((ObservingBean.OBSERVED_SHUTDOWN_EVENTS.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ObservingBean.OBSERVED_SHUTDOWN_EVENTS.get(0).equals(Shutdown.class.getSimpleName()));
        Assert.assertTrue((boolean)ObservingBean.OBSERVED_SHUTDOWN_EVENTS.get(1).equals(ApplicationScoped.class.getSimpleName()));
    }
}

