/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.test;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edapt.internal.common.URIUtils;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.test.MigrationTestBase;
import org.eclipse.emf.edapt.migration.test.MigrationTestSuite;
import org.eclipse.emf.edapt.migration.test.TestCaseDefinition;

public class MigrationTestCase
extends MigrationTestBase {
    private final MigrationTestSuite suite;
    private final TestCaseDefinition caseDefinition;

    public MigrationTestCase(MigrationTestSuite suite, TestCaseDefinition caseDefinition) {
        this.setName("testMigration");
        this.caseDefinition = caseDefinition;
        this.suite = suite;
    }

    private URI getURI(String uri) {
        URI definitionURI = this.caseDefinition.eResource().getURI();
        return URI.createFileURI((String)uri).resolve(definitionURI);
    }

    public void testMigration() throws MigrationException, IOException {
        URI modelURI = this.getURI(this.caseDefinition.getModel());
        URI expectedURI = this.getURI(this.caseDefinition.getExpectedModel());
        URI historyURI = this.getURI(this.caseDefinition.getSuite().getHistory());
        URI metamodelURI = URIUtils.replaceExtension((URI)historyURI, (String)"ecore");
        this.testMigration(this.suite.getMigrator(), modelURI, expectedURI, metamodelURI, this.caseDefinition.getExpectedDifferences());
    }

    public String getName() {
        return this.caseDefinition.getName();
    }
}

