/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.replacement;

import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="suppressedSetVisibilityToNotChangeable", label="Suppressed Set Visibility to Not Changeable", description="In the metamodel, the setter of a reference is made visible again, and at the same time it is made non-changeable. Nothing is changed in the model.")
public class SuppressedSetVisibilityToNotChangeable
extends OperationImplementation {
    @EdaptParameter(main=true, description="The reference whose setter is made visible again")
    public EReference reference;

    @EdaptConstraint(description="Suppressed Set Visibility must be present")
    public boolean checkSuppressedSetVisibilityNotPresent() {
        return this.getAnnotation() != null;
    }

    public void execute(Metamodel metamodel, Model model) {
        EAnnotation annotation = this.getAnnotation();
        this.reference.setChangeable(false);
        if (annotation.getDetails().size() > 1) {
            annotation.getDetails().remove((Object)"suppressedSetVisibility");
        } else {
            metamodel.delete((EModelElement)annotation);
        }
    }

    private EAnnotation getAnnotation() {
        for (EAnnotation annotation : this.reference.getEAnnotations()) {
            for (Map.Entry detail : annotation.getDetails().entrySet()) {
                if (!"suppressedSetVisibility".equals(detail.getKey())) continue;
                return annotation;
            }
        }
        return null;
    }
}

