/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.migration;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edapt.common.EcoreUtils;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.MigrationFactory;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.eclipse.emf.edapt.spi.migration.ModelResource;
import org.eclipse.emf.edapt.spi.migration.ReferenceSlot;

public class ForwardConverter {
    protected Model model;
    protected Map<EObject, Instance> mapping;

    public Model convert(ResourceSet resourceSet) {
        this.model = MigrationFactory.eINSTANCE.createModel();
        this.mapping = new IdentityHashMap<EObject, Instance>();
        this.initElements(resourceSet);
        this.initProperties(resourceSet);
        this.initResources(resourceSet);
        return this.model;
    }

    protected void initElements(ResourceSet resourceSet) {
        for (Resource resource : resourceSet.getResources()) {
            TreeIterator i = resource.getAllContents();
            while (i.hasNext()) {
                EObject eObject = (EObject)i.next();
                if (this.mapping.containsKey(eObject)) {
                    i.prune();
                    continue;
                }
                Instance instance = this.newInstance(eObject, eObject.eIsProxy());
                String uuid = EcoreUtils.getUUID((EObject)eObject);
                instance.setUuid(uuid);
            }
        }
    }

    protected void initProperties(ResourceSet resourceSet) {
        HashSet<EObject> done = new HashSet<EObject>();
        for (Resource resource : resourceSet.getResources()) {
            TreeIterator i = resource.getAllContents();
            while (i.hasNext()) {
                EObject eObject = (EObject)i.next();
                if (done.contains(eObject)) {
                    i.prune();
                    continue;
                }
                this.initInstance(eObject);
                done.add(eObject);
            }
        }
    }

    protected void initResources(ResourceSet resourceSet) {
        for (Resource resource : resourceSet.getResources()) {
            if (resource.getContents().isEmpty()) continue;
            ModelResource modelResource = MigrationFactory.eINSTANCE.createModelResource();
            modelResource.setUri(resource.getURI());
            if (resource instanceof XMLResource) {
                XMLResource xmlResource = (XMLResource)resource;
                modelResource.setEncoding(xmlResource.getEncoding());
            }
            this.model.getResources().add((Object)modelResource);
            for (EObject element : resource.getContents()) {
                modelResource.getRootInstances().add((Object)this.resolve(element));
            }
        }
    }

    protected void initInstance(EObject eObject) {
        Object value;
        Instance element = this.resolve(eObject);
        EClass c = eObject.eClass();
        for (EAttribute attribute : c.getEAllAttributes()) {
            if (this.ignore((EStructuralFeature)attribute) || !eObject.eIsSet((EStructuralFeature)attribute)) continue;
            value = eObject.eGet((EStructuralFeature)attribute);
            element.set((EStructuralFeature)attribute, value);
        }
        for (EReference reference : c.getEAllReferences()) {
            if (this.ignore((EStructuralFeature)reference)) continue;
            value = eObject.eGet((EStructuralFeature)reference);
            if (reference.isMany()) {
                List valueEObjects = (List)value;
                int index = 0;
                for (EObject valueEObject : valueEObjects) {
                    Instance valueInstance = this.resolve(valueEObject);
                    if (reference.isUnique() && ((List)element.get((EStructuralFeature)reference)).contains(valueInstance)) {
                        ReferenceSlot referenceSlot = (ReferenceSlot)element.getSlot((EStructuralFeature)reference);
                        try {
                            referenceSlot.getValues().move(index, (Object)valueInstance);
                            ++index;
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                        continue;
                    }
                    element.add((EStructuralFeature)reference, index, (Object)valueInstance);
                    ++index;
                }
                continue;
            }
            if (value == null) continue;
            EObject valueEObject = (EObject)value;
            Instance valueInstance = this.resolve(valueEObject);
            element.set((EStructuralFeature)reference, (Object)valueInstance);
        }
    }

    protected boolean ignore(EStructuralFeature feature) {
        if (feature.isTransient()) {
            EReference reference;
            return !(feature instanceof EReference) || (reference = (EReference)feature).getEOpposite() == null || reference.getEOpposite().isTransient();
        }
        return false;
    }

    protected Instance newInstance(EObject eObject, boolean proxy) {
        EClass eClass = eObject.eClass();
        Instance element = this.model.newInstance(eClass);
        this.mapping.put(eObject, element);
        if (proxy) {
            element.setUri(EcoreUtil.getURI((EObject)eObject));
        }
        return element;
    }

    protected Instance resolve(EObject eObject) {
        Instance resolved = this.mapping.get(eObject);
        if (resolved == null) {
            resolved = this.newInstance(eObject, true);
        }
        return resolved;
    }
}

