/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecp.edit.internal.swt.util.CellEditorFactory;
import org.eclipse.emf.ecp.edit.spi.DeleteService;
import org.eclipse.emf.ecp.edit.spi.EMFDeleteServiceImpl;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCellEditor;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCellEditorComparator;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPElementAwareCellEditor;
import org.eclipse.emf.ecp.edit.spi.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.view.internal.table.swt.CellReadOnlyTesterHelper;
import org.eclipse.emf.ecp.view.internal.table.swt.TableConfigurationHelper;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.DiagnosticMessageExtractor;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.swt.TableControlService;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.background.model.VTBackgroundFactory;
import org.eclipse.emf.ecp.view.template.style.background.model.VTBackgroundStyleProperty;
import org.eclipse.emf.ecp.view.template.style.fontProperties.model.VTFontPropertiesFactory;
import org.eclipse.emf.ecp.view.template.style.fontProperties.model.VTFontPropertiesStyleProperty;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.VTTableStyleProperty;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.VTTableStylePropertyFactory;
import org.eclipse.emf.ecp.view.template.style.tableValidation.model.VTTableValidationFactory;
import org.eclipse.emf.ecp.view.template.style.tableValidation.model.VTTableValidationStyleProperty;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.internal.swt.table.DefaultTableViewerCompositeBuilder;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.emfforms.spi.swt.core.layout.EMFFormsSWTLayoutUtil;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.emfforms.spi.swt.table.ButtonBarBuilder;
import org.eclipse.emfforms.spi.swt.table.CellLabelProviderFactory;
import org.eclipse.emfforms.spi.swt.table.EditingSupportCreator;
import org.eclipse.emfforms.spi.swt.table.TableViewerComposite;
import org.eclipse.emfforms.spi.swt.table.TableViewerCompositeBuilder;
import org.eclipse.emfforms.spi.swt.table.TableViewerCreator;
import org.eclipse.emfforms.spi.swt.table.TableViewerFactory;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTBuilder;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.FrameworkUtil;

public class TableControlSWTRenderer
extends AbstractControlSWTRenderer<VTableControl> {
    private static final String FIXED_COLUMNS = "org.eclipse.rap.rwt.fixedColumns";
    private static final String TABLE_CUSTOM_VARIANT = "org_eclipse_emf_ecp_control_table";
    private static final String ICON_ADD = "icons/add.png";
    private static final String ICON_DELETE = "icons/delete.png";
    private final Map<Integer, ECPCellEditorComparator> columnIndexToComparatorMap = new LinkedHashMap<Integer, ECPCellEditorComparator>();
    private final ImageRegistryService imageRegistryService;
    private final EMFDataBindingContext viewModelDBC;
    private final EMFFormsEditSupport emfFormsEditSupport;
    private SWTGridDescription rendererGridDescription;
    private TableViewer tableViewer;
    private Label validationIcon;
    private Button addButton;
    private Button removeButton;
    private Optional<Integer> minimumHeight;
    private Optional<Integer> maximumHeight;
    private TableControlSWTRendererButtonBarBuilder tableControlSWTRendererButtonBarBuilder;

    @Inject
    public TableControlSWTRenderer(VTableControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabindingEMF emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService, EMFFormsEditSupport emfFormsEditSupport) {
        super((VControl)vElement, viewContext, reportService, (EMFFormsDatabinding)emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.imageRegistryService = imageRegistryService;
        this.emfFormsEditSupport = emfFormsEditSupport;
        this.viewModelDBC = new EMFDataBindingContext();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected EMFFormsDatabindingEMF getEMFFormsDatabinding() {
        return (EMFFormsDatabindingEMF)super.getEMFFormsDatabinding();
    }

    protected Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        try {
            VDomainModelReference dmrToCheck = this.getDMRToMultiReference();
            IObservableList list = this.getEMFFormsDatabinding().getObservableList(dmrToCheck, this.getViewModelContext().getDomainModel());
            IObservableValue labelText = this.getLabelText(dmrToCheck, false);
            IObservableValue labelTooltipText = this.getLabelTooltipText(dmrToCheck, false);
            ObservableListContentProvider cp = new ObservableListContentProvider();
            ECPTableViewerComparator comparator = new ECPTableViewerComparator();
            TableControlSWTRendererCompositeBuilder compositeBuilder = new TableControlSWTRendererCompositeBuilder();
            this.tableControlSWTRendererButtonBarBuilder = new TableControlSWTRendererButtonBarBuilder();
            TableViewerSWTBuilder tableViewerSWTBuilder = TableViewerFactory.fillDefaults((Composite)parent, (int)0, (Object)list, (IObservableValue)labelText, (IObservableValue)labelTooltipText).customizeCompositeStructure((TableViewerCompositeBuilder)compositeBuilder).customizeButtons((ButtonBarBuilder)this.tableControlSWTRendererButtonBarBuilder).customizeTableViewerCreation((TableViewerCreator)new TableControlSWTRendererTableViewerCreator()).customizeContentProvider((IContentProvider)cp).customizeComparator((ViewerComparator)comparator);
            int regularColumnsStartIndex = 0;
            if (!((VTableControl)this.getVElement()).isReadonly()) {
                ++regularColumnsStartIndex;
                this.createFixedValidationStatusColumn(tableViewerSWTBuilder);
            }
            regularColumnsStartIndex += this.addAdditionalColumns(tableViewerSWTBuilder);
            this.addColumns(tableViewerSWTBuilder, ((EReference)EReference.class.cast(list.getElementType())).getEReferenceType(), cp);
            this.initCompositeHeight();
            TableViewerComposite tableViewerComposite = tableViewerSWTBuilder.create();
            tableViewerComposite.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionChangedListener());
            tableViewerComposite.getTableViewer().addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
            this.setupSorting(comparator, regularColumnsStartIndex, tableViewerComposite);
            this.setupValidation(tableViewerComposite);
            this.setTableViewer(tableViewerComposite.getTableViewer());
            SWTDataElementIdHelper.setElementIdDataForVControl((Widget)tableViewerComposite, (VControl)((VControl)this.getVElement()), (ViewModelContext)this.getViewModelContext());
            ((GridData)GridData.class.cast((Object)compositeBuilder.getViewerComposite().getLayoutData())).heightHint = this.getTableHeightHint();
            this.addRelayoutListenerIfNeeded(list, compositeBuilder.getViewerComposite());
            this.addResizeListener(tableViewerComposite.getTableViewer().getTable(), regularColumnsStartIndex);
            return tableViewerComposite;
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            Label errorLabel = new Label(parent, 0);
            errorLabel.setText(ex.getMessage());
            return errorLabel;
        }
    }

    protected int addAdditionalColumns(TableViewerSWTBuilder tableViewerSWTBuilder) {
        return 0;
    }

    private void addResizeListener(final Table table, final int regularColumnsStartIndex) {
        ControlAdapter controlAdapter = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TableControlSWTRenderer.this.updateTableColumnWidths(table, regularColumnsStartIndex);
            }
        };
        table.addControlListener((ControlListener)controlAdapter);
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.addControlListener((ControlListener)controlAdapter);
            ++n2;
        }
    }

    private void updateTableColumnWidths(Table table, int regularColumnsStartIndex) {
        VTableControl tableControl = (VTableControl)this.getVElement();
        Table swtTable = this.getTableViewer().getTable();
        TableColumn[] allColumns = swtTable.getColumns();
        int i = regularColumnsStartIndex;
        while (i < allColumns.length) {
            TableColumn tableColumn = allColumns[i];
            VDomainModelReference columnDMR = (VDomainModelReference)((VTableDomainModelReference)VTableDomainModelReference.class.cast(tableControl.getDomainModelReference())).getColumnDomainModelReferences().get(i - regularColumnsStartIndex);
            TableConfigurationHelper.updateWidthConfiguration(tableControl, columnDMR, swtTable, tableColumn);
            ++i;
        }
    }

    private void initCompositeHeight() {
        VTTableStyleProperty styleProperty = this.getTableStyleProperty();
        this.minimumHeight = styleProperty.isSetMinimumHeight() ? Optional.of((Object)styleProperty.getMinimumHeight()) : Optional.empty();
        this.maximumHeight = styleProperty.isSetMaximumHeight() ? Optional.of((Object)styleProperty.getMaximumHeight()) : Optional.empty();
    }

    private void addRelayoutListenerIfNeeded(IObservableList list, final Composite composite) {
        if (list == null) {
            return;
        }
        if (!this.minimumHeight.isPresent() && !this.maximumHeight.isPresent()) {
            return;
        }
        if (this.minimumHeight.isPresent() && this.maximumHeight.isPresent() && this.minimumHeight.get() == this.maximumHeight.get()) {
            return;
        }
        final GridData gridData = (GridData)GridData.class.cast(composite.getLayoutData());
        list.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                gridData.heightHint = TableControlSWTRenderer.this.getTableHeightHint();
                EMFFormsSWTLayoutUtil.adjustParentSize((Control)composite);
            }
        });
    }

    private void addColumns(TableViewerSWTBuilder tableViewerSWTBuilder, EClass clazz, ObservableListContentProvider cp) {
        InternalEObject tempInstance = null;
        if (!clazz.isAbstract() && !clazz.isInterface()) {
            tempInstance = this.getInstanceOf(clazz);
        }
        VTableDomainModelReference tableDomainModelReference = (VTableDomainModelReference)VTableDomainModelReference.class.cast(((VTableControl)this.getVElement()).getDomainModelReference());
        for (VDomainModelReference dmr : tableDomainModelReference.getColumnDomainModelReferences()) {
            try {
                int weight;
                int minWidth;
                if (dmr == null) continue;
                IObservableValue text = this.getLabelText(dmr, true);
                IObservableValue tooltip = this.getLabelTooltipText(dmr, true);
                IEMFValueProperty valueProperty = this.getEMFFormsDatabinding().getValueProperty(dmr, this.getViewModelContext().getDomainModel());
                EStructuralFeature eStructuralFeature = (EStructuralFeature)valueProperty.getValueType();
                IObservableMap observableMap = valueProperty.observeDetail(cp.getKnownElements());
                TableControlEditingSupportAndLabelProvider labelProvider = new TableControlEditingSupportAndLabelProvider(tempInstance, eStructuralFeature, dmr, (IValueProperty)valueProperty, observableMap, tableDomainModelReference.getColumnDomainModelReferences().indexOf((Object)dmr));
                TableControlEditingSupportAndLabelProvider editingSupportCreator = TableConfigurationHelper.isReadOnly((VTableControl)this.getVElement(), dmr) ? null : labelProvider;
                Optional<Integer> weightConfig = TableConfigurationHelper.getColumnWeight((VTableControl)this.getVElement(), dmr);
                Optional<Integer> widthConfig = TableConfigurationHelper.getColumnWidth((VTableControl)this.getVElement(), dmr);
                if (weightConfig.isPresent()) {
                    minWidth = (Integer)widthConfig.get();
                    weight = (Integer)weightConfig.get();
                } else {
                    CellEditor tempCellEditor = this.createCellEditor((EObject)tempInstance, eStructuralFeature, new Table((Composite)new Shell(), 0));
                    weight = ECPCellEditor.class.isInstance(tempCellEditor) ? ((ECPCellEditor)ECPCellEditor.class.cast(tempCellEditor)).getColumnWidthWeight() : 100;
                    minWidth = ECPCellEditor.class.isInstance(tempCellEditor) ? ((ECPCellEditor)ECPCellEditor.class.cast(tempCellEditor)).getMinWidth() : 10;
                }
                tableViewerSWTBuilder.addColumn(true, false, 0, weight, minWidth, text, tooltip, (CellLabelProviderFactory)labelProvider, (EditingSupportCreator)editingSupportCreator, null);
            }
            catch (DatabindingFailedException ex) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            }
        }
    }

    private void setupValidation(TableViewerComposite tableViewerComposite) {
        List validationControls;
        if (tableViewerComposite.getValidationControls().isPresent() && (validationControls = (List)tableViewerComposite.getValidationControls().get()).size() == 1 && Label.class.isInstance(validationControls.get(0))) {
            this.validationIcon = (Label)validationControls.get(0);
        }
    }

    private void setupSorting(ECPTableViewerComparator comparator, int regularColumnsStartIndex, TableViewerComposite tableViewerComposite) {
        int i = regularColumnsStartIndex;
        while (i < tableViewerComposite.getTableViewer().getTable().getColumns().length) {
            TableColumn tableColumn = tableViewerComposite.getTableViewer().getTable().getColumns()[i];
            tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(tableViewerComposite.getTableViewer(), comparator, tableColumn, i - regularColumnsStartIndex));
            ++i;
        }
    }

    private IObservableValue getLabelText(VDomainModelReference dmrToCheck, boolean forColumn) {
        EMFFormsLabelProvider labelService = this.getEMFFormsLabelProvider();
        if (forColumn) {
            try {
                return labelService.getDisplayName(dmrToCheck);
            }
            catch (NoLabelFoundException e) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
                return Observables.constantObservableValue((Object)e.getMessage(), String.class);
            }
        }
        switch (((VTableControl)this.getVElement()).getLabelAlignment()) {
            case NONE: {
                return Observables.constantObservableValue((Object)"", String.class);
            }
        }
        try {
            return labelService.getDisplayName(dmrToCheck, this.getViewModelContext().getDomainModel());
        }
        catch (NoLabelFoundException e) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
            return Observables.constantObservableValue((Object)e.getMessage(), String.class);
        }
    }

    private IObservableValue getLabelTooltipText(VDomainModelReference dmrToCheck, boolean forColumn) {
        EMFFormsLabelProvider labelService = this.getEMFFormsLabelProvider();
        try {
            if (forColumn) {
                return labelService.getDescription(dmrToCheck);
            }
        }
        catch (NoLabelFoundException e) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
            return Observables.constantObservableValue((Object)e.toString(), String.class);
        }
        switch (((VTableControl)this.getVElement()).getLabelAlignment()) {
            case NONE: {
                return Observables.constantObservableValue((Object)"", String.class);
            }
        }
        try {
            return labelService.getDescription(dmrToCheck, this.getViewModelContext().getDomainModel());
        }
        catch (NoLabelFoundException e) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
            return Observables.constantObservableValue((Object)e.toString(), String.class);
        }
    }

    private VDomainModelReference getDMRToMultiReference() {
        VTableDomainModelReference tableDomainModelReference = (VTableDomainModelReference)((VTableControl)this.getVElement()).getDomainModelReference();
        VTableDomainModelReference dmrToCheck = tableDomainModelReference.getDomainModelReference() == null ? tableDomainModelReference : tableDomainModelReference.getDomainModelReference();
        return dmrToCheck;
    }

    protected int addButtonsToButtonBar(Composite buttonComposite) {
        return 0;
    }

    protected Composite createControlComposite(Composite composite) {
        Composite controlComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, this.getTableHeightHint()).applyTo((Control)controlComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(controlComposite);
        return controlComposite;
    }

    protected int getTableHeightHint() {
        if (!this.minimumHeight.isPresent() && !this.maximumHeight.isPresent()) {
            return 200;
        }
        if (this.minimumHeight.isPresent() && this.maximumHeight.isPresent() && this.minimumHeight.get() == this.maximumHeight.get()) {
            return (Integer)this.minimumHeight.get();
        }
        int requiredHeight = this.computeRequiredHeight();
        if (this.minimumHeight.isPresent() && !this.maximumHeight.isPresent()) {
            return requiredHeight < (Integer)this.minimumHeight.get() ? (Integer)this.minimumHeight.get() : requiredHeight;
        }
        if (!this.minimumHeight.isPresent() && this.maximumHeight.isPresent()) {
            return requiredHeight > (Integer)this.maximumHeight.get() ? (Integer)this.maximumHeight.get() : requiredHeight;
        }
        if (requiredHeight < (Integer)this.minimumHeight.get()) {
            return (Integer)this.minimumHeight.get();
        }
        if (requiredHeight > (Integer)this.maximumHeight.get()) {
            return (Integer)this.maximumHeight.get();
        }
        return requiredHeight;
    }

    private int computeRequiredHeight() {
        if (this.tableViewer == null) {
            return -1;
        }
        Table table = this.tableViewer.getTable();
        if (table == null) {
            return -1;
        }
        if (table.isDisposed()) {
            return -1;
        }
        int itemHeight = table.getItemHeight();
        int itemCount = Math.max(table.getItemCount(), 1);
        int headerHeight = table.getHeaderVisible() ? table.getHeaderHeight() : 0;
        int tableHeight = itemHeight * itemCount + headerHeight + 4;
        return tableHeight;
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected void setTableViewer(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    protected void viewerSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            if (this.getRemoveButton() != null) {
                this.getRemoveButton().setEnabled(false);
            }
        } else if (this.getRemoveButton() != null) {
            this.getRemoveButton().setEnabled(true);
        }
    }

    private SelectionAdapter getSelectionAdapter(final TableViewer tableViewer, final ECPTableViewerComparator comparator, final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.setColumn(index);
                int dir = comparator.getDirection();
                tableViewer.getTable().setSortDirection(dir);
                tableViewer.getTable().setSortColumn(column);
                tableViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private void createFixedValidationStatusColumn(TableViewerSWTBuilder tableViewerSWTBuilder) {
        VTTableValidationStyleProperty tableValidationStyleProperty = this.getTableValidationStyleProperty();
        int columnWidth = tableValidationStyleProperty.getColumnWidth();
        String columnName = tableValidationStyleProperty.getColumnName();
        String imagePath = tableValidationStyleProperty.getImagePath();
        Image image = null;
        if (imagePath != null && !imagePath.isEmpty()) {
            try {
                image = this.getImage(new File(imagePath).toURI().toURL());
            }
            catch (MalformedURLException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex));
            }
        }
        tableViewerSWTBuilder.addColumn(true, false, 0, 0, columnWidth, columnName, columnName, (CellLabelProvider)new ValidationStatusCellLabelProvider((VTableControl)this.getVElement()), null, image);
    }

    protected Image getImage(URL url) {
        return this.imageRegistryService.getImage(url);
    }

    protected Image getImage(String path) {
        return this.imageRegistryService.getImage(FrameworkUtil.getBundle(TableControlSWTRenderer.class), path);
    }

    private VTTableValidationStyleProperty getTableValidationStyleProperty() {
        VTTableValidationStyleProperty tableValidationStyleProperties = this.getStyleProperty(VTTableValidationStyleProperty.class);
        if (tableValidationStyleProperties == null) {
            tableValidationStyleProperties = this.getDefaultTableValidationStyleProperty();
        }
        return tableValidationStyleProperties;
    }

    private VTTableValidationStyleProperty getDefaultTableValidationStyleProperty() {
        VTTableValidationStyleProperty tableValidationProp = VTTableValidationFactory.eINSTANCE.createTableValidationStyleProperty();
        tableValidationProp.setColumnWidth(80);
        tableValidationProp.setColumnName(LocalizationServiceHelper.getString(TableControlSWTRenderer.class, (String)"TableControl_ValidationStatusColumn"));
        tableValidationProp.setImagePath(null);
        return tableValidationProp;
    }

    private VTBackgroundStyleProperty getBackgroundStyleProperty() {
        VTBackgroundStyleProperty styleProperty = this.getStyleProperty(VTBackgroundStyleProperty.class);
        if (styleProperty == null) {
            styleProperty = this.getDefaultBackgroundStyleProperty();
        }
        return styleProperty;
    }

    private VTBackgroundStyleProperty getDefaultBackgroundStyleProperty() {
        return VTBackgroundFactory.eINSTANCE.createBackgroundStyleProperty();
    }

    private VTTableStyleProperty getTableStyleProperty() {
        VTTableStyleProperty styleProperty = this.getStyleProperty(VTTableStyleProperty.class);
        if (styleProperty == null) {
            styleProperty = this.getDefaultTableStylProperty();
        }
        return styleProperty;
    }

    private VTTableStyleProperty getDefaultTableStylProperty() {
        VTTableStyleProperty tableStyleProperty = VTTableStylePropertyFactory.eINSTANCE.createTableStyleProperty();
        tableStyleProperty.setMaximumHeight(200);
        if (!((VTableControl)this.getVElement()).isReadonly()) {
            tableStyleProperty.setMinimumHeight(200);
        }
        return tableStyleProperty;
    }

    private VTFontPropertiesStyleProperty getFontPropertiesStyleProperty() {
        VTFontPropertiesStyleProperty styleProperty = this.getStyleProperty(VTFontPropertiesStyleProperty.class);
        if (styleProperty == null) {
            styleProperty = this.getDefaultFontPropertiesStyleProperty();
        }
        return styleProperty;
    }

    private VTFontPropertiesStyleProperty getDefaultFontPropertiesStyleProperty() {
        VTFontPropertiesStyleProperty property = VTFontPropertiesFactory.eINSTANCE.createFontPropertiesStyleProperty();
        property.setColorHEX("000000");
        return property;
    }

    private <SP extends VTStyleProperty> SP getStyleProperty(Class<SP> stylePropertyClass) {
        Set styleProperties = this.getVTViewTemplateProvider().getStyleProperties(this.getVElement(), this.getViewModelContext());
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!stylePropertyClass.isInstance(styleProperty)) continue;
            return (SP)((VTStyleProperty)stylePropertyClass.cast(styleProperty));
        }
        return null;
    }

    private Color getSWTColor(String colorHex) {
        String redString = colorHex.substring(0, 2);
        String greenString = colorHex.substring(2, 4);
        String blueString = colorHex.substring(4, 6);
        int red = Integer.parseInt(redString, 16);
        int green = Integer.parseInt(greenString, 16);
        int blue = Integer.parseInt(blueString, 16);
        return new Color((Device)Display.getDefault(), red, green, blue);
    }

    protected CellEditor createCellEditor(EObject tempInstance, EStructuralFeature feature, Table table) {
        return CellEditorFactory.INSTANCE.getCellEditor(feature, tempInstance, table, this.getViewModelContext());
    }

    private InternalEObject getInstanceOf(EClass clazz) {
        return (InternalEObject)InternalEObject.class.cast(clazz.getEPackage().getEFactoryInstance().create(clazz));
    }

    private Button createRemoveRowButton(EClass clazz, Composite buttonComposite, EObject eObject, EStructuralFeature structuralFeature) {
        this.removeButton = new Button(buttonComposite, 0);
        Image image = this.getImage(ICON_DELETE);
        this.removeButton.setImage(image);
        this.removeButton.setEnabled(false);
        String instanceName = clazz.getInstanceClass() == null ? "" : clazz.getInstanceClass().getSimpleName();
        this.removeButton.setToolTipText(String.format(LocalizationServiceHelper.getString(TableControlSWTRenderer.class, (String)"TableControl_RemoveSelected"), instanceName));
        List containments = (List)eObject.eGet(structuralFeature, true);
        if (containments.size() <= structuralFeature.getLowerBound()) {
            this.removeButton.setEnabled(false);
        }
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)this.removeButton, (VElement)this.getVElement(), (String)"table_remove", (ViewModelContext)this.getViewModelContext());
        return this.removeButton;
    }

    private Button createAddRowButton(EClass clazz, Composite buttonComposite, EObject eObject, EStructuralFeature structuralFeature) {
        this.addButton = new Button(buttonComposite, 0);
        Image image = this.getImage(ICON_ADD);
        this.addButton.setImage(image);
        String instanceName = clazz.getInstanceClass() == null ? "" : clazz.getInstanceClass().getSimpleName();
        this.addButton.setToolTipText(String.format(LocalizationServiceHelper.getString(TableControlSWTRenderer.class, (String)"TableControl_AddInstanceOf"), instanceName));
        List containments = (List)eObject.eGet(structuralFeature, true);
        if (structuralFeature.getUpperBound() != -1 && containments.size() >= structuralFeature.getUpperBound()) {
            this.addButton.setEnabled(false);
        }
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)this.addButton, (VElement)this.getVElement(), (String)"table_add", (ViewModelContext)this.getViewModelContext());
        return this.addButton;
    }

    protected void deleteRowUserConfirmDialog(final List<EObject> deletionList, final EObject eObject, final EStructuralFeature structuralFeature, final Button addButton, final Button removeButton) {
        MessageDialog dialog = new MessageDialog(addButton.getShell(), LocalizationServiceHelper.getString(TableControlSWTRenderer.class, (String)"TableControl_Delete"), null, LocalizationServiceHelper.getString(TableControlSWTRenderer.class, (String)"TableControl_DeleteAreYouSure"), 5, new String[]{JFaceResources.getString((String)"yes"), JFaceResources.getString((String)"no")}, 0);
        new ECPDialogExecutor((Dialog)dialog){

            public void handleResult(int codeResult) {
                if (codeResult == 1 || codeResult == -1) {
                    return;
                }
                TableControlSWTRenderer.this.deleteRows(deletionList, eObject, structuralFeature);
                List containments = (List)eObject.eGet(structuralFeature, true);
                if (containments.size() < structuralFeature.getUpperBound()) {
                    addButton.setEnabled(true);
                }
                if (containments.size() <= structuralFeature.getLowerBound()) {
                    removeButton.setEnabled(false);
                }
            }
        }.execute();
    }

    protected void deleteRows(List<EObject> deletionList, EObject eObject, EStructuralFeature structuralFeature) {
        EditingDomain editingDomain = this.getEditingDomain(eObject);
        EReference reference = (EReference)EReference.class.cast(structuralFeature);
        ArrayList<EObject> toDelete = new ArrayList<EObject>(deletionList);
        if (reference.isContainment()) {
            DeleteService deleteService = (DeleteService)this.getViewModelContext().getService(DeleteService.class);
            if (deleteService == null) {
                deleteService = new EMFDeleteServiceImpl();
            }
            deleteService.deleteElements(toDelete);
        } else {
            this.removeElements(editingDomain, eObject, (EStructuralFeature)reference, toDelete);
        }
    }

    private void removeElements(EditingDomain editingDomain, Object source, EStructuralFeature feature, Collection<Object> toRemove) {
        Command removeCommand = RemoveCommand.create((EditingDomain)editingDomain, (Object)source, (Object)feature, toRemove);
        if (removeCommand.canExecute()) {
            if (editingDomain.getCommandStack() == null) {
                removeCommand.execute();
            } else {
                editingDomain.getCommandStack().execute(removeCommand);
            }
        }
    }

    protected void addRow(EClass clazz, EObject eObject, EStructuralFeature structuralFeature) {
        Optional eObjectToAdd;
        TableControlService tableService = (TableControlService)this.getViewModelContext().getService(TableControlService.class);
        if (tableService == null) {
            if (clazz.isAbstract() || clazz.isInterface()) {
                this.getReportService().report((AbstractReport)new StatusReport(new Status(2, "org.eclipse.emf.ecp.view.table.ui.swt", String.format("The class %1$s is abstract or an interface.", clazz.getName()))));
                eObjectToAdd = Optional.empty();
            } else {
                eObjectToAdd = Optional.of((Object)clazz.getEPackage().getEFactoryInstance().create(clazz));
            }
        } else {
            eObjectToAdd = tableService.createNewElement(clazz, eObject, structuralFeature);
        }
        if (!eObjectToAdd.isPresent()) {
            return;
        }
        EObject instance = (EObject)eObjectToAdd.get();
        EditingDomain editingDomain = this.getEditingDomain(eObject);
        editingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)structuralFeature, (Object)instance));
        this.tableViewer.setSelection((ISelection)new StructuredSelection(eObjectToAdd.get()), true);
    }

    protected void applyValidation() {
        Display.getDefault().asyncExec((Runnable)new ApplyValidationRunnable());
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected void applyEnable() {
        if (this.getAddButton() != null) {
            this.getAddButton().setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
        if (this.getRemoveButton() != null) {
            this.getRemoveButton().setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
    }

    protected void applyReadOnly() {
        if (this.getAddButton() != null) {
            this.getAddButton().setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
        if (this.getRemoveButton() != null) {
            this.getRemoveButton().setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
    }

    protected void dispose() {
        this.rendererGridDescription = null;
        this.viewModelDBC.dispose();
        super.dispose();
    }

    protected int compare(Viewer viewer, Object e1, Object e2, int direction, int propertyIndex) {
        Object value2;
        Object value1;
        if (direction == 0) {
            return 0;
        }
        int rc = 0;
        EObject object1 = (EObject)e1;
        EObject object2 = (EObject)e2;
        VDomainModelReference dmr = (VDomainModelReference)((VTableDomainModelReference)((VTableControl)this.getVElement()).getDomainModelReference()).getColumnDomainModelReferences().get(propertyIndex);
        EMFFormsDatabindingEMF emfFormsDatabinding = this.getEMFFormsDatabinding();
        try {
            IObservableValue observableValue1 = emfFormsDatabinding.getObservableValue(dmr, object1);
            EStructuralFeature structuralFeature1 = (EStructuralFeature)observableValue1.getValueType();
            EObject observed1 = (EObject)((IObserving)observableValue1).getObserved();
            value1 = observed1.eGet(structuralFeature1, true);
            observableValue1.dispose();
        }
        catch (DatabindingFailedException ex) {
            value1 = null;
        }
        try {
            IObservableValue observableValue2 = emfFormsDatabinding.getObservableValue(dmr, object2);
            EStructuralFeature structuralFeature2 = (EStructuralFeature)observableValue2.getValueType();
            EObject observed2 = (EObject)((IObserving)observableValue2).getObserved();
            value2 = observed2.eGet(structuralFeature2, true);
            observableValue2.dispose();
        }
        catch (DatabindingFailedException ex) {
            value2 = null;
        }
        if (this.columnIndexToComparatorMap.containsKey(propertyIndex)) {
            return this.columnIndexToComparatorMap.get(propertyIndex).compare(value1, value2, direction);
        }
        rc = value1 == null ? 1 : (value2 == null ? -1 : value1.toString().compareTo(value2.toString()));
        if (direction == 2) {
            rc = -rc;
        }
        return rc;
    }

    protected void rootDomainModelChanged() throws DatabindingFailedException {
        IObservableList oldList = (IObservableList)this.getTableViewer().getInput();
        oldList.dispose();
        IObservableList list = this.getEMFFormsDatabinding().getObservableList(this.getDMRToMultiReference(), this.getViewModelContext().getDomainModel());
        this.getTableViewer().setInput((Object)list);
        this.tableControlSWTRendererButtonBarBuilder.updateValues();
    }

    private final class ApplyValidationRunnable
    implements Runnable {
        private ApplyValidationRunnable() {
        }

        @Override
        public void run() {
            IObservableValue observableValue;
            if (TableControlSWTRenderer.this.validationIcon == null) {
                return;
            }
            if (TableControlSWTRenderer.this.validationIcon.isDisposed()) {
                return;
            }
            if (((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic() == null) {
                return;
            }
            VTableDomainModelReference tableDMR = (VTableDomainModelReference)((VTableControl)TableControlSWTRenderer.this.getVElement()).getDomainModelReference();
            try {
                observableValue = tableDMR.getDomainModelReference() != null ? TableControlSWTRenderer.this.getEMFFormsDatabinding().getObservableValue(tableDMR.getDomainModelReference(), TableControlSWTRenderer.this.getViewModelContext().getDomainModel()) : TableControlSWTRenderer.this.getEMFFormsDatabinding().getObservableValue((VDomainModelReference)tableDMR, TableControlSWTRenderer.this.getViewModelContext().getDomainModel());
            }
            catch (DatabindingFailedException ex) {
                TableControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                return;
            }
            EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
            EObject eObject = (EObject)((IObserving)observableValue).getObserved();
            observableValue.dispose();
            TableControlSWTRenderer.this.validationIcon.setImage(TableControlSWTRenderer.this.getValidationIcon(((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic().getHighestSeverity()));
            TableControlSWTRenderer.this.validationIcon.setToolTipText(ECPTooltipModifierHelper.modifyString((String)((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic().getMessage(), null));
            Collection collection = (Collection)eObject.eGet(structuralFeature, true);
            if (!collection.isEmpty()) {
                for (Object object : collection) {
                    TableControlSWTRenderer.this.tableViewer.update(object, null);
                }
            }
        }
    }

    private final class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            TableControlService tableService = (TableControlService)TableControlSWTRenderer.this.getViewModelContext().getService(TableControlService.class);
            if (tableService == null) {
                return;
            }
            ISelection selection = event.getSelection();
            if (!StructuredSelection.class.isInstance(selection)) {
                return;
            }
            tableService.doubleClick((VTableControl)TableControlSWTRenderer.this.getVElement(), (EObject)((StructuredSelection)StructuredSelection.class.cast(selection)).getFirstElement());
        }
    }

    public class ECPCellLabelProvider
    extends ObservableMapCellLabelProvider
    implements IColorProvider {
        private final EStructuralFeature feature;
        private final CellEditor cellEditor;
        private final VTableControl vTableControl;
        private final VDomainModelReference dmr;
        private final Table table;

        public ECPCellLabelProvider(EStructuralFeature feature, CellEditor cellEditor, IObservableMap attributeMap, VTableControl vTableControl, VDomainModelReference dmr, Table table) {
            super(attributeMap);
            this.vTableControl = vTableControl;
            this.feature = feature;
            this.cellEditor = cellEditor;
            this.dmr = dmr;
            this.table = table;
        }

        public String getToolTipText(Object element) {
            String message;
            IObservableValue observableValue;
            EObject domainObject = (EObject)element;
            try {
                observableValue = TableControlSWTRenderer.this.getEMFFormsDatabinding().getObservableValue(this.dmr, domainObject);
            }
            catch (DatabindingFailedException ex) {
                TableControlSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                return null;
            }
            EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
            EObject eObject = (EObject)((IObserving)observableValue).getObserved();
            EStructuralFeature.Setting setting = ((InternalEObject)eObject).eSetting(structuralFeature);
            observableValue.dispose();
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic != null && (message = DiagnosticMessageExtractor.getMessage((Collection)vDiagnostic.getDiagnostic(domainObject, this.feature))) != null && !message.isEmpty()) {
                return ECPTooltipModifierHelper.modifyString((String)message, (EStructuralFeature.Setting)setting);
            }
            Object value = eObject.eGet(structuralFeature, true);
            if (value == null) {
                return null;
            }
            return ECPTooltipModifierHelper.modifyString((String)String.valueOf(value), (EStructuralFeature.Setting)setting);
        }

        public void update(ViewerCell cell) {
            EObject element = (EObject)cell.getElement();
            Object value = this.attributeMaps[0].get((Object)element);
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ECPCellEditor ecpCellEditor = (ECPCellEditor)this.cellEditor;
                String text = ecpCellEditor.getFormatedString(value);
                cell.setText(text == null ? "" : text);
                cell.setImage(ecpCellEditor.getImage(value));
            } else {
                cell.setText(value == null ? "" : value.toString());
                cell.getControl().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_edit_cellEditor_string");
            }
            cell.setForeground(this.getForeground(element));
            cell.setBackground(this.getBackground(element));
        }

        public Color getForeground(Object element) {
            return this.table.getForeground();
        }

        public Color getBackground(Object element) {
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic == null) {
                return TableControlSWTRenderer.this.getValidationBackgroundColor(0);
            }
            List diagnostic = vDiagnostic.getDiagnostic((EObject)element, this.feature);
            return TableControlSWTRenderer.this.getValidationBackgroundColor(diagnostic.size() == 0 ? 0 : ((Diagnostic)diagnostic.get(0)).getSeverity());
        }
    }

    private class ECPTableEditingSupport
    extends EditingSupport {
        private final CellEditor cellEditor;
        private final VTableControl tableControl;
        private final IValueProperty valueProperty;
        private final VDomainModelReference domainModelReference;
        private EditingState editingState;
        private final ColumnViewerEditorActivationListenerHelper activationListener;

        ECPTableEditingSupport(ColumnViewer viewer, CellEditor cellEditor, VTableControl tableControl, VDomainModelReference domainModelReference, IValueProperty valueProperty) {
            super(viewer);
            this.activationListener = new ColumnViewerEditorActivationListenerHelper();
            this.cellEditor = cellEditor;
            this.tableControl = tableControl;
            this.valueProperty = valueProperty;
            this.domainModelReference = domainModelReference;
        }

        protected boolean canEdit(Object element) {
            boolean editable = this.tableControl.isEnabled() && !this.tableControl.isReadonly();
            IObservableValue observableValue = this.valueProperty.observe(element);
            EObject eObject = (EObject)((IObserving)observableValue).getObserved();
            EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
            EStructuralFeature.Setting setting = ((InternalEObject)eObject).eSetting(structuralFeature);
            editable &= TableControlSWTRenderer.this.emfFormsEditSupport.canSetProperty(this.domainModelReference, (EObject)element);
            editable &= !CellReadOnlyTesterHelper.getInstance().isReadOnly((VTableControl)TableControlSWTRenderer.this.getVElement(), setting);
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ((ECPCellEditor)ECPCellEditor.class.cast(this.cellEditor)).setEditable(editable);
                return true;
            }
            return editable;
        }

        protected Object getValue(Object element) {
            return null;
        }

        protected void setValue(Object element, Object value) {
        }

        protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            if (ECPElementAwareCellEditor.class.isInstance(cellEditor)) {
                ((ECPElementAwareCellEditor)ECPElementAwareCellEditor.class.cast(cellEditor)).updateRowElement(cell.getElement());
            }
            IObservableValue target = this.doCreateCellEditorObservable(cellEditor);
            Assert.isNotNull((Object)target, (String)"doCreateCellEditorObservable(...) did not return an observable");
            IObservableValue model = this.valueProperty.observe(cell.getElement());
            Assert.isNotNull((Object)model, (String)"The databinding service did not return an observable");
            Binding binding = this.createBinding(target, model);
            Assert.isNotNull((Object)binding, (String)"createBinding(...) did not return a binding");
            this.editingState = new EditingState(binding, target, model);
            this.getViewer().getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)this.activationListener);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Binding createBinding(IObservableValue target, IObservableValue model) {
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                return TableControlSWTRenderer.this.getDataBindingContext().bindValue(target, model, ((ECPCellEditor)this.cellEditor).getTargetToModelStrategy(TableControlSWTRenderer.this.getDataBindingContext()), ((ECPCellEditor)this.cellEditor).getModelToTargetStrategy(TableControlSWTRenderer.this.getDataBindingContext()));
            }
            return TableControlSWTRenderer.this.getDataBindingContext().bindValue(target, model);
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            if (ECPCellEditor.class.isInstance(cellEditor)) {
                return ((ECPCellEditor)cellEditor).getValueProperty().observe((Object)cellEditor);
            }
            return WidgetProperties.text((int)16).observe((Widget)cellEditor.getControl());
        }

        protected final void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            this.editingState.binding.updateTargetToModel();
        }

        private class ColumnViewerEditorActivationListenerHelper
        extends ColumnViewerEditorActivationListener {
            private ColumnViewerEditorActivationListenerHelper() {
            }

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
                Control control = ECPTableEditingSupport.this.cellEditor.getControl();
                if (control == null || control.isDisposed()) {
                    return;
                }
                control.setBackground(ECPTableEditingSupport.this.getViewer().getControl().getBackground());
                control.setForeground(ECPTableEditingSupport.this.getViewer().getControl().getForeground());
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                ECPTableEditingSupport.this.editingState.dispose();
                ECPTableEditingSupport.this.editingState = null;
                ECPTableEditingSupport.this.getViewer().getColumnViewerEditor().removeEditorActivationListener((ColumnViewerEditorActivationListener)this);
                ViewerCell focusCell = ECPTableEditingSupport.this.getViewer().getColumnViewerEditor().getFocusCell();
                if (focusCell != null) {
                    ECPTableEditingSupport.this.getViewer().update(focusCell.getElement(), null);
                }
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }
        }

        class EditingState {
            private final IObservableValue target;
            private final IObservableValue model;
            private final Binding binding;

            EditingState(Binding binding, IObservableValue target, IObservableValue model) {
                this.binding = binding;
                this.target = target;
                this.model = model;
            }

            void dispose() {
                this.binding.dispose();
                this.target.dispose();
                this.model.dispose();
            }
        }
    }

    private class ECPTableViewerComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int NONE = 0;
        private int direction = 0;

        ECPTableViewerComparator() {
        }

        public int getDirection() {
            switch (this.direction) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 128;
                }
                case 2: {
                    return 1024;
                }
            }
            return 0;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = (this.direction + 1) % 3;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return TableControlSWTRenderer.this.compare(viewer, e1, e2, this.direction, this.propertyIndex);
        }
    }

    private final class TableControlEditingSupportAndLabelProvider
    implements EditingSupportCreator,
    CellLabelProviderFactory {
        private final InternalEObject tempInstance;
        private final EStructuralFeature eStructuralFeature;
        private final VDomainModelReference dmr;
        private final IValueProperty valueProperty;
        private final IObservableMap observableMap;
        private CellEditor cellEditor;
        private ECPTableEditingSupport observableSupport;
        private boolean initialized;
        private final int indexOfColumn;

        private TableControlEditingSupportAndLabelProvider(InternalEObject tempInstance, EStructuralFeature eStructuralFeature, VDomainModelReference dmr, IValueProperty valueProperty, IObservableMap observableMap, int indexOfColumn) {
            this.tempInstance = tempInstance;
            this.eStructuralFeature = eStructuralFeature;
            this.dmr = dmr;
            this.valueProperty = valueProperty;
            this.observableMap = observableMap;
            this.indexOfColumn = indexOfColumn;
        }

        public EditingSupport createEditingSupport(TableViewer tableViewer) {
            if (!this.initialized) {
                this.init(tableViewer);
            }
            return this.observableSupport;
        }

        private void init(TableViewer tableViewer) {
            this.cellEditor = TableControlSWTRenderer.this.createCellEditor((EObject)this.tempInstance, this.eStructuralFeature, tableViewer.getTable());
            if (ECPCellEditorComparator.class.isInstance(this.cellEditor)) {
                TableControlSWTRenderer.this.columnIndexToComparatorMap.put(this.indexOfColumn, (ECPCellEditorComparator)ECPCellEditorComparator.class.cast(this.cellEditor));
            }
            this.observableSupport = new ECPTableEditingSupport((ColumnViewer)tableViewer, this.cellEditor, (VTableControl)TableControlSWTRenderer.this.getVElement(), this.dmr, this.valueProperty);
            this.initialized = true;
        }

        public CellLabelProvider createCellLabelProvider(TableViewer table) {
            if (!this.initialized) {
                this.init(table);
            }
            return new ECPCellLabelProvider(this.eStructuralFeature, this.cellEditor, this.observableMap, (VTableControl)TableControlSWTRenderer.this.getVElement(), this.dmr, table.getTable());
        }
    }

    private final class TableControlSWTRendererButtonBarBuilder
    implements ButtonBarBuilder {
        private EStructuralFeature structuralFeature;
        private EClass clazz;
        private EObject eObject;

        private TableControlSWTRendererButtonBarBuilder() throws DatabindingFailedException {
            this.setValues();
        }

        public void updateValues() throws DatabindingFailedException {
            this.setValues();
        }

        private void setValues() throws DatabindingFailedException {
            EStructuralFeature.Setting setting = TableControlSWTRenderer.this.getEMFFormsDatabinding().getSetting(TableControlSWTRenderer.this.getDMRToMultiReference(), TableControlSWTRenderer.this.getViewModelContext().getDomainModel());
            this.eObject = setting.getEObject();
            this.structuralFeature = setting.getEStructuralFeature();
            this.clazz = ((EReference)this.structuralFeature).getEReferenceType();
        }

        public void fillButtonComposite(Composite buttonComposite, TableViewer viewer) {
            int numButtons = TableControlSWTRenderer.this.addButtonsToButtonBar(buttonComposite);
            if (!((VTableControl)TableControlSWTRenderer.this.getVElement()).isAddRemoveDisabled()) {
                TableControlSWTRenderer.this.addButton = TableControlSWTRenderer.this.createAddRowButton(this.clazz, buttonComposite, this.eObject, this.structuralFeature);
                TableControlSWTRenderer.this.removeButton = TableControlSWTRenderer.this.createRemoveRowButton(this.clazz, buttonComposite, this.eObject, this.structuralFeature);
                numButtons += 2;
                this.initButtons(TableControlSWTRenderer.this.addButton, TableControlSWTRenderer.this.removeButton, viewer);
            }
            GridLayoutFactory.fillDefaults().numColumns(numButtons).equalWidth(false).applyTo(buttonComposite);
        }

        private void initButtons(final Button addButton, final Button removeButton, final TableViewer viewer) {
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableControlSWTRenderer.this.addRow(TableControlSWTRendererButtonBarBuilder.this.clazz, TableControlSWTRendererButtonBarBuilder.this.eObject, TableControlSWTRendererButtonBarBuilder.this.structuralFeature);
                    List containments = (List)TableControlSWTRendererButtonBarBuilder.this.eObject.eGet(TableControlSWTRendererButtonBarBuilder.this.structuralFeature, true);
                    if (TableControlSWTRendererButtonBarBuilder.this.structuralFeature.getUpperBound() != -1 && containments.size() >= TableControlSWTRendererButtonBarBuilder.this.structuralFeature.getUpperBound()) {
                        addButton.setEnabled(false);
                    }
                    if (containments.size() > TableControlSWTRendererButtonBarBuilder.this.structuralFeature.getLowerBound()) {
                        addButton.setEnabled(true);
                    }
                }
            });
            removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    if (selection == null || selection.getFirstElement() == null) {
                        return;
                    }
                    ArrayList<EObject> deletionList = new ArrayList<EObject>();
                    Iterator iterator = selection.iterator();
                    while (iterator.hasNext()) {
                        deletionList.add((EObject)iterator.next());
                    }
                    TableControlSWTRenderer.this.deleteRowUserConfirmDialog(deletionList, TableControlSWTRendererButtonBarBuilder.this.eObject, TableControlSWTRendererButtonBarBuilder.this.structuralFeature, addButton, removeButton);
                }
            });
        }

        public Object createNewElement(Button button) {
            throw new UnsupportedOperationException();
        }
    }

    private final class TableControlSWTRendererCompositeBuilder
    extends DefaultTableViewerCompositeBuilder {
        private TableControlSWTRendererCompositeBuilder() {
        }

        protected Label createValidationLabel(Composite topComposite) {
            Label validationLabel = TableControlSWTRenderer.this.createValidationIcon(topComposite);
            GridDataFactory.fillDefaults().hint(16, 17).grab(false, false).applyTo((Control)validationLabel);
            return validationLabel;
        }

        protected Composite createViewerComposite(Composite composite) {
            return TableControlSWTRenderer.this.createControlComposite(composite);
        }
    }

    private final class TableControlSWTRendererTableViewerCreator
    implements TableViewerCreator {
        private TableControlSWTRendererTableViewerCreator() {
        }

        public TableViewer createTableViewer(Composite parent) {
            VTFontPropertiesStyleProperty fontPropertiesStyleProperty;
            TableControlSWTRenderer.this.tableViewer = new TableViewer(parent, 68098);
            TableControlSWTRenderer.this.tableViewer.getTable().setData("org.eclipse.rap.rwt.customVariant", (Object)TableControlSWTRenderer.TABLE_CUSTOM_VARIANT);
            TableControlSWTRenderer.this.tableViewer.getTable().setHeaderVisible(true);
            TableControlSWTRenderer.this.tableViewer.getTable().setLinesVisible(true);
            VTBackgroundStyleProperty backgroundStyleProperty = TableControlSWTRenderer.this.getBackgroundStyleProperty();
            if (backgroundStyleProperty.getColor() != null) {
                TableControlSWTRenderer.this.tableViewer.getTable().setBackground(TableControlSWTRenderer.this.getSWTColor(backgroundStyleProperty.getColor()));
            }
            if ((fontPropertiesStyleProperty = TableControlSWTRenderer.this.getFontPropertiesStyleProperty()).getColorHEX() != null) {
                TableControlSWTRenderer.this.tableViewer.getTable().setForeground(TableControlSWTRenderer.this.getSWTColor(fontPropertiesStyleProperty.getColorHEX()));
            }
            TableControlSWTRenderer.this.tableViewer.getTable().setData(TableControlSWTRenderer.FIXED_COLUMNS, (Object)new Integer(1));
            return TableControlSWTRenderer.this.tableViewer;
        }
    }

    private class ValidationStatusCellLabelProvider
    extends CellLabelProvider {
        private final VTableControl vTableControl;

        ValidationStatusCellLabelProvider(VTableControl vTableControl) {
            this.vTableControl = vTableControl;
        }

        public void update(ViewerCell cell) {
            Integer mostSevere = 0;
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic == null) {
                return;
            }
            List diagnostics = vDiagnostic.getDiagnostics((EObject)cell.getElement());
            if (diagnostics.size() != 0) {
                mostSevere = ((Diagnostic)diagnostics.get(0)).getSeverity();
            }
            cell.setImage(TableControlSWTRenderer.this.getValidationIcon(mostSevere));
        }

        public String getToolTipText(Object element) {
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic == null) {
                return null;
            }
            String message = DiagnosticMessageExtractor.getMessage((Collection)vDiagnostic.getDiagnostics((EObject)element));
            return ECPTooltipModifierHelper.modifyString((String)message, null);
        }
    }

    private final class ViewerSelectionChangedListener
    implements ISelectionChangedListener {
        private ViewerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TableControlSWTRenderer.this.viewerSelectionChanged(event);
        }
    }
}

